/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/

/*	paul2.c:	function  qestf1() 
   	Author:		Xingkang Li
   	Date:   	July 1, 1997
*/

#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <localsys.h>

#ifdef CRAY
#define qestf1_ QESTF1
#endif
#ifdef hpux
#define qestf1_ qestf1
#endif

#ifndef M_PI
   #define M_PI 3.14159265358979323846 
#endif


/* 	qestf1: estimate the slope of short time Fourier transform 
 *	(	winLength: 	the width of the data selecting window; 
 *		freqNum:	the number of discrete frequency samples; 
 *		fitDataNum:	the number of the frequency samples used 
 *				for slope estimation;
 *		dataLength:	the length of the whole data; 
 *		data:		1-d data array;
 *		output:		1-d array of the estimate of the slope.  
 *		peakf:		1-d array of the integer peak frequency 
 *		peaka:		1-d array of the peak amplitude;
 *	)			 
 */ 
 
int qestf1_(int *winLength,int *freqNum,int *fitDataNum,int *dataLength,double *dt,int *nfs,double *data,double *output,double *peakf,double *peaka,double *xReal,double *xImag,double *xAbs,double *x1,double *cut, double *df )
{
  double slopeFit(int, double *);
  int adaptDFT(int, int, int, double, double, double *,double *, double *);
  
  double samplingPeriod = *dt;
  double sscale = *df;


  int i, j, k, n;
  int freqMax;
  double fac;
  double arg;
  double slope;
  double ave;
  double maxValue;
  double last_slope;
  double last_peakf;
  int N = *nfs;
  int NF= *fitDataNum;

/*  I am commenting this next part out and allocating memory in
    the main as we are getting a segmentation fault here and I
    cannot see why...pgag

    double *xReal, *xImag, *xAbs, *x1;

  printf(" before malloc N =  %d \n", N);

  xReal= malloc((N+1)*sizeof(double));
  printf(" after malloc 1 N =  %d \n", N);
  xImag= malloc((N+1)*sizeof(double));
  printf(" after malloc 2 N =  %d \n", N);
  xAbs= malloc((N+1)*sizeof(double));
  printf(" after malloc 3 N =  %d \n", N);
  x1= malloc((N+1)*sizeof(double));

  printf(" past malloc N =  %d \n", N);
*/  

/*
 fac = sscale*N*samplingPeriod;
*/
/* xia */
  fac = 1./(*df);


  /* Calculate the initial DFT */
  for (k=0;k<=N;k++)   /*  loop over freqs  */
  {   
      xReal[k]=0.0;
      xImag[k]=0.0;
      for (n=0;n<*winLength;n++)  /*  for each freq loop over window samples  */
      {   
        arg = 2.0*M_PI*((double) k)*((double) n) / *freqNum;
        xReal[k] += data[n]*cos ( arg );
        xImag[k] -= data[n]*sin ( arg );
      }
      xAbs[k]= xReal[k]*xReal[k] + xImag[k]*xImag[k];
  }


  /* Find the value and the location of the maximum */

  for (i=0; i<=*dataLength-*winLength;i++) {       
      maxValue=0.0;
      freqMax=0;
      for (j=0;j<N;j++)
      {   if (maxValue <= xAbs[j])
          {  maxValue=xAbs[j];
             freqMax=j;
	     peakf[i] = freqMax;
	     peaka[i] = sqrt (maxValue);
          }
      }

/*
 if ( i > 700 && i < 800) {
 if ( i%10 == 0 ) {
 for (j=1;j<=N;j++) fprintf(stderr,"%d  %f\n",j,xAbs[j]);
 fprintf(stderr,"\n");
 }
 }
*/

      /* Find the logarithm of the normalized DFT */
      for (j=freqMax;j<=N;j++) {
          x1[j-freqMax]=10.*log10(xAbs[j]/maxValue); 
      }
          
      NF = *cut * (N-freqMax+1);
      slope = slopeFit(NF,x1);
      output[i]=slope * fac;
      adaptDFT(*winLength, *freqNum, N, data[i], data[i+ *winLength],
                xReal, xImag, xAbs); 
  }

  last_peakf = peakf[*dataLength-*winLength];
  last_slope = output[*dataLength-*winLength];

  for (i=*dataLength-*winLength+1; i<*dataLength;i++) {
      output [i] = last_slope;
      peakf  [i] = last_peakf;
      peaka  [i] = 0.0;
  }
  
}
