C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c*********************************************************************c
c qest read traces of data and computes continuously time-variant     
c amplitude spectra with a DFT over user-specified window.  From the
c spectra, attenuation (Q) is estimated from the slope of the log of    
c the spectrum relative to the maximum amplitude.
c**********************************************************************c
c
c     declare variables
c
c-----
c    get machine dependent parameters

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h>
c-----
 
      integer     itr ( SZLNHD )
      integer     lhed( SZLNHD )
      integer     nsamp, nsi, ntrc, nrec, iform, obytes
      integer     luin , lbytes, nbytes
      integer     irs,ire,ns,ne
      integer     recnum, trcnum, static, flim
      integer     argis, pipe1, pipe2

      real        null
      real        tri ( 2*SZLNHD )

      character   ntap * 512, otap * 512, name*4, ftap*512
      character   atap * 512

      logical     verbos, query,ftape,smooth,mem,dft,atape,L2
      logical     cen, top, bot, raw

c dynamic memory variables

      integer     abort1

      real * 8    work1, work2, work3, work4
      real        work
      real        qq, pf
      real        ampls
      real * 8    xReal, xImag, xAbs, x1

      pointer     (pwork1,work1(1)),(pwork2,work2(1)),(pwork3,work3(1))
      pointer     (pwork4,work4(1))
      pointer     (pwork,work(1))
      pointer     (pqq,qq(1)),(ppf,pf(1))
      pointer     (pampl,ampls(1))
      pointer     (pxReal,xReal(1))
      pointer     (pxImag,xImag(1))
      pointer     (pxAbs,xAbs(1))
      pointer     (pxx1,x1(1))

 
c     equivalence ( itr(1), tri (1) )
      equivalence ( itr(  1), lhed(1) )
      data name/'QEST'/
      DATA  pipe1/3/
      DATA  pipe2/4/
 
c-----
c     read program parameters from command line card image file
c-----

      query = ( argis ( '-?' ) .gt. 0 ).or.(argis('-h').gt.0)
      if ( query )then
            call help(ler)
            stop
      endif
 
c-----
c     open printout files
c     this consists of a 2-character identifier, the process id number,
c     and the child process id number:
c     XY.nnnnn.mmmmm
c     this should be unique even for multiple occurences of the same
c     process in a pipeline
c-----
#include <f77/open.h>
 
      call gcmdln(ntap,otap,ftap,irs,ire, mode, lwin, thresh,
     : cut,smooth,verbos,morder,mem,dft,ftape,atape,atap,
     : null,L2,cen, top,bot,flim,raw)

      if (lwin.eq.0) lwin = 300
      if ( mem ) then
         if (cut .eq. 0.0) cut = .25
      elseif (dft) then
         if (cut .eq. 0.0) cut = .50
      else
         if (cut .eq. 0.0) cut = .75
      endif
      if (cut .gt. 1.)then
        write(LERR,*)'Highcut frequency cannot exceed Nyquist!'
        write(LER ,*)'Highcut frequency cannot exceed Nyquist!'
        stop
      endif
      write(LERR,*)' '
      write(LERR,*)'Fraction of nyquist to fit spectrum =  ',cut


c-----
c     get logical unit numbers for input and output of seismic data
c     0 = default stdin
c     1 = default stdout
c-----
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

      if (ftape) then
         if (ftap(1:1) .ne. ' ') then
            call getln (luf, ftap, 'w', -1)
         else
            call sisfdfit (luf, pipe1)
         endif
         if (luf .lt. 0) then
            write(LER,*)'qest: unable to open output peak freq DSN'
            go to 918
         endif
      endif

      if (atape) then
         if (atap(1:1) .ne. ' ') then
            call getln (lua, atap, 'w', -1)
         else
            call sisfdfit (lua, pipe2)
         endif
         if (lua .lt. 0) then
            write(LER,*)'qest: unable to open output peak ampl DSN'
            if (ftape) call lbclos (luf)
            go to 918
         endif
      endif


c-----
c     read line header of input
c     save certain parameters
c-----
      lbytes = 0
      call rtape  ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'QEST: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif

c------
c     to get and/or put LINE header values please use saver/savew
c     since that way code will always be portable to whatever machine
c     we maintain usp on
c     saver/w refer to header words using mnemonics rather than position
c
c     see saver/w manual pages
c------
      call savelu('NumSmp',ifmt_NumSmp,l_NumSmp,ln_NumSmp,LINEHEADER)
      call savelu('SmpInt',ifmt_SmpInt,l_SmpInt,ln_SmpInt,LINEHEADER)
      call savelu('NumTrc',ifmt_NumTrc,l_NumTrc,ln_NumTrc,LINEHEADER)
      call savelu('NumRec',ifmt_NumRec,l_NumRec,ln_NumRec,LINEHEADER)
      call savelu('Format',ifmt_Format,l_Format,ln_Format,LINEHEADER)

      call saver2(itr,ifmt_NumSmp,l_NumSmp,ln_NumSmp,nsamp,LINEHEADER)
      call saver2(itr,ifmt_SmpInt,l_SmpInt,ln_SmpInt,nsi,LINEHEADER)
      call saver2(itr,ifmt_NumTrc,l_NumTrc,ln_NumTrc,ntrc,LINEHEADER)
      call saver2(itr,ifmt_NumRec,l_NumRec,ln_NumRec,nrec,LINEHEADER)
      call saver2(itr,ifmt_Format,l_Format,ln_Format,iform,LINEHEADER)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif
   
      fsr = float(nsi) * unitsc
      nsr = nsi
      dt = fsr

      wl   = unitsc * lwin
      df   = 1 / wl
      lwin = lwin/nsr
      lwin = lwin/2*2+1
      fn   = 1./(2.*fsr)
      fup  = cut*fn
      
c---
c  nfreqfit is the total number of frequencies 
c  nfstop is the number calculated which will reach nyquist
c  in the sine/cosine argumants in the paul*.c subroutine
c---
c      nfreqfit = fn / df
cxia - number of frequencies = Period = #of discret samples
      nfreqfit = lwin
      nfstop   = (nfreqfit - 1)/2

      write(LERR,*)' Sample interval             =  ',dt
      write(LERR,*)' Delta frequency             =  ',df
      write(LERR,*)' Nyquist                     =  ',fn
      write(LERR,*)' Number of freqs to nyquist  =  ',nfreqfit
      write(LERR,*)' Number of freqs to fit      =  ',nfstop

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('VPick1',ifmt_VPick1,l_VPick1,ln_VPick1,TRACEHEADER)


      lname = 4
      call hlhprt (itr, lbytes, name, lname, LERR)

c-----
c     ensure that command line values are compatible with data set
c     (i.e. start/end traces; start/end records)
c-----
      ns = 1
      ne = ntrc
      if(irs.eq.0)irs=1
      call cmdchk(ns,ne,irs,ire,ntrc,nrec)
      if(ire.eq.0)ire=999999
      if(ire.le.999999)then
       nreco = ire-irs+1
       call savew(itr,'NumRec',nreco,LINHED)
      endif

      call savhlh(itr,lbytes,lby)
      call wrtape(luout,itr,lby)
      if(ftape)then
       call wrtape(luf,itr,lby)
      endif
      if(atape)then
       call wrtape(lua,itr,lby)
      endif

      if ( (morder .gt. lwin/4) .and. mem ) then
         write(LERR,*)'FATAL ERROR in qest (MEM option):'
         write(LERR,*)'order too high: ',morder
         write(LER ,*)'FATAL ERROR in qest (MEM option):'
         write(LER ,*)'order too high: ',morder
         call ccexit (666)
      endif
      if (mod(morder,2) .eq. 0) then
         morder = morder + 1
         write(LERR,*)'WARNING in qest (MEM option):'
         write(LERR,*)'Order must be odd.  Resetting to ',morder
      endif
      if (mem) then
         write(LERR,*)' Max entropy order       =  ',morder
         if (morder .gt. 3) then
             flim = 2 * morder
         endif
      endif

c---------------------------------------------------
c  malloc space we are going to use

c  note also ISZBYT is the 
c  size of an item in bytes
c--------------------------

c - switch from machine-dependent to generic memory allocation
c - j.m.wade 8/20/92

      ier = 0
      jer  = 0
      iget = (nsamp+lwin) * ISZBYT
      iXget = ( nfreqfit + 1 ) * 2 * SZSMPD
      abort1 = 0
      
cprg----
      call galloc (pampl, iget, jer, abort1)
      memsum=memsum+iget
      if(jer.ne.0)ier=ier+1
      call galloc (pwork, iget, jer, abort1)
      memsum=memsum+iget
      if(jer.ne.0)ier=ier+1
      call galloc (pwork1, 2*iget, jer, abort1)
      memsum=memsum+2*iget
      if(jer.ne.0)ier=ier+1
      call galloc (pwork2, 2*iget, jer, abort1)
      memsum=memsum+2*iget
      if(jer.ne.0)ier=ier+1
      call galloc (pwork3, 2*iget, jer, abort1)
      memsum=memsum+2*iget
      if(jer.ne.0)ier=ier+1
      call galloc (pwork4, 2*iget, jer, abort1)
      memsum=memsum+2*iget
      if(jer.ne.0)ier=ier+1
      call galloc (pqq,   iget, jer, abort1)
      memsum=memsum+iget
      if(jer.ne.0)ier=ier+1
      call galloc (ppf,   iget, jer, abort1)
      memsum=memsum+iget
      if(jer.ne.0)ier=ier+1

      call galloc (pxReal, iXget, jer, abort1)
      memsum=memsum+iXget
      if(jer.ne.0)ier=ier+1
      call galloc (pxImag, iXget, jer, abort1)
      memsum=memsum+iXget
      if(jer.ne.0)ier=ier+1
      call galloc (pxAbs, iXget, jer, abort1)
      memsum=memsum+iXget
      if(jer.ne.0)ier=ier+1
      call galloc (pxx1, iXget, jer, abort1)
      memsum=memsum+iXget
      if(jer.ne.0)ier=ier+1

      if (ier.ne.0) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) memsum,'  bytes'
         write(LERR,*)' '
         write(LER,*) 'QEST: '
         write(LER,*)' Unable to allocate workspace:'
         write(LER,*)' ', memsum,'  bytes'
         write(LER,*)'FATAL '
         write(LER,*)' '
         call lbclos(luin)
         stop  
      else
         write(LERR,*)' '
         write(LERR,*)'allocate workspace:'
         write(LERR,*) memsum,'  bytes'
         write(LERR,*)' '
      endif

c----------------------
c  number output bytes
      obytes = SZTRHD + nsamp * ISZBYT

c-----
c     verbose output of all pertinent information before
c     processing begins
c-----
       jwin = lwin * nsr
       call verbal(nsamp, nsi, ntrc, nrec, iform,
     :             mode, jwin, ntap,otap, dft, mem,
     :             ftape, atape, ftap, atap, L2, cen, top, bot,
     :             raw)
c--------------------------------------------------
c-----
c     BEGIN PROCESSING
c     read trace, do terrible things to data, write to output file
c-----
c-----
c     skip unwanted records
c-----
      if(irs.gt.1)then
      do i=1,irs-1
       do j=1,ntrc
        nit = 0
        call rtape(luin,itr,nit)
        if(nit.eq.0)then
         write(LER,*)' EOF on input before first record. Fatal!'
         write(LERR,*)'EOF on input before first record. Fatal!'
         call lbclos(luin)
         stop
        endif
       end do
      end do
      endif

c-----
c     process desired trace records
c-----
      do while (irs .le. ire)

       do nn = 1,ntrc

           nbytes = 0
           call rtape( luin, itr, nbytes)
           if(nbytes .eq. 0) then
               write(LERR,*)'End of file on input:'
               write(LERR,*)'  rec= ',irs,'  trace= ',nn
               call lbclos(luin)
               call lbclos(luout)
               stop
           endif

c------
c     grab data samples and test for a zero trace
c------
        call vmov (itr(ITHWP1), 1, tri, 1, nsamp)
        call dotpr (tri, 1, tri, 1, xdot, nsamp)

c------
c     get some necessary trace header values.               
c------
        call saver2(itr,ifmt_StaCor,l_StaCor,ln_StaCor,
     :      static, TRACEHEADER)
        if (xdot .eq. 0.0) static = 30000
        

        IF (static .ge. 30000) THEN

         do mm=1,nsamp
          tri(mm)=0.
         end do
         if(ftape)then
          call savew2(itr,ifmt_TrcNum,l_TrcNum,ln_TrcNum,1,TRACEHEADER)
          call vmov (tri, 1, itr(ITHWP1), 1, nsamp)
          call wrtape(luf,itr,obytes)
         endif
         if(atape)then
          call savew2(itr,ifmt_TrcNum,l_TrcNum,ln_TrcNum,1,TRACEHEADER)
          call vmov (tri, 1, itr(ITHWP1), 1, nsamp)
          call wrtape(lua,itr,obytes)
         endif
         call savew2(itr,ifmt_TrcNum,l_TrcNum,ln_TrcNum,1,TRACEHEADER)
         call vmov (tri, 1, itr(ITHWP1), 1, nsamp)
         call wrtape(luout,itr,obytes)

        ELSE



         call getqpf (tri, nsamp, lwin, nfreqfit, dt, null, L2, df,
     1                qq, pf, ampls, work1, work2, work3, work4,
     2                mem, morder, nfstop, xReal, xImag, xAbs, x1,
     3                cen,top,bot,cut,flim,raw)

          call detmut (qq, mut_start, nsamp)
          mutt_start = mut_start * nsi
          call savew2(itr,ifmt_VPick1,l_VPick1,ln_VPick1,
     1                mutt_start, TRACEHEADER)

         if(smooth)then
          call runavg(qq,nsamp,15,work)
          do i=1,nsamp
           tri(i)=work(i)
          end do
         else
          do i=1,nsamp
           tri(i)=qq(i)
          end do
         endif
c----
c   put null Q value into trace mute zone
c----
         if (mut_start .gt. 0) then
            do  i = 1, mut_start
                tri (i) = null
            enddo
         endif

          call savew2(itr,ifmt_TrcNum,l_TrcNum,ln_Trcnum,1,TRACEHEADER)
          call vmov (tri, 1, itr(ITHWP1), 1, nsamp)
          call wrtape(luout,itr,obytes)

         if(ftape)then

          if(smooth)then
              call runavg(pf,nsamp,15,work)
              do i=1,nsamp
                  wi = work (i)
                  if (wi .lt. 0.0) wi = 0.0
                  tri(i)= wi
              end do
          else
              do i=1,nsamp
                  pfi = pf (i)
                  if (pfi .lt. 0.0) pfi = 0.0
                  tri(i)= pfi
              end do
          endif
          call resmut (tri, mut_start, nsamp)

          call savew2(itr,ifmt_TrcNum,l_TrcNum,ln_Trcnum,1,TRACEHEADER)
          call vmov (tri, 1, itr(ITHWP1), 1, nsamp)
          call wrtape(luf,itr,obytes)

          endif

         if(atape)then
 
          if(smooth)then
              call runavg(ampls,nsamp,15,work)
              do i=1,nsamp
                  wi = work (i)
                  if (wi .lt. 0.0) wi = 0.0
                  tri(i)= wi
              end do
             else
              do i=1,nsamp
                  ampi = ampls (i)
                  if (ampi .lt.  0.0) ampi = 0.0
                  tri(i)= ampi
              end do
          endif
          call resmut (tri, mut_start, nsamp)


          call savew2(itr,ifmt_TrcNum,l_TrcNum,ln_Trcnum,1,TRACEHEADER)
          call vmov (tri, 1, itr(ITHWP1), 1, nsamp)
          call wrtape(lua,itr,obytes)

         endif

        ENDIF

       end do    
       if(verbos)write(LERR,*)'ri ',recnum,' trace ',trcnum
       irs = irs+1
      end do

c-----
c     close data files
c-----

      if(ftape)call lbclos(luf)
      if(atape)call lbclos(lua)

      write(LERR,*)'end of qest, processed',nrec,' record(s)',
     :               ' with ',ntrc, ' traces'
      write(LER ,*)'end of qest, processed',nrec,' record(s)',
     :               ' with ',ntrc, ' traces'

918   continue
      call lbclos ( luin )
      call lbclos (luout)

      stop
      end
 
C***********************************************************************
      subroutine help(ler)
      integer ler
         write(LER,*)
     :'***************************************************************'
        write(LER,*) ' '
        write(LER,*)
     :'qest computes an estimate of the quality factor (Q) for     '
        write(LER,*)
     :'seismic data through a least squares estimation procedure.'
        write(LER,*)
     :'see manual pages for details ( online by typing uman prg )'
        write(LER,*)' '
        write(LER,*)
     :'execute qest by typing qest and the of program parameters'
        write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
        write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
        write(LER,*)' '
        write(LER,*)
     :' -N [ntap]    (stdin)              : input data file name'
        write(LER,*)
     :' -O [otap]    (stdout)             : output data file name'
        write(LER,*)
     :' -O2 [ftap]   (optional)           : peak freq data file name'
        write(LER,*)
     :' -A  [atap]   (optional)           : peak ampl data file name'
        write(LER,*)
     :' -rs[irs]     (default = first)    : start record number'
        write(LER,*)
     :' -re[ire]     (default = last)     : end record number'
        write(LER,*)
     :' -w[lwin]    (default = 300 ms)    : window length (ms) '
        write(LER,*)
     :' -fc[highcut] (default = 1.0)      : Max frequency, as fraction'
        write(LER,*)
     :'                                     of Nyquist frequency, to'
        write(LER,*)
     :'                                     be used in slope est.'
c       write(LER,*)
c    :' -th[threshold] (default = 12.)    : threshold, in dB, for '
        write(LER,*)
     :' -null[null]  (default=500)        : null Q value'
        write(LER,*)
     :'                                     power spectrum notches'
        write(LER,*)
     :' -smooth[smooth on] (def = off)    : if  present, turn on '
        write(LER,*)
     :'                                     vertical smoothing of '
        write(LER,*)
     :'                                     output Q and PF traces'
        write(LER,*)
     :' -ord[mord]   (def = 3)         : max entropy order (points)'
        write(LER,*)
     :' -flim[mord]  (def = 3)         : max entropy # freqs to fit'
        write(LER,*) ' '
        write(LER,*) ' '
        write(LER,*)
     :' -M  include on cmd line to use maximum entropy spectral method'
        write(LER,*)
     :' -top output Qs hung from top of window'
        write(LER,*)
     :' -bot output Qs hung from bottom of window, else window centered'
        write(LER,*)
     :' -cen output Qs hung from center of window'
        write(LER,*)
     :' -L2 include on command line to use L2 (least squares) slope fit'
        write(LER,*)
     :'     otherwise L1 norm will be used'
        write(LER,*)
     :' -PF  output optional peak frequency data set'
        write(LER,*)
     :' -PA  output optional peak amplitude data set'
        write(LER,*)
     :' -R  include on command line for raw Q, otherwise'
        write(LER,*)
     :'     output Qs will be absolute'
        write(LER,*)
     :' -V  include on command line if verbose printout is desired'
        write(LER,*)
     :'usage: qest -N[ntap] -O[otap] -O2[otap2] -A[atap] -rs[irs]'
        write(LER,*)
     :' -re[ire] -w[lwin] -fc[fcut] -flim[flim] -ord[mord]'
        write(LER,*)
     :' -null[null] -R -PF -PA -M -L2 [-top -bot -cen] -smooth -V'
        write(LER,*)' Example:'
        write(LER,*)'qest -Nmy_data -Omy_output -rs1 -re100 -w300',
     :' -fc0.5 -th18.0'
        write(LER,*) ' '
        write(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
      subroutine gcmdln(ntap,otap,ftap,irs,ire, mode, lwin, thresh,
     : cut, smooth,verbos,morder,mem,dft,ftape,atape,atap,
     : null,L2,cen,top,bot,flim,raw)
c-----
c     get command arguments
c
c     ntap  - C*100    input file name
c     otap  - C*100    output file name
c     irs   - I*4      starting record index
c     ire   - I*4      ending record index
c     mode  - I*4      slope extract mode
c                      0 = look forward from fmax
c                      1 = look backward from fmax
c                      2 = use spectral ratios over full width
c     lwin  - I*4      window length (default = 500 ms)
c     thresh- R*4      minimum value for kernel to be used in regression
c     cut   - R*4      Fraction of Nyquist at which to truncate
c                      regression computations.
c     smooth- L*$      smooth output
c     verbos  L        verbose output or not
c-----
#include <f77/iounit.h>
      character   ntap*(*), otap*(*), ftap*(*), atap*(*)
      integer     irs, ire, mode, lwin, morder, flim
      logical     verbos,smooth,mem,dft,ftape,atape,L2
      logical     cen, top, bot, raw
      integer     argis
      real        null
 
c-------
c     see manual pages on the argument handler routines
c     for the meanings of these functions
c-------
            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O2',ftap, ' ', ' ' )
            call argstr( '-A', atap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )

            call argi4 ( '-ord', morder ,   3  ,  3    )
            call argi4 ( '-flim', flim ,   3  ,  3    )

            top = (argis('-top').gt.0)
            bot = (argis('-bot').gt.0)
            cen = (argis('-cen').gt.0)
            if (.not.cen .AND. .not.top .AND. .not.bot) then
               top = .true.
            endif

            call argi4 ( '-rs', irs ,   0  ,  0    )
            call argi4 ( '-re', ire ,   0  ,  0    )
            call argi4 ( '-md', mode,  0, 0 )
            call argr4 ( '-th', thresh,12.0,12.0)
            call argi4 ( '-w' , lwin,  300, 300)
            call argr4 ( '-fc', cut, 0.0, 0.0)
            call argr4 ( '-null', null, 500., 500.)

            smooth = .false.
            smooth = (argis('-smooth').gt.0)
            dft    =   .true.
            mem    =   (argis('-M') .gt. 0)
            if (mem) dft = .false.
            ftape  =   (argis('-PF') .gt. 0)
            atape  =   (argis('-PA') .gt. 0)
            L2       =   (argis('-L2') .gt. 0)
            raw    =   (argis('-R') .gt. 0)
            verbos =   (argis('-V') .gt. 0)
 
      return
      end
 
      subroutine verbal(nsamp, nsi, ntrc, nrec, iform,
     :                  mode, lwin, ntap,otap, dft, mem,
     :                  ftape, atape, ftap, atap, L2,cen,top,bot,
     :                  raw)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4     number of samples in trace
c     vel   - R*4     design velocity
c     nsi   - I*4     sample interval in ms
c     ntrc  - I*4     traces per record
c     nrec  - I*4     number of records per line
c     iform - I*4     format of data
c     ntap  - C*100   input file name
c     otap  - C*100   output file name
c-----
#include <f77/iounit.h>

      integer     nsamp, nsi, ntrc, nrec
      character   ntap*(*), otap*(*), ftap*(*), atap*(*)
      logical     dft, mem, ftape,  atape, L2, top, cen, bot
      logical     raw
 
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace   =  ', nsamp
            write(LERR,*) ' sample interval      =  ', nsi
            write(LERR,*) ' traces per record    =  ', ntrc
            write(LERR,*) ' records per line     =  ', nrec
            write(LERR,*) ' format of data       =  ', iform
            write(LERR,*) ' input data set name  =  ', ntap
            write(LERR,*) ' output data set name =  ', otap
            write(LERR,*) ' mode                 =  ', mode
            write(LERR,*) ' window length        =  ', lwin,' ms'
            if (dft)
     1      write(LERR,*) ' fourier spectral method used'
            if (mem)
     1      write(LERR,*) ' maximum entropy spectral method used'
            write(LERR,*)' '
            if (ftape)
     1      write(LERR,*) ' output peak freq data set name = ',ftap
            if (atape)
     1      write(LERR,*) ' output peak ampl data set name = ',atap
            if (L2) then
            write(LERR,*) ' use L2 (least squares) slope fitter'
            else
            write(LERR,*) ' use L1 slope fitter'
            endif
            if (raw) then
            write(LERR,*) ' Use raw Q (not time weighted)'
            else
            write(LERR,*) ' Use time weighted (absolute) Q'
            endif
            if (top) then
            write(LERR,*) ' Qs hung from top of analysis window'
            elseif (cen) then
            write(LERR,*) ' Qs hung from center of analysis window'
            elseif (bot) then
            write(LERR,*) ' Qs hung from bottom of analysis window'
            endif
            write(LERR,*)' '
 
      return
      end

      integer function get_nwin(istrt,lwin,igap,nsamp)
      nwin=0
      iend=lwin
      do while(iend.lt.nsamp)
       nwin=nwin+1
       istrt=istrt+igap
       iend=istrt+lwin
       if(iend.ge.nsamp.and.istrt.lt.nsamp)then
        nwin=nwin+1
       endif
      end do
      get_nwin = nwin
      return
      end
