      subroutine cvsum(filt1,lf1,filt2,lf2,data,scalv,outdat,lx,n,
     1                 fact,iflg,mode,kf,fpass,imute,phz,ierr)
C
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                      *
C***********************************************************************
C  ROUTINE:       CVSUM
C  ROUTINE TYPE:  SUBROUTINE  (SINGLE-ENTRY)
C  PURPOSE:
C
C       CVSUM(FILT1,LF1,FILT2,LF2,DATA,SCALV,OUTDAT,LX,N,FACT,iflg)
C  ARGUMENTS:
C      NAME                   LENGTH   DESCRIPTION
C      FILT1  R*4  I  ( 1 )    LF1      INPUT FILTER 1 ARRAY.
C      LF1    I*4  I           1        LENGTH OF BB.
C      FILT2  R*4  O  ( 1 )    LF2      INPUT FILTER 2 ARRAY.
C      LF2    I*4  I           1        LENGTH OF CC.
C      DATA   R*4  I  ( 1 )    LX       INPUT DATA ARRAY.
C      SCALV  R*4  I  ( 1 )    LX       SCALING VECTOR
C      OUTDAT R*4  O  ( 1 )    LX       OUTPUT ARRAY
C      LX     I*4  I           1        LENGTH OF AA AND DD
C      N      I*4  I           1        NUMBER OF TERMS TO SUM
C      FACT   R*4  I           1        INVERSE FACTORIAL ARRAY
C      iflg   I*4  I           1        EQ 0  = NO LAG
C                                       NE 0  = FILTER 1 LAG
C                                               WILL SHIFT DATA TO RIGHT
C                                               BY LF1 / 2 AFTER REVERSE
C  CATEGORY:  UTILITY
C  AUTHOR:    M. TORLINE                       ORIGIN DATE: 10/10/85
C  REVISED BY: R. Crider                              DATE: 07/02/91
C  REVISED BY: G. Xia                                 DATE: 10/30/00
C  ROUTINES CALLED:
C      -       MATH ADVANTAGE
C
C***********************************************************************
#include <f77/lhdrsz.h>
#include <f77/iounit.h>

      REAL    DATA(2*SZLNHD),FILT1(2*SZLNHD),FILT2(2*SZLNHD)
      REAL    OUTDAT(2*SZLNHD),SCALV(2*SZLNHD),FACT(2*SZLNHD)
      REAL*8  BIDQ(2*SZLNHD), BPOW(2*SZLNHD)
      REAL*8  BDUM(2*SZLNHD)
      REAL    work(2*SZLNHD), wrk1(2*SZLNHD)

      real    rms(35)
      real    rms_change, eps, rms_change0
      integer ierr
      logical phz

C
      ierr = 0
      eps = 0.00001
      L = 1
      lxx = lx + lx
      i=1
      iloc=imute
      if(iloc.eq.lx)then
       do i=1,lx
        outdat(i)=0.
       end do
       return
      endif
      lclr = (lx + lf1-1)
      do i=lx+1,lclr
       work(i)=0.
      end do
      do i=1,lx
        work(i)=data(i)
      end do
* +====================================+
* |    bidq = data & f1                |
* |  Convolve the bandlimiting filter  |
* |  with the data                     |
* +====================================+
      if(fpass.eq.0.0)then
       call fold (lf1, filt1, lx, work, nfold, wrk1)
       do  i = 1, lx
        bidq(i) = wrk1(i+kf)
       end do
      else
       do i=1,lx
        bidq(i) = work(i)
       end do
      endif

      lclr = (lx+lf2-1)
      do i=lx+1, lclr+lclr
       work(i)=0.
      end do
      do  12  i = 1, lx
          work(i) = bidq(i)
12    continue
* +==================================+
* |    bdum = data & f1 & f2         |
* |  Convolve the q filter with the  |
* |  data.                           |
* +==================================+
      call fold (lf2, filt2, lx, work, nfold, wrk1)
      IF (.NOT. PHZ) THEN
        do  9  i = 1, lx
          bdum(i) = wrk1(i)
9       continue
      ELSE
        do 19 i = 1, lx
          bdum(i) = wrk1(i+lf2/2)
19      enddo
      ENDIF
* +========================================+
* |  bidq = data & f1 & f2 * y + data & f1 |
* |  Begin the running sum of convolved    |
* |  results                               |
* +========================================+
      do  14  i = 1, lx
          bpow(i) = scalv(i)
14    continue
      if (iloc .gt. 0) then
       do  i = 1, iloc
        bpow(i) = 0.
       end do
      endif
      do   i = 1, lx
cc          bidq(i) = bidq(i) + bdum(i) * scalv(i)
          bidq(i) = bidq(i) + bdum(i) * bpow(i)
      enddo

	rms(1) = 0
	do  i = 1, lx
	    rms(1) = rms(1) + sqrt( bidq(i)*bidq(i) )
	enddo
c	write(0,*) rms(1)

      DO  50  j = 2, N

        do i= lx+1,lxx
         work(i)=0.
        end do
        do  20  i = 1, lx
         work(i) = bdum(i)
20      continue

* +===================================+
* |  bdum = data & f1 & f2 & f2       |
* |  Convolve the q filter with       |
* |  previous convolved results       |
* |  Note that it is this continuous  |
* |  convolution that gives the       |
* |  underflows in the result.  Will  |
* |  have to go to double precision   |
* |  to eliminate the underflows      |
* +===================================+
        call fold (lf2, filt2, lx, work, nfold, wrk1)
        IF(.NOT.PHZ) then
          do  i = 1, lx
            bdum(i) = wrk1(i)
	    bpow(i) = bpow(i) * scalv(i)
          end do
         ELSE
           do  i = 1, lx
            bdum(i) = wrk1(i+lf2/2)
            bpow(i) = bpow(i) * scalv(i)
          end do
         ENDIF


C Correct for the terms starting from the second term according to
C Hale's 1986 paper

        do  i = 1, lx
cc            bidq(i) = bidq(i) + fact(j) * bdum(i) * scalv(i) * bpow(i)
            bidq(i) = bidq(i) + fact(j) * bdum(i) *  bpow(i)
        end do

C************************************
C Measure RMS to provide convergen criteria
C If however the series diverges, stop the iteration
	rms(j) = 0
	do  i = 1, lx
	    rms(j) = rms(j) + sqrt( bidq(i)*bidq(i) )
	enddo
        rms_change0 = abs( (rms(j)-rms(1))/rms(1) )
        rms_change = abs( (rms(j)-rms(j-1))/rms(j-1) )
	if (rms_change .LE. eps) goto 99
	if (rms_change0 .GE. 1./eps) then 
            ierr = 1
            goto 99
        endif
c************************************
50    CONTINUE

 99   continue
      if (.NOT.PHZ) then
      do  i = 1, lx
          outdat(i) = bidq(i)
      end do
      else
      outdat(1) = 0.0
      do  i = 2, lx
          outdat(i) = bidq(i-1)
      end do
      endif


      return
      end
