C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       ???                                                  *
C  ROUTINE TYPE:  MAIN                                                 *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:  MAINLINE ENTRY                                       *
C  ARGUMENTS:     NONE                                                 *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 93/07/23  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 93/07/23  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      FUNCTI  REAL    -                                               *
C      ARGIS   INTEGER -                                               *
C      HELP            -                                               *
C      OPENPR          -                                               *
C      CMDLN           -                                               *
C      GETLN           -                                               *
C      SISFDF          -                                               *
C      RTAPE           -                                               *
C      SAVER           -                                               *
C      HLHPRT          -                                               *
C      CMDCHK          -                                               *
C      GALLOC          -                                               *
C      SAVEW           -                                               *
C      SAVHLH          -                                               *
C      WRTAPE          -                                               *
C      VERBAL          -                                               *
C      SKPREC          -                                               *
C      VMOV            -                                               *
C      V2      REAL    -                                               *
C      V4      REAL    -                                               *
C      DOTPR           -                                               *
C      VRAND           -                                               *
C      RECSKP          -                                               *
C      SKIPT           -                                               *
C      TRCSKP          -                                               *
C      VCLR            -                                               *
C      WORK    REAL    -                                               *
C      BDSUB           -                                               *
C      Z       REAL    -                                               *
C      LBCLOS          -                                               *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      ABS     GENERIC -                                               *
C      REAL    REAL    -                                               *
C      IABS    INTEGER -                                               *
C      FLOAT   REAL    -                                               *
C  FILES:                                                              *
C      LER   ( OUTPUT SEQUENTIAL ) -                                   *
C      LERR  ( OUTPUT SEQUENTIAL ) -                                   *
C      LOT   ( OUTPUT SEQUENTIAL ) -                                   *
C      LUXY  ( OUTPUT SEQUENTIAL ) -                                   *
C  COMMON:           NONE                                              *
C  STOP CODES:                                                         *
C      =BLANK=  (10) -                                                 *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:      8 DETECTED                               *
C      INTEGER*                                                        *
C      POINTER     (WKADR1, V2(200000))                                *
C      POINTER     (WKADR2, V4(200000))                                *
C      POINTER     (WKADR3, Z(200000))                                 *
C      POINTER     (WKADR4, RNUM(200000))                              *
C      POINTER     (WKADR5, T(200000))                                 *
C      POINTER     (WKADR6, WORK(200000))                              *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
c -----------------------QNMO------------------------------------------72
c
c Author>Ilya Tsvankin (TRC:X4306)
c
c qnmo accesses both seismic amplitude and velocity tapes.  In this instance
c the velocity tape is that output from USP routine velquar.  qnmo performs
c quartic moveout correction using the V2 and V4 information from the input
c velocity tape.  The output is a moveout corrected record.
c
c<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
c
c     declare variables
c
c-----
c    get machine dependent parameters
 
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
 
c
c ----- dimension standard USP variables -----
c
 
      integer     itr ( SZLNHD ), ntr ( SZLNHD )
      integer     lhed( SZLNHD ), lvhed (SZLNHD)
      integer     nsamp, nsi, ntrc, nrec,nrecc, iform
      integer     nsampv, nsiv, ntrcv, nrecv, iformv
      integer     luin,luout,luvel
      integer     nbytes,obytes,lbytes,lbyout
      integer     nvbytes,lvbytes
      integer     irs,ire,ns,ne,jtr
      integer     vrs,vre,vst,ved
      integer     argis,pipe
 
      real        tri( SZLNHD ), xtr( SZLNHD )
 
c
c ----- dynamic memory allocation -----
c
      integer    errcd1,abort1,errcd2,abort2,errcd3,abort3,errcd4,abort4
      integer    errcd5,abort5,errcd6,abort6
 
      real        v2,v4,z,t,rnum,work
 
      pointer     (wkadr1, v2(200000))
      pointer     (wkadr2, v4(200000))
      pointer     (wkadr3, z(200000))
      pointer     (wkadr4, rnum(200000))
      pointer     (wkadr5, t(200000))
      pointer     (wkadr6, work(200000))
 
      logical     heap1,heap2,heap3,heap4,heap5,heap6
 
c
c ----- set up printout files -----
c
 
#include <f77/pid.h>
 
c
c ----- dimension program specific variables -----
c
 
      integer     recnum, trcnum, static, vflag
      integer     i,kk,kv,jj,nn,luXY
      real        dt
      character   ntap * 100, otap * 100, name*6, vtap * 100
      logical     verbos, query
      logical     stat,remove,reverse,top,bot,XY,XY_first
 
c
c ----- set up useful hooks -----
c
 
c     equivalence ( itr(129), tri (1) )
      equivalence ( itr(  1), lhed(1) )
c     equivalence ( ntr(129), xtr (1) )
      equivalence ( ntr(  1), lvhed(1))
 
c
c ----- initialize necessary variables -----
c
 
      data lbytes/0/,nbytes/0/,name/'QNMO'/
      data lvbytes/0/,nvbytes/0/,lbyout/0/
      data pipe/3/,vst/1/,ved/1/
 
c debug
c       external function killit
c       ieeer = ieee_handler ('set','Underflow',killit)
c -----
 
      heap1 = .true.
      heap2 = .true.
      heap3 = .true.
      heap4 = .true.
      heap5 = .true.
      heap6 = .true.
 
      top = .false.
      bot = .false.
      XY = .false.
      XY_first = .true.
      verbos = .false.
 
c
c ----- read program parameters from command line card image file -----
c
 
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query )then
            call help()
            stop
      endif
 
c-----
c     open printout files
c     this consists of a 2-character identifier, the process id number,
c     and the child process id number:
c     XY.nnnnn.mmmmm
c     this should be unique even for multiple occurences of the same
c     process in a pipeline
 
#include <f77/open.h>
 
      call cmdln(ntap,otap,vtap,ns,ne,irs,ire,vrs,vre,stat,remove,
     1             reverse,top,bot,nn,verbos)
 
c-----
c     get logical unit numbers for input and output of seismic data
c     0 = default stdin
c     1 = default stdout
 
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)
c
c ----- if nn.gt.0 open xgraph input file and write header
c
 
      if(nn.gt.0) then
 
         luXY = 4
         open(luXY,file='qnmo_fcn',status='unknown',err=990)
c        write(luXY,*)'" trace ',nn
 
      endif
 
      if (vtap .ne. ' ') then
          call getln(luvel,vtap,'r',-1)
      else
          write(LERR,*)'qnmo assumed to be running inside IKP'
          if (reverse) then
             write(LERR,*)'velocity is in a pipe and -B option'
             write(LERR,*)'(reverse) option cannot be used.  If this'
             write(LERR,*)'option must be used -v[] with a disk file'
             go to 999
          endif
          call sisfdfit (luvel, pipe)
      endif
      if  (luvel .lt. 0)   then
             write(LERR,*)'velocity file -v not accessible'
             stop
      endif
 
c-----
 
 
c-----
c     read line header of input
c     save certain parameters
 
      call rtape  ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'QNMO: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif
 
c------
c     to get and/or put LINE header values please use saver/savew
c     since that way code will always be portable to whatever machine
c     we maintain usp on
c     saver/w refer to header words using mnemonics rather than position
c
c     see saver/w manual pages
 
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
 
      call hlhprt (itr, lbytes, name, 6, LERR)
 
c-----
c     ensure that command line values are compatible with data set
c     (i.e. start/end traces; start/end records)
 
      call cmdchk(ns,ne,irs,ire,ntrc,nrec)
 
c
c ----- galloc only space we're going to use -----
c
 
      item1 = ntrc * nsamp * SZSMPD
 
      call galloc(wkadr1,item1,errcd1,abort1)
      call galloc(wkadr2,item1,errcd2,abort2)
      call galloc(wkadr3,item1,errcd3,abort3)
      call galloc(wkadr4,item1,errcd4,abort4)
      call galloc(wkadr5,item1,errcd5,abort5)
      call galloc(wkadr6,item1,errcd6,abort6)
 
      if (errcd1 .ne. 0) heap1 = .false.
      if (errcd2 .ne. 0) heap2 = .false.
      if (errcd3 .ne. 0) heap3 = .false.
      if (errcd4 .ne. 0) heap4 = .false.
      if (errcd5 .ne. 0) heap5 = .false.
      if (errcd6 .ne. 0) heap6 = .false.
 
      if (.not.heap1.or..not.heap2.or..not.heap3.or..not.heap4.or..not.
     :     heap5.or..not.heap6)then
 
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) 6*item1,'  bytes'
         write(LERR,*)' '
         go to 999
 
      else
 
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) 6*item1,'  bytes'
         write(LERR,*)' '
 
      endif
 
c
c ----- modify line header to reflect actual number of traces output -----
c
#include <f77/saveh.h>
 
      nrecc=ire - irs+1
      call savew(itr, 'NumRec', nrecc, LINHED)
      jtr=ne-ns+1
      call savew(itr, 'NumTrc', jtr  , LINHED)
 
c
c ----- number output bytes -----
c
 
      obytes = SZTRHD + nsamp * SZSMPD
 
      call savhlh(itr,lbytes,lbyout)
      call wrtape (luout,itr,lbyout)
 
 
c
c ----- velocity data -----
c
 
      vflag=1
      lvbytes=0
 
      call rtape(luvel,ntr,lvbytes)
 
      if(lvbytes .eq. 0) then
       write(LERR,*)'QNMO: no header read on velocity unit ',luvel
       write(LERR,*)'FATAL'
       stop
      endif
 
      call saver(ntr, 'NumSmp', nsampv, LINHED)
      call saver(ntr, 'SmpInt', nsiv  , LINHED)
      call saver(ntr, 'NumTrc', ntrcv , LINHED)
      call saver(ntr, 'NumRec', nrecv , LINHED)
      call saver(ntr, 'Format', iformv, LINHED)
 
c ----- determine that velocity data actually comes from velquar -----
c
c         if(mod(ntrcv,2) .ne. 0) then
c
c            write(LERR,*)'Number velocity traces/rec must be even'
c            write(LERR,*)'the traces must be laid out in pairs of'
c            write(LERR,*)'velocity-dip'
c            write(LERR,*)'Check tvdin run'
c            stop
c
c         endif
 
c ----- make ntrcv equal to 1 instead of dividing by number of traces in velquar
c       output tape. (We don't know how many traces that will end up being at th
c       point)
c
 
         ntrcv = 1
 
c--------------------------------------
c   vflag=0 single velocity function
c   vflag=1 multiple velocity function
 
      if(nrecv .le. 1) vflag=0
 
c--------------------------------------
 
      if(nsampv .lt. nsamp) then
         write(LERR,*)'velocity trace(s) too short; contains ',nsampv,
     &                'samples'
         write(LERR,*)'input data contains ',nsamp,' samples'
         write(LERR,*)'Run transp on output from velquar and try again.'
         stop
      endif
 
      call cmdchk(vst,ved,vrs,vre,ntrcv,nrecv)
 
 
c ----
c     verbose output of all pertinent information before
c     processing begins
c ----
 
c     if( verbos ) then
            call verbal(nsamp,nsi,ntrc,nrec,nrecv,iform,nsampv,nsiv,
     1                  ntrcv,iformv,reverse,vflag,stat,remove,top,bot,
     2                  vtap,ntap,otap)
c     endif
 
c
c ----- handle velocity data -----
c
 
      nvbytes=1
 
c
c ----- multiple velocity functions -----
c
 
      if(vflag .eq. 1) then
         if(vrs .le. nrecv) then
           call recskp(1,vrs-1,luvel,2*ntrcv,ntr)
         else
            write(LERR,*)' start record to skip to exceeds number'
            write(LERR,*)' records on velocity file'
            write(LERR,*)' check velquar run to make sure your velocity'
            write(LERR,*)' model covers the part of the data between'
            write(LERR,*)' records ',vrs,' and ', vre
            stop
         endif
 
c
c ----- single velocity function :read now -----
c
 
      elseif(vflag .eq. 0) then
           nvbytes=0
 
           call rtape(luvel,ntr,nvbytes)
 
           call vmov(ntr(ITHWP1),1,v2,1,nsampv)
 
           if(verbos) then
            write(LERR,*)'velocity(V2)'
            write(LERR,777)(v2(i),i=1,nsampv)
 777        format(10f8.2)
           endif
 
           call rtape(luvel,ntr,nvbytes)
 
           if(nvbytes .eq. 0) then
              write(LERR,*)'End of file on velocity file: FATAL'
              stop
           endif
 
           call vmov(ntr(ITHWP1),1,v4,1,nsampv)
 
           if(verbos) then
              write(LERR,*)'velocity(V4)'
              write(LERR,777)(v4(i),i=1,nsampv)
           endif
 
c
c ----- check for valid velocities -----
c
 
               call dotpr (v2,1,v2,1,vdot,nsampv)
 
               if (abs(vdot) .lt. 1.e-06) then
                  write(LERR,*)'Velocity trace V2 contains zeros'
                  write(LERR,*)'---    FATAL  ---'
                  write(LERR,*)'Check the velquar step thoroughly'
                  go to 999
               endif
 
               call dotpr (v4,1,v4,1,vdot,nsampv)
 
               if (abs(vdot) .lt. 1.e-06) then
                  write(LERR,*)'Velocity trace V4 contains zeros'
                  write(LERR,*)'---    FATAL  ---'
                  write(LERR,*)'Check the velquar step thoroughly'
                  go to 999
               endif
 
      endif
 
c
c ----- read trace -----
c
c   when reading velocity traces make sure that if we run out of vel. traces
c   we use the last vel trace to the end of the line...
c
        kv = 0
        nvbytes=1
 
c ----
c  compute sample interval in secs
c  take care of micro secs if necessary
c ----
 
      if (nsi .le. 32) then
         dt = real (nsi) /1000.
      else
         dt = real (nsi) /1000000.
      endif
 
c
c ----- generate random number array for spline routine -----
c       required when leading zeroes on trace data cause
c       ieee underflow errors in spline.
c
      call vrand(911,rnum,1,nsamp)
 
      do 500 i=1,nsamp
 
         rnum(i)=rnum(i)*1.0e-21
         t(i) = float(i)
 
 500  continue
 
c
c ----- BEGIN PROCESSING -----
c     skip unwanted records
c
 
      call recskp(1,irs-1,luin,ntrc,itr)
 
        DO 1000 jj = irs, ire
 
           if(vflag.eq.1 .and. nvbytes.ne.0 .and. jj.le.vre) then
 
              nvbytes=0
 
c
c ----- read in reverse order ?
c
              if (reverse) then
                 kv = kv + 1
                 call skipt (luvel, ntrcv*(vre-kv), idummy)
              endif
 
c
c ----- read velocity data -----
c
 
              call rtape(luvel,ntr,nvbytes)
              call vmov (ntr(ITHWP1),1,v2,1,nsampv)
 
c
c ----- check for valid data -----
c
 
              call dotpr (v2,1,v2,1,vdot,nsampv)
              if (abs(vdot) .lt. 1.e-06) then
                 write(LERR,*)'Velocity trace contains zeros'
                 write(LERR,*)'---    FATAL  ---'
                 write(LERR,*)'Check the velquar step thoroughly'
                 go to 999
              endif
 
              if(verbos) then
               write(LERR,*)'rec ',jj,' velocity (V2)'
               write(LERR,777)(v2(i),i=1,nsampv)
              endif
 
              call rtape(luvel,ntr,nvbytes)
              call vmov (ntr(ITHWP1),1,v4,1,nsampv)
 
              if(verbos) then
                write(LERR,*)'rec ',jj,' velocity (V4)'
                write(LERR,777)(v4(i),i=1,nsampv)
              endif
 
           endif
 
 
c
c ----- skip to start trace -----
c
 
            call trcskp(jj,1,ns-1,luin,ntrc,itr)
 
            do 1001  kk = ns, ne
 
                  nbytes = 0
                  call rtape( luin, itr, nbytes)
 
                  if(nbytes .eq. 0) then
                     write(LERR,*)'End of file on input:'
                     write(LERR,*)'  rec= ',jj,'  trace= ',kk
                     go to 999
                  endif
 
                  call vmov (itr(ITHWP1), 1, tri, 1, nsamp)
                  call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                        static , TRACEHEADER)
                  call saver2(itr,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                        idist  , TRACEHEADER)
                  call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                        recnum , TRACEHEADER)
                  call saver2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                        trcnum , TRACEHEADER)
 
                  dist   = iabs (idist)
 
                  call vclr(work,1,nsamp)
c
c ----- if live do qnmo on trace -----
c
 
 
                  IF (static .ne. 30000) THEN
 
                    static=static/nsi
                    if(.not.stat) static=1
                    if(static .eq. 0) static=1
                    if(static .lt. 0) then
                       static=-static
                       call vmov(tri(static),1,work(1),1,nsamp)
                    else
                       call vmov(tri(1),1,work(static),1,nsamp)
                    endif
 
c
c ----- set XY flag to true if trace is nn -------
c
 
                    if(kk.eq.nn)then
                        if(XY_first)then
                          XY_first = .false.
                        else
                          write(luXY,8787)
8787                      format()
                          XY_first = .false.
                        endif
                        write(luXY,*)'"trace ',nn,' record ',jj
                        XY = .true.
                    endif
 
                   call bdsub(work,dt,nsamp,dist,v2,v4,remove,z,top,bot,
     :                         rnum,XY,luXY,t)
 
                    call vmov(z(1),1,tri,1,nsamp)
 
                  ENDIF
 
                  call wrtape (luout,itr, obytes)
 
1001        continue
 
c
c ----- skip to end of record -----
c
 
            call trcskp(jj,ne+1,ntrc,luin,ntrc,itr)
 
1000   CONTINUE
 
      goto 999
c
c ----- unable to open xgraph data output file -----
c
 
990   write(LERR,*)' Unable to open qnmo_fcn xgraph output file'
      stop
 
c
c ----- close data files -----
c
 
  999 continue
 
      call lbclos ( luin )
      call lbclos ( luout )
      call lbclos ( luvel )
 
 
            write(LERR,*)'end of qnmo, processed',nrec,' record(s)',
     :               ' with ',ntrc, ' traces'
      stop
      end
 
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       HELP                                                 *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      HELP                                                            *
C  ARGUMENTS:     NONE                                                 *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 93/07/23  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 93/07/23  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      LER  ( OUTPUT SEQUENTIAL ) -                                    *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C                       SUBROUTINES
C***********************************************************************
 
      subroutine help
 
#include <f77/iounit.h>
         write(LER,*)
     :'----------------------------------------------------------------'
        write(LER,*) ' '
        write(LER,*)
     :'qnmo performs moveout correction by means of the quartic '
        write(LER,*)
     :'moveout equation; the moveout parameters are calculated by '
        write(LER,*)
     :'code velquar and written in file "vtap". qnmo uses quadratic '
        write(LER,*)
     :'interpolation, reverse floating point sample, amplitude mapping'
        write(LER,*)
     :'and user controlled nmo map choice.  See manual pages for '
        write(LER,*)
     :'details (online by typing uman qnmo or use xman browser)'
        write(LER,*)' '
        write(LER,*)
     :'Execute qnmo by typing qnmo and the program parameters.'
        write(LER,*)
     :'Note that each parameter is proceeded by -a where "a" is '
        write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'Enter the following parameters, or use the default values'
        write(LER,*)' '
        write(LER,*)
     :' -N [ntap]    (no default)     : input data file name'
        write(LER,*)
     :' -O [otap]    (no default)     : output data file name'
        write(LER,*)
     :' -v [vtap]    (no default)     : input velocity file name'
        write(LER,*)
     :' -rs[irs]     (default = first): start record number'
        write(LER,*)
     :' -re[ire]     (default = last) : end record number'
        write(LER,*)
     :' -ns[ns]      (default = first): start trace number'
        write(LER,*)
     :' -ne[ne]      (default = last) : end trace number'
        write(LER,*)
     :' -sv[vrs]     (default = first): start vel record number'
        write(LER,*)
     :' -ev[vre]     (default = last) : last vel record number'
        write(LER,*)
     :' -T                            : use top of qnmo map'
        write(LER,*)
     :' -E           (the default)    : use bottom of qnmo map'
        write(LER,*)' '
        write(LER,*)
     :' -S                            : apply trace header statics'
        write(LER,*)
     :' -R                            : remove qnmo'
      write(LER,*)
     :' -B                            :read vel in reverse order'
      write(LER,*)
     :' -XY[nn]                       :output xgraph data for trace nn'
        write(LER,*)
     :' -V  include on command line if verbose printout is desired'
         write(LER,*)
     :'***************************************************************'
        write(LER,*) ' '
        write(LER,*)
     :'Usage: qnmo -N[ntap] -O[otap] -v[vtap] -ns[] -ne[] -rs[] -re[]'
         write(LER,*)
     :'             -sv[] -ve[]  -S -R -B -T -E -XY[] -V'
        write(LER,*) ' '
        write(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       CMDLN                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      CMDLN  (NTAP,OTAP,VTAP,NS,NE,IRS,IRE,VRS,VRE,STAT,REMOVE,       *
C              REVERSE,TOP,BOT,NN,VERBOS)                              *
C  ARGUMENTS:                                                          *
C      NTAP    CHAR*(*)  ??IOU* -                                      *
C      OTAP    CHAR*(*)  ??IOU* -                                      *
C      VTAP    CHAR*(*)  ??IOU* -                                      *
C      NS      INTEGER   ??IOU* -                                      *
C      NE      INTEGER   ??IOU* -                                      *
C      IRS     INTEGER   ??IOU* -                                      *
C      IRE     INTEGER   ??IOU* -                                      *
C      VRS     INTEGER   ??IOU* -                                      *
C      VRE     INTEGER   ??IOU* -                                      *
C      STAT    LOGICAL   ??IOU* -                                      *
C      REMOVE  LOGICAL   ??IOU* -                                      *
C      REVERS  LOGICAL   ??IOU* -                                      *
C      TOP     LOGICAL   ??IOU* -                                      *
C      BOT     LOGICAL   ??IOU* -                                      *
C      NN      INTEGER   ??IOU* -                                      *
C      VERBOS  LOGICAL   ??IOU* -                                      *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 93/07/23  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 93/07/23  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      ARGSTR          -                                               *
C      ARGI4           -                                               *
C      ARGIS   INTEGER -                                               *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      LERR  ( OUTPUT SEQUENTIAL ) -                                   *
C  COMMON:           NONE                                              *
C  STOP CODES:                                                         *
C      =BLANK=  ( 1) -                                                 *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
c
c ----- ----- -----
c
 
      subroutine cmdln(ntap,otap,vtap,ns,ne,irs,ire,vrs,vre,stat,
     1                 remove,reverse,top,bot,nn,verbos)
 
c     get command arguments
c
c     ntap  - C*100  input file name
c     otap  - C*100  output file name
c     vtap  - C*100  velocity file name
c      ns   - I      start trace
c      ne   - I      stop end trace
c     irs   - I      start record
c     ire   - I      stop end record
c     vrs   - I      start velocity record
c     vre   - I      end velocity record
c    stat   - L      normalize stacked trace by # live traces
c  remove   - L      remove normal moveout
c  reverse  - L      read velocity in reverse order
c     top   - L      use top nmo map
c     bot   - L      use bot nmo map
c      nn   - I      output xgraph data for trace nn
c    verbos - L      verbose output or not
 
#include <f77/iounit.h>
 
      integer     ns,ne,irs,ire,vrs,vre,argis,nn
      character   ntap*(*),otap*(*),vtap*(*)
      logical     stat,remove,reverse,verbos,top,bot
 
      call argstr ('-N', ntap, ' ', ' ' )
 
      call argstr ('-O', otap, ' ', ' ' )
      call argstr ('-v',vtap, ' ', ' ')
 
      if(vtap.eq.' ') then
        write(LERR,*)'No input velocity filename specified .....  FATAL'
        write(LERR,*)'include velocity filename after -v'
        write(LERR,*)'on command line and re-run'
        stop
      endif
 
      call argi4  ('-ns',ns,0,0)
      call argi4  ('-ne',ne,0,0)
      call argi4  ('-rs',irs,0,0)
      call argi4  ('-re',ire,0,0)
      call argi4  ('-sv',vrs,1,1)
      call argi4  ('-ev',vre,0,0)
      top = ( argis ('-T') .gt. 0 )
      bot    = ( argis ('-E') .gt. 0 )
      stat = ( argis ('-S') .gt. 0 )
      remove = ( argis ('-R') .gt. 0 )
      reverse = ( argis ('-B') .gt. 0 )
      call argi4  ('-XY',nn,0,0)
 
      verbos = ( argis ('-V') .gt. 0 )
c
c ----- if remove then use bot as default -----
c
 
      if(remove)then
        if(.not.top.and..not.bot) bot = .true.
      endif
 
      return
      end
 
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       VERBAL                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      VERBAL  (NSAMP,NSI,NTRC,NREC,NRECV,IFORM,NSAMPV,NSIV,NTRCV,     *
C               IFORMV,REVERSE,VFLAG,STAT,REMOVE,TOP,BOT,VTAP,NTAP,    *
C               OTAP)                                                  *
C  ARGUMENTS:                                                          *
C      NSAMP   INTEGER   ??IOU* -                                      *
C      NSI     INTEGER   ??IOU* -                                      *
C      NTRC    INTEGER   ??IOU* -                                      *
C      NREC    INTEGER   ??IOU* -                                      *
C      NRECV   INTEGER   ??IOU* -                                      *
C      IFORM   INTEGER   ??IOU* -                                      *
C      NSAMPV  INTEGER   ??IOU* -                                      *
C      NSIV    INTEGER   ??IOU* -                                      *
C      NTRCV   INTEGER   ??IOU* -                                      *
C      IFORMV  INTEGER   ??IOU* -                                      *
C      REVERS  LOGICAL   ??IOU* -                                      *
C      VFLAG   INTEGER   ??IOU* -                                      *
C      STAT    LOGICAL   ??IOU* -                                      *
C      REMOVE  LOGICAL   ??IOU* -                                      *
C      TOP     LOGICAL   ??IOU* -                                      *
C      BOT     LOGICAL   ??IOU* -                                      *
C      VTAP    CHAR*(*)  ??IOU* -                                      *
C      NTAP    CHAR*(*)  ??IOU* -                                      *
C      OTAP    CHAR*(*)  ??IOU* -                                      *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 93/07/23  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 93/07/23  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      LERR  ( OUTPUT SEQUENTIAL ) -                                   *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
c
c ----- ----- -----
c
 
      subroutine verbal(nsamp,nsi,ntrc,nrec,nrecv,iform,nsampv,nsiv,
     1                  ntrcv,iformv,reverse,vflag,stat,remove,top,bot,
     2                  vtap,ntap,otap)
 
 
c     verbose output of processing parameters
c
c     nsamp   - I*4     number of samples in trace
c     nsampv  - I*4     number of samples in vel trace
c     nsi     - I*4     sample interval in ms
c     nsiv    - I*4     vel sample interval in ms
c     ntrc    - I*4     traces per record
c     ntrcv   - I*4     traces per record vel
c     nrec    - I*4     number of records per line
c     nrecv   - I*4     number of vel records per line
c     iform   - I*4     format of data
c     iformv  - I*4     format of vel data
c     reverse - Logical	reverse velocity order in file
c     vflag   - I*4     single/multiple vel function flag
c     stat    - Logical trace header statics application flag
c     remove  - Logical apply/remove nmo flag
c     top     - Logical use nmo map from sample 1 to last cross-over
c     bot     - Logical use nmo map from last cross-over to end
c     vtap    - C*100   input vel file name
c     ntap    - C*100   input file name
c     otap    - C*100   output file name
 
#include <f77/iounit.h>
 
      integer     nsamp,nsampv,nsi,nsiv,ntrc,ntrcv,nrec,nrecv
      integer     iform,iformv,vflag
      logical     reverse,stat,remove,top,bot
      character   ntap*(*), otap*(*), vtap*(*)
 
            write(LERR,*)' '
            write(LERR,*) ' input data set name =  ', ntap
            write(LERR,*) ' output data set name=  ', otap
            write(LERR,*) ' input vel data set name =  ', vtap
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*)' '
            write(LERR,*) ' # of samples/trace =  ', nsamp
            write(LERR,*) ' sample interval    =  ', nsi
            write(LERR,*) ' traces per record  =  ', ntrc
            write(LERR,*) ' records per line   =  ', nrec
            write(LERR,*) ' format of data     =  ', iform
            write(LERR,*)' '
            write(LERR,*)' velocity header values after default check '
            write(LERR,*)' '
            write(LERR,*) ' # of samples/trace =  ', nsampv
            write(LERR,*) ' sample interval    =  ', nsiv
            write(LERR,*) ' traces per record  =  ', ntrcv
            write(LERR,*) ' records per line   =  ', nrecv
            write(LERR,*) ' format of data     =  ', iformv
            write(LERR,*)' '
 
      if (vflag.eq.1) then
            write(LERR,*) 'expecting multiple velocity functions '
      else
            write(LERR,*) 'expecting single velocity function '
      endif
 
      if ( reverse ) then
            write(LERR,*) 'velocity functions in reverse order '
      endif
 
      if ( stat ) then
            write(LERR,*) 'apply trace header statics '
      endif
 
      if ( remove ) then
            write(LERR,*) 'remove normal moveout'
      else
            write(LERR,*) 'apply normal moveout'
      endif
 
      if ( top.or.bot ) then
 
         if ( top ) then
            write(LERR,*) 'using nmo map from top to cross-over'
         else
            write(LERR,*) 'using nmo map from cross-over to bottom'
         endif
 
      else
 
            write(LERR,*) 'using entire nmo map'
 
      endif
 
      if ( reverse ) then
            write(LERR,*) 'velocity functions in reverse order '
      endif
 
            write(LERR,*)' '
            write(LERR,*)' '
 
      return
      end
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       KILLIT                                               *
C  ROUTINE TYPE:  FUNCTION  INTEGER                                    *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      KILLIT  INTEGER  (SIG,CODE,SIGCONTEXT)                          *
C  ARGUMENTS:                                                          *
C      SIG     INTEGER  ??IOU*      -                                  *
C      CODE    INTEGER  ??IOU*      -                                  *
C      SIGCON  INTEGER  ??IOU*  (5) -                                  *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 93/07/23  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 93/07/23  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      LOC     INTEGER -                                               *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      LER  ( OUTPUT SEQUENTIAL ) -                                    *
C  COMMON:           NONE                                              *
C  STOP CODES:                                                         *
C      =BLANK=  ( 1) -                                                 *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
c
c ----- ieee handler
c
       integer function killit(sig,code,sigcontext)
       integer sig,code,sigcontext(5)
#include <f77/iounit.h>
       write(LER,*) ' ieee exception code',loc(code)
       killit = 1
       stop
       end
