C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine  pikrd ( nblk, nseg, iunit, iseg,nsi,itrs,itre,nrecs,
     1                    nsmp,recpik,recz,trcz,tz,num,lunit,irec,
     2                    nrecc,maxpik,xmin,xmax)
c
c  routine to find number segments in oper pick file
c  and to count numerical entries in each segment
c  and to read the FIRST set of segments
c
c  nblk  -  I     number segments
c  ntrc  -  I     number trace/record in input data
c  nseg  -  I     array containing numerical count in each seg
c  nsi   -  I     sample interval
c  nsmp  -  I     number samples/trc
c  itrcz -  I     array of trace indices
c  irecz -  I     array of record indices
c   itz  -  I     array or corresponding times
c iunit  -  I     time units
c  iseg  -  I     segment to be read for single segment pass
c  irec  -  I     record number from current segment
c  nrecc -  I     number of unique records among segments
c  nrecs -  I     number of segments for each record
c maxpik -  I     max number of picks in largest segment
c recpik -  L     are the picks record-by-record
c    num -  L     T = just count # segments & # picks/segment
c    num -  L     F = go to iseg segment & read picks
c
#include <f77/iounit.h>
#include <f77/lhdrsz.h>

      character   junk*1
      integer     nblk, nent, iunit, nseg(*), nrecs(*)
      integer     nsi
      real        recz(SZLNHD), trcz(SZLNHD), tz(SZLNHD)
      integer     itrs, itre, nsmp, iseg
      real        unit, dum1, dum2, fac, xmax, xmin
      logical     recpik, num, first


      IF (num) THEN
         xmax        = -9999999.
         xmin        = +9999999.
         write(LERR,*)'Count horizons only'
         rewind lunit
         first = .true.
c------------------------------------------------------
c  count horizons & and count segments in each horizon

      read(lunit, 101, end = 911) junk,dum1,dtr,unit,itrs,itre,nsmp,
     1                            dum, troff, dum, itot, maxpik
c     xmin = dtr + troff
c     xmax = dtr * (itre - 1)
      iunit = ifix(unit)
      nblk = 1
      nent = 0
      read(lunit, 100, end = 912) junk
1     read(lunit, 100, end = 910) junk
      if(junk .ne. 'S') then
         nent = nent + 1
         go to 1
      else
         nseg(nblk) = nent
         nblk = nblk + 1
         nent = 0
         go to 1
      endif

101   format(a1,4x,f13.6,f13.6,f13.6,3i6,7x,3f13.6,6x,2i6)
100   format(a1)
910   nseg(nblk) = nent
912   continue


      fac = 1.
      do  3  i = 1, nblk
             fac = fac * float(nseg(i))
3     continue
      if(nblk .eq. 1 .and. fac .eq. 0.) then
         write(LERR,*)'Pick file has segment with 0 entries'
         write(LERR,*)'Fix the oper pick file before rerunning'
         stop
      endif
      rewind lunit

c------------------------------------------------------

c------------------------------------------------------
c  read down to first horizon
      read(lunit, 100) junk

c----------------------------------------
c  scan down thru all segments to check
c  whether segments are restricted to
c  records or not

      icr = 0
      itest = 1
      irl = 0
      nrecc = 1

      do  7  j = 1, nblk
           icr = icr + 1
           read(lunit, 100) junk
           do  5  i = 1, nseg(j)
                  read(lunit,200) rr, tr, tt
                  if (tr .ge. xmax) xmax = tr
                  if (tr .le. xmin) xmin = tr
                  ir = rr
                    if (i.eq.1 .AND. ir.ne.irl) then
                       if (.not.first) then
                          nrecs(nrecc) = icr - 1
                          nrecc = nrecc + 1
                          icr = 1
                       else
                          first = .false.
                       endif
                       irl = ir
                    endif
                  trcz(i) = tr
                  recz(i) = rr
                  if (i .ge. 2) then
                      if (recz(i) .ne. recz(i-1)) then
                          tz(j) = 0.
                      else
                          tz(j) = 1.
                      endif
                  endif
5          continue
4          itest = itest * ifix(tz(j))
7     continue
      nrecs(nrecc) = icr
      if (itest .eq. 1) then
          recpik = .true.
          write(LERR,*)'pick segments correspond to record boundaries'
      else
          recpik = .false.
          write(LERR,*)'pick segments cross record boundaries'
      endif
      write(LERR,*)'Found ',nblk,' horizons each having ',
     1 (nseg(ii),ii=1,nblk),' picks'
200   format( f12.6,f13.6,f13.6)
c----------------------------------------

      ELSE

c------------------------------------------------------
c  for one segment pass read down to input segment
      write(LERR,*)'Reading segment ',iseg,' having ',nseg(iseg),
     1' picks'
      rewind lunit
      read(lunit,100) junk
      do  9  j = 1, iseg
             read(lunit,100) junk
             do  10  i = 1, nseg(j)
                     read(lunit,200) rr, tr, tt
                     if (i .eq. 1) irec = rr
                     if (recpik) then
                        trcz(i) = tr
                     else
                        trcz(i) = rr
                     endif
                     tz(i)   = tt
10           continue
9     continue


      ENDIF
      return

911   continue
      write(LERR,*)'Empty oper pick file or,'
      write(LERR,*)'old oper pick file: new one should have 7 entries on
     1 first line'
      write(LERR,*)'First line starts out as...'
      write(LERR,*) junk,dum1,dum2,unit,itrs,itre,nsmp

      return
      end
