C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine fwddrt(uin,live,utaup,udata,
     1                  uorig,rf,tracebuf,trheader,
     2                  ifl,ifh,cputim,waltim,mx,my,np,nq,
     3                  iypointer,jy,ny,locate,nt,nx,nxw,nyw,
     4                  luin,luout,lerr,jrec,jcenter,
     5                  l_StaCor,eof,lenhed,lntrhd,nfft,
     6                  rtabf,itabf,rtabi,fwgt,
     7                  itabi,work,twgt,omtwgt,
     8                  lenrtab,lenitab,lenwork,ler,nxpad,
     9                  istart,iend,nt_orig,nbytes_out,interpolate,
     a                  l_LinInd,l_DphInd,jpqlive,npqlive,
     b                  ifmt_LinInd,ln_LinInd,ifmt_DphInd,ln_DphInd,
     c                  ifmt_StaCor,ln_StaCor,reject,kypointer,
     d                  starttrace,endtrace,startline,endline,
     e                  plive,qlive,slive,dmsamp)
c__________________________________________________________________________
c     input seismic records.                  
c___________________________________________________________________
      complex   uin(ifl:ifh,-mx:nx+mx,-my:my)
      real      uorig(0:nt_orig,0:nx,0:my)
      integer   iypointer(-my:ny+my)
      integer   kypointer(0:ny)
      logical   live(-mx:nx+mx,-my:+my)
      real      twgt(0:nt),omtwgt(0:nt)
c___________________________________________________________________
c     output vectors.
c___________________________________________________________________
      complex   utaup(ifl:ifh,npqlive)
      real      udata(0:nfft-1,*)
      real      tracebuf(-lenhed:nt-1)
      integer*2 trheader(lntrhd,0:nx,-my:my)
c_______________________________________________________________
c     fourier transform table and work arrays.
c_______________________________________________________________
      real       rtabf(lenrtab)
      integer    itabf(lenitab)
      real       rtabi(lenrtab)
      integer    itabi(lenitab)
      real       work(lenwork)
c___________________________________________________________________
c     (tau,ptheta,phi) forward transform matrix.             
c___________________________________________________________________
      complex   rf(ifl:ifh,npqlive,nxw*nyw)
      integer   jpqlive(npqlive)
      real      plive(npqlive),qlive(npqlive),slive(npqlive)
c___________________________________________________________________
c     grid stencil for the transform and spatial weights.
c___________________________________________________________________
      integer   locate(2,nxw*nyw)
c___________________________________________________________________
c     timing arrays.
c___________________________________________________________________
      real     cputim(*),waltim(*)
c___________________________________________________________________
c     control variables.
c___________________________________________________________________
      integer  starttrace,endtrace,startline,endline
      logical  eof,reject,interpolate
c___________________________________________________________________
C     include header definition file.
c___________________________________________________________________
#include <save_defs.h>
c
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('TVPV19',ifmt_qhdr,l_qhdr,ln_qhdr,TRACEHEADER)
      call savelu('TVPV20',ifmt_phdr,l_phdr,ln_phdr,TRACEHEADER)

      initfftf=1
      initffti=1
c
      jrec=0
c_____________________________________________________________
c     fill in the data swath uin needed for processing.
c_____________________________________________________________
      call timstr(va,wa)
      do 10000 iy=-my,+my
       iypointer(iy)=iy
       if(iy .lt. 0 .or. iy .gt. ny) then
c_____________________________________________________________
c         no records exist. set all traces to be dead.
c_____________________________________________________________
          call deadrec(live,iypointer(iy),my,mx,nx)
       else
c_____________________________________________________________
c         read in the next record.
c_____________________________________________________________
          call timstr(va,wa)
          kypointer(iy)=iy
          call rdgather(tracebuf,tracebuf,trheader,uin,
     1                  uorig,udata,live,luin,ler,nx,nxpad,
     2                  l_StaCor,eof,iypointer(iy),my,mx,
     3                  lenhed,lntrhd,nt,nfft,ifl,ifh,lerr,
     4                  rtabf,itabf,rtabi,fwgt,
     5                  itabi,work,twgt,kypointer(iy),
     6                  lenrtab,lenitab,lenwork,initfftf,
     7                  istart,iend,nt_orig,
     8                  l_LinInd,l_DphInd,ifmt_LinInd,ln_LinInd,
     9                  ifmt_DphInd,ln_DphInd,ifmt_StaCor,ln_StaCor)

          call timend(cputim(1),va,vb,waltim(1),wa,wb)
          if(eof) return
       endif
10000 continue
c_____________________________________________________________
c     data swath is now full. roll through in the y direction,
c     each time adding the next seismic line and dropping the
c     oldest.
c_____________________________________________________________
      do 90000 jy=0,endline
       if(jy .lt. startline) go to 40001
       write(ler,*) 'process line ',jy,' of ',ny
c___________________________________________________________________
c      loop over the inline (x) direction, taking the radon transform.
c      points lieing outside the computational window are 'dead' 
c      (i.e. live(jx,jy)=.false.)
c___________________________________________________________________
       do 40000 jx=starttrace,endtrace       
        call timstr(v1,w1)
        jrec=jrec+1
c___________________________________________________________________
c       initialize.
c___________________________________________________________________
        do 12000 jpq=1,npqlive
         do 11000 jomega=ifl,ifh
          utaup(jomega,jpq)=(0.,0.)
11000    continue
12000   continue
        iy=iypointer(jy)
        if(live(jx,iy) .or. interpolate) then
           do 30000 jpq=1,npqlive
            do 20000 jpoint=1,nxw*nyw
c___________________________________________________________________
c            collect traces comprising the computational star.
c            multiply them by the precomputed filter.
c___________________________________________________________________
             ix=jx+locate(1,jpoint)
             iy=iypointer(jy+locate(2,jpoint))
             if(live(ix,iy)) then
                do 15000 jomega=ifl,ifh
                 utaup(jomega,jpq)=utaup(jomega,jpq)+
     1                 rf(jomega,jpq,jpoint)*uin(jomega,ix,iy)
15000           continue
             endif
20000       continue
30000      continue
        endif
        call timend(cputim(4),v1,v2,waltim(4),w1,w2)
        call timstr(v1,w1)
        iy=iypointer(jy)
        call wrtaup(tracebuf,tracebuf,trheader(1,jx,iy),utaup,
     1              udata,luout,npqlive,
     2              lenhed,nt,nfft,ifl,ifh,lerr,
     3              rtabf,itabf,rtabi,
     4              itabi,work,nt_orig,istart,iend,
     5              lenrtab,lenitab,lenwork,initfftf,
     6              plive,qlive,slive,nbytes_out,lntrhd,
     7              ifmt_phdr,l_phdr,ln_phdr,
     8              ifmt_qhdr,l_qhdr,ln_qhdr,
     9              ifmt_DstUsg,l_DstUsg,ln_DstUsg,
     a              TRACEHEADER,dmsamp)
        call timend(cputim(5),v1,v2,waltim(5),w1,w2)
40000  continue
40001  continue
c_____________________________________________________________
c      roll the swath buffer in y.
c_____________________________________________________________
       iypointer(jy+my+1)=iypointer(jy-my)
       kypointer(jy+my+1)=kypointer(jy)
       if(jy+my+1 .gt. ny .and. jy .lt. ny) then
c_____________________________________________________________
c         no more records exist. set all traces to be dead.
c_____________________________________________________________
          call deadrec(live,iypointer(jy+my+1),my,mx,nx)
       elseif(jy+my+1 .lt. ny) then
c_____________________________________________________________
c         read in the next record.
c_____________________________________________________________
          call timstr(va,wa)
          call rdgather(tracebuf,tracebuf,trheader,uin,
     1                  uorig,udata,live,luin,ler,nx,nxpad,
     2                  l_StaCor,eof,iypointer(jy+my+1),my,mx,
     3                  lenhed,lntrhd,nt,nfft,ifl,ifh,lerr,
     4                  rtabf,itabf,rtabi,fwgt,
     5                  itabi,work,twgt,kypointer(jy+my+1),
     6                  lenrtab,lenitab,lenwork,initfftf,
     7                  istart,iend,nt_orig,
     8                  l_LinInd,l_DphInd,ifmt_LinInd,ln_LinInd,
     9                  ifmt_DphInd,ln_DphInd,ifmt_StaCor,ln_StaCor)
          call timend(cputim(1),va,vb,waltim(1),wa,wb)
          if(eof) return        
       endif
90000 continue
c
      return
      end
