C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
       subroutine fwdlsq(rx1d,rx2d,rx1dinv,rx2dinv,
     1                   ry1d,ry2d,ry1dinv,ry2dinv,
     2                   rx1dc,ry1dc,r2,z,iperm, 
     3                   rx1dfine,ry1dfine,rx2dfine,ry2dfine,
     3                   rf,rr,ra,toeplitz,svd,rhofilt,
     4                   sigma,re,ru,rv,rwork,
     5                   x,y,p,q,nxw,nyw,np,nq,dx,dy,dp,dq,
     6                   wgtpq,jpqlive,npqlive,omega,
     7                   ifl,ifh,ifh_rf,ifh_rr,reject,
     8                   prew,lerr,ler,fwd_drt,rev_drt,wgtxy,
     9                  kximin,kximax,xmin,dxi,mx,nxinterp,nxwfine,
     a                  kyimin,kyimax,ymin,dyi,my,nyinterp,nywfine,
     b                  map)
c_________________________________________________________________
c     calculate the 2D radon transform matrix.
c
c
c       
c     x,y................relative x and y position from center of stencil.
c     p,q................ray parameters in x and y directions.      
c     omega..............temporal frequency in radians/sec.
c     wgtxy..............spatial taper/weight applied to data.
c     wgtpq..............mute matrix in p,q transform space.       
c     rx1d,ry1d..........1D radon transform matrices.        
c     rx2d,ry2d..........2D radon transform matrices.        
c     rx1dinv,ry1dinv....1D pseudo inverse radon transform matrices.        
c     rx2dinv,ry2dinv....2D pseudo inverse radon transform matrices.        
c     rf.................2D forward radon transform matrix.
c     rr.................2D reverse radon transform matrix.
c     ra.................the radon transform filter rr*wgtpq*rf.
c
c
c     the 2D reverse radon transform matrix rr is define by:
c
c     rr(omega,p,q,x,y)=exp{-i*omega*(p*x+q*y)}
c
c     the 2D forward radon transform matrix rf will be defined at the
c     2D pseudo inverse of matrix rr.
c_________________________________________________________________
      complex  rx1d(nxw,np)           
      complex  rx1dc(np,nxw)           
      complex  rx2d(nxw*nyw,nyw*np)
      complex  rx1dinv(np,nxw)           
      complex  rx2dinv(nyw*np,nxw*nyw)
      complex  rx1dfine(nxwfine,np)           
      complex  rx2dfine(nxwfine*nywfine,nywfine*np)
c
      complex  ry1d(nyw,nq)           
      complex  ry1dc(nq,nyw)           
      complex  ry2d(nyw*np,nq*np)
      complex  ry1dinv(nq,nyw)           
      complex  ry2dinv(nq*np,nyw*np)
      complex  ry1dfine(nywfine,np)           
      complex  ry2dfine(nywfine*np,nq*np)

c
      complex  rf(ifl:ifh_rf,npqlive,nxw*nyw)       
      complex  rr(ifl:ifh_rr,npqlive,kximin:kximax,kyimin:kyimax)       
      complex  ra(ifl:ifh,nxw*nyw,kximin:kximax,kyimin:kyimax)
c
      complex  sigma(*),re(*),rwork(*)
      complex  ru(*),rv(*)
      complex  r2(*),z(*)
      integer  iperm(*)
c
      real     x(nxw),y(nyw)
      real     p(np),q(nq)
      real     wgtpq(npqlive)
      real     wgtxy(nxw*nyw)
      real     omega(ifl:ifh)
      integer  jpqlive(npqlive)
      integer  map(nxwfine,nywfine)

      integer  ler
      logical  toeplitz,svd,rhofilt,reject
      logical  fwd_drt,rev_drt
      parameter (pi=3.1415926,twopi=2.*pi)
c________________________________________________________________
c     map the 2d index of output interpolated points to the 1d index
c     used in the matrix calculations.
c_________________________________________________________________
      kount=0
       do 2000 jy=-my*nyinterp,+my*nyinterp
        do 1000 jx=-mx*nxinterp,+mx*nxinterp
         kount=kount+1
         map(jx,jy)=kount
1000   continue
2000  continue
c_________________________________________________________________
c     loop over temporal frequency omega.
c_________________________________________________________________
      do 90000 jomega=ifl,ifh
       if(fwd_drt) then
          jomega_rf=jomega
       else
          jomega_rf=ifl
       endif
       if(rev_drt) then
          jomega_rr=jomega
       else
          jomega_rr=ifl
       endif
c_________________________________________________________________
c      go calculate the radon transform and pseudo inverse matrices
c      in x.
c
c      [rx1d]=exp{-i*p*omega*x}                                 
c
c      columns vary as {p1,p2,...,pn}
c      rows vary as {x1,x2,...,xn}
c_________________________________________________________________
       do 21000 jp=1,np    
        do 11000 jx=1,nxw           
         arg=-omega(jomega)*p(jp)*x(jx)
         rx1d(jx,jp)=cmplx(cos(arg),sin(arg))
         rx1dc(jp,jx)=conjg(rx1d(jx,jp))         
11000  continue
21000 continue
c_________________________________________________________________
c     calculate least square inverse rx1dinv of rx1d
c_________________________________________________________________
      if(np .gt. 1) then
         rho=omega(jomega)/twopi*dx*dp
      else
         rho=1.0
      endif
      call invert(rx1d,rx1dc,r2,rx1dinv,z,iperm,rcondx,
     1            sigma,re,ru,rv,rwork,rho,
     2            nxw,np,prew,toeplitz,svd,rhofilt,ler,lerr)
c_________________________________________________________________
c      go calculate the radon transform and pseudo inverse matrices
c      in y.
c
c      [ry1d]=exp{-i*p*omega*y}
c
c      rows vary as {y1,y2,...,yn}
c      columns vary as {q1,q2,...,qn}
c_________________________________________________________________

       do 22000 jq=1,nq
        do 12000 jy=1,nyw
         arg=-omega(jomega)*q(jq)*y(jy)
         ry1d(jy,jq)=cmplx(cos(arg),sin(arg))
         ry1dc(jq,jy)=conjg(ry1d(jy,jq))
12000  continue
22000 continue
c_________________________________________________________________
c     calcuate least square inverse ry1dinv of ry1d
c_________________________________________________________________
      if(nq .gt. 1) then
         rho=omega(jomega)/twopi*dy*dq
      else
         rho=1.0
      endif
      call invert(ry1d,ry1dc,r2,ry1dinv,z,iperm,rcondy,
     1            sigma,re,ru,rv,rwork,rho,
     2            nyw,nq,prew,toeplitz,svd,rhofilt,ler,lerr)
      if(mod(jomega,10) .eq. 0) then
         write(ler,'(a,3i5,2e12.3)') 'ifl,jomega,ifh,rcondx,rcondy ',
     1                                ifl,jomega,ifh,rcondx,rcondy
      endif
c_________________________________________________________________
c     form [RX2DINV] from [RX1DINV], reordering the rows for the
c     next step.
c
c     rows vary as {(p1,y1),(p1,y2),...,(p1,yn),(p2,y1),(p2,y2)...}
c     columns vary as {(x1,y1),(x2,y1),...,(xn,y1),(x1,y2),(x2,y2)...}
c_________________________________________________________________
      do 67000 jcol=1,nxw*nyw
       do 66000 jrow=1,nyw*np
        rx2dinv(jrow,jcol)=(0.,0.)
66000  continue
67000 continue
c
      do 65000 jy=1,nyw
       do 64000 jp=1,np
        jrow=(jp-1)*nyw+jy
        do 63000 jx=1,nxw
         jcol=(jy-1)*nxw+jx
         rx2dinv(jrow,jcol)=rx1dinv(jp,jx)
63000   continue
64000  continue
65000 continue
c_________________________________________________________________
c     form [RY2DINV] from [RY1DINV]
c
c     rows vary as {(q1,p1),(q2,p1),...,(qn,p1),(q1,p2),(q2,p2)...}
c     columns vary as {(p1,y1),(p1,y2),...,(p1,yn),(p2,y1),(p2,y2)...}
c_________________________________________________________________
      do 77000 jcol=1,np*nyw  
       do 76000 jrow=1,np*nq 
        ry2dinv(jrow,jcol)=(0.,0.)
76000  continue
77000 continue
c
      do 75000 jp=1,np 
       do 74000 jq=1,nq
        jrow=(jp-1)*nq+jq
        do 73000 jy=1,nyw
         jcol=(jp-1)*nyw+jy
         ry2dinv(jrow,jcol)=ry1dinv(jq,jy)
73000   continue
74000  continue
75000 continue
c_________________________________________________________________
c     form the forward 2d transform: [RF]=[RY2DINV]*[RX2DINV]*[WGTXY]
c
c     rows vary as {(q1,p1),(q2,p1),...,(qn,p1),(q1,p2),(q2,p2)...}
c     columns vary as {(x1,y1),(x2,y1),...,(xn,y1),(x1,y2),(x2,y2)...}
c_________________________________________________________________
      do 54300 jrow=1,npqlive
       krow=jpqlive(jrow)
       do 54200 jcol=1,nxw*nyw
        rf(jomega_rf,jrow,jcol)=(0.,0.)
        do 54100 k=1,np*nyw
         rf(jomega_rf,jrow,jcol)=rf(jomega_rf,jrow,jcol)
     1                +ry2dinv(krow,k)*rx2dinv(k,jcol)*wgtxy(jcol)
54100   continue
54200  continue
54300 continue
c_________________________________________________________________
c     form [RY2D] from [RY1D], reordering the rows for the
c     next step.
c
c     rows vary as {(p1,y1),(p2,y1),...,(pn,y1),(p1,y2),(p2,y2),...}
c     columns vary as {(q1,p1),(q2,p1),...,(qn,p1),(q1,p2),(q2,p2)...}
c_________________________________________________________________
       do 55500 jp=1,np
        do 55400 jx=1,nxwfine
         xinterp=xmin+(jx-1)*dxi
         arg=-omega(jomega)*p(jp)*xinterp
         rx1dfine(jx,jp)=cmplx(cos(arg),sin(arg))
55400   continue
55500  continue
c
       do 55700 jq=1,nq
        do 55600 jy=1,nywfine
         yinterp=ymin+(jy-1)*dyi
         arg=-omega(jomega)*q(jq)*yinterp
         ry1dfine(jy,jq)=cmplx(cos(arg),sin(arg))
55600   continue
55700  continue

      call vclr(ry2dfine,1,2*(nywfine*np)*(nq*np))
      do 55300 jp=1,np
       do 55200 jy=1,nywfine
         jrow=(jy-1)*np+jp
         do 55100 jq=1,nq
          jcol=(jp-1)*nq+jq
          ry2dfine(jrow,jcol)=ry1dfine(jy,jq)
55100    continue
55200   continue
55300  continue
c_________________________________________________________________
c     form [RX2D] from [RX1D], reordering the rows for the
c     next step.
c
c     rows vary as {(x1,y1),(x2,y1),...,(xn,y1),(x1,y2),(x2,y2),...}
c     columns vary as {(p1,y1),(p2,y1),...,(pn,y1),(p1,y2),(p2,y2),...}
c_________________________________________________________________
      call vclr(rx2dfine,1,2*(nywfine*nxwfine)*(nywfine*np))
      do 56300 jx=1,nxwfine 
       do 56200 jy=1,nywfine
         jrow=(jy-1)*nxwfine+jx
         do 56100 jp=1,np
          jcol=(jy-1)*np+jp
          rx2dfine(jrow,jcol)=rx1dfine(jx,jp)
56100    continue
56200   continue
56300  continue
c_________________________________________________________________
c     form the reverse 2d transform: [RR]=[RX2D]*[RY2D]
c
c     rows vary as {(x1,y1),(x2,y1),...,(xn,y1),(x1,y2),(x2,y2),...}
c     columns vary as {(q1,p1),(q2,p1),...,(qn,p1),(q1,p2),(q2,p2)...}
c
c     calculate the filtered reverse transform matrix.
c
c               [RR] = [RR] [wgtpq] 
c_________________________________________________________________
      do 57400 jyi=kyimin,kyimax
       do 57300 jxi=kximin,kximax
        jrow=map(jxi,jyi)
        do 57200 jcol=1,npqlive
         kcol=jpqlive(jcol)
         rr(jomega_rr,jcol,jxi,jyi)=(0.,0.)
         do 57100 k=1,np*nywfine
          rr(jomega_rr,jcol,jxi,jyi)=rr(jomega_rr,jcol,jxi,jyi)
     1                     +rx2dfine(jrow,k)*ry2dfine(k,kcol)
57100   continue
        rr(jomega_rr,jcol,jxi,jyi)=
     1               rr(jomega_rr,jcol,jxi,jyi)*wgtpq(jcol)
57200  continue
57300 continue
57400 continue
c_________________________________________________________________
c     calculate the radon transform filter response matrix:
c
c               [RA] = [RR] [RF]
c
c     rows vary as {(x1,y1),(x2,y1),...,(xn,y1),(x1,y2),(x2,y2),...}
c     columns vary as {(x1,y1),(x2,y1),...,(xn,y1),(x1,y2),(x2,y2),...}
c
c     wgtpq is a diagonal matrix whose rows and columns vary as
c                     {(q1,p1),(q2,p1),...,(qn,p1),(q1,p2),(q2,p2)...}
c_________________________________________________________________
       do 58400 jyi=kyimin,kyimax
        do 58300 jxi=kximin,kximax
         do 58200 jcol=1,nxw*nyw 
          ra(jomega,jcol,jxi,jyi)=(0.,0.)
          do 58100 jpq=1,npqlive
           ra(jomega,jcol,jxi,jyi)=ra(jomega,jcol,jxi,jyi)
     1          +rr(jomega_rr,jpq,jxi,jyi)*rf(jomega_rf,jpq,jcol)
58100     continue
58200    continue
58300   continue
58400  continue
90000 continue

c
      return
      end
