C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine revdrt(utaup,live,uout,udata,
     1                  uorig,rr,tracebuf,trheader,
     2                  ifl,ifh,cputim,waltim,mx,my,np,nq,
     3                  iypointer,jy,ny,locate,nt,nx,nxw,nyw,
     4                  luin,luout,lerr,jrec,jcenter,
     5                  l_StaCor,eof,lenhed,lntrhd,nfft,
     6                  rtabf,itabf,rtabi,fwgt,
     7                  itabi,work,twgt,omtwgt,
     8                  lenrtab,lenitab,lenwork,ler,nxpad,
     9                  istart,iend,nt_orig,nbytes_out,
     a                  l_LinInd,l_DphInd,jpqlive,npqlive,
     b                  ifmt_LinInd,ln_LinInd,ifmt_DphInd,ln_DphInd,
     c                  ifmt_StaCor,ln_StaCor,reject,kypointer,
     d                  starttrace,endtrace,startline,endline,
     e                  kximin,kximax,kyimin,kyimax,
     b               ifmt_RecNum,l_RecNum,ln_RecNum,
     c               ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
c__________________________________________________________________________
c     input seismic records.                  
c___________________________________________________________________
      complex   utaup(ifl:ifh,npqlive)
      integer   iypointer(-my:ny+my)
      integer   kypointer(0:ny)
c___________________________________________________________________
c     output vectors.                         
c___________________________________________________________________
      complex   uout(ifl:ifh,0:nx,kximin:kximax,kyimin:kyimax)
      real      uorig(0:nt_orig,0:nx,0:my)
      logical   live(-mx:nx+mx,-my:+my)
      real      udata(0:nfft-1,*)
      real      tracebuf(-lenhed:nt)
      integer*2 trheader(lntrhd,0:nx,-my:my)
c___________________________________________________________________
c     reverse (tau,p,q) transform matrix
c___________________________________________________________________
      complex   rr(ifl:ifh,npqlive,kximin:kximax,kyimin:kyimax)
      integer   jpqlive(npqlive)
c_______________________________________________________________
c     fourier transform table and work arrays.
c_______________________________________________________________
      real       rtabf(lenrtab)
      integer    itabf(lenitab)
      real       rtabi(lenrtab)
      integer    itabi(lenitab)
      real       work(lenwork)
      real       twgt(0:nt),omtwgt(0:nt)
c___________________________________________________________________
c     timing arrays.
c___________________________________________________________________
      real     cputim(*),waltim(*)
c___________________________________________________________________
c     control parameters
c___________________________________________________________________
      integer  starttrace,endtrace,startline,endline
      logical  eof,reject
      initfftf=1
      initffti=1
c
      jrec=0
      iy=0
      ky=0
      do 90000 jy=0,ny
       write(ler,*) 'process line ',jy,' of ',ny
c___________________________________________________________________
c      loop over the inline (x) direction, taking the radon transform.
c      points lieing outside the computational window are 'dead'
c      (i.e. live(jx)=.false.)
c___________________________________________________________________
       do 40000 jx=0,nx
        call timstr(v1,w1)
        jrec=jrec+1
c___________________________________________________________________
c       initialize.
c___________________________________________________________________
        do 12000 jyi=kyimin,kyimax
         do 11000 jxi=kximin,kximax
          do 10000 jomega=ifl,ifh
           uout(jomega,jx,jxi,jyi)=(0.,0.)
10000     continue
11000    continue
12000   continue
c___________________________________________________________________
c       read in the (tau,p,q) transformed data.           
c___________________________________________________________________
        call timstr(v1,w1)
        call rdtaup(tracebuf,tracebuf,trheader(1,jx,iy),utaup,
     1              udata,live(jx,iy),luin,npqlive,nt_orig,istart,
     2              lenhed,nt,nfft,ifl,ifh,lerr,l_StaCor,
     3              rtabf,itabf,rtabi,
     4              itabi,work,ifmt_StaCor,ln_StaCor,
     5              lenrtab,lenitab,lenwork,initfftf,lntrhd)
        call timend(cputim(1),v1,v2,waltim(1),w1,w2)
        call timstr(v1,w1)
        do 30000 jpq=1,npqlive
         if(live(jx,iy)) then
            do 22000 jyi=kyimin,kyimax
             do 21000 jxi=kximin,kximax
              do 20000 jomega=ifl,ifh
               uout(jomega,jx,jxi,jyi)=uout(jomega,jx,jxi,jyi)+   
     1          rr(jomega,jpq,jxi,jyi)*utaup(jomega,jpq)
20000         continue
21000        continue
22000       continue
         endif
30000   continue
        call timend(cputim(5),v1,v2,waltim(5),w1,w2)
40000  continue
c____________________________________________________________
c      write out the results.
c_____________________________________________________________
       call timstr(v1,w1)
       call wrgather(tracebuf,tracebuf,trheader,uout,
     1               uorig,udata,udata,luout,mx,nx,my,iy,
     2               lenhed,lntrhd,nt,nfft,ifl,ifh,lerr,
     3               rtabi,itabi,work,
     5               lenrtab,lenitab,lenwork,initffti,
     6               istart,iend,nt_orig,nbytes_out,reject,
     7               l_dphind,l_linind,ky,omtwgt,
     8               ifmt_LinInd,ln_LinInd,ifmt_DphInd,ln_DphInd,
     9               kximin,kximax,kyimin,kyimax,
     a               jy,startline,endline,
     b               ifmt_RecNum,l_RecNum,ln_RecNum,
     c               ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)

       call timend(cputim(10),v1,v2,waltim(10),w1,w2)
90000 continue
c
      return
      end


