C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine env2(u,a2,n,nfft2,flowpass,cwork,rwork)
   
      real      a2(0:n-1),u(0:n-1)
      real      rwork(0:nfft2-1,2)
      real      flowpass(0:nfft2/2-1)
c
      complex   cwork(0:nfft2/2-1,2)
      complex   ci
      data      ci/(0.,1.)/
c__________________________________________________________________________
c     take forward FFT of the data.                     
C_______________________________________________________________________
      call vmov(u,1,rwork(0,1),1,n)
      call vclr(rwork(n,1),1,nfft2-n)
      call rfftb(rwork(0,1),cwork(0,1),nfft2,+1)         
      call rfftsc(cwork(0,1),nfft2,2,1)        
c__________________________________________________________________________
c     low pass filter the data.                   
c     calculate Hilbert transform of the trace.
C_______________________________________________________________________
      do 10000 kfreq=0,nfft2/2-1
       cwork(kfreq,1)=cwork(kfreq,1)*flowpass(kfreq)
       cwork(kfreq,2)=ci*cwork(kfreq,1)
10000 continue
c__________________________________________________________________________
c     take inverse FFT of the low passed data.          
c     copy results back into u.
c_______________________________________________________________________
      call rfftb(cwork(0,1),rwork(0,1),nfft2,-1) 
c__________________________________________________________________________
c     take inverse FFT of the Hilbert transformed data. 
c_______________________________________________________________________
      call rfftb(cwork(0,2),rwork(0,2),nfft2,-1) 
c__________________________________________________________________________
c     calculate the envelope squared            
c_______________________________________________________________________
      do 20000 k=0,n-1
       a2(k)=rwork(k,1)**2+rwork(k,2)**2
20000 continue
c
      return
      end 
