C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine hdinit(ibuffer,p,delt,lentr2,lenhed,               
     1                  np,irec,l_TrcNum,l_DstUsg,l_recnum,l_stacor,
     2                  dt,ytransform,ifmt_StaCor,ln_StaCor,
     3             ifmt_TrcNum,ln_TrcNum,ifmt_DstUsg,ln_DstUsg,
     4             ifmt_RecNum,ln_RecNum,
     5             l_RedVel,ifmt_RecVel,ln_RecVel) 
c
#include <save_defs.h>
C
      integer    ibuffer(1:lentr2,np)
      real       p(np)
      real       delt(np)
      logical    ytransform
c
      if(ytransform) then
c_____________________________________________________________________
c        transform from (tau,y,p) to (tau,q,p)
c                               or
c                  from (t,y,x)   to (tau,q,x)
c
c        store p (which is actually q) in trace header 'TVPT21'
c_____________________________________________________________________
         call savelu('TVPT21',ifmt_TVPT21,l_TVPT21,ln_TVPT21,
     1               TRACEHEADER)
c_____________________________________________________________________
c        store 'q' in two places:
c        in 'DstUsg' for use in predictive deconvolution (eg taupred).
c        in 'TVPT21' for subsequent (tau,p,q) filtering.
c_____________________________________________________________________
         do 10000 ip=1,np
          call savew2(ibuffer(1,ip),ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                ip     , 1)
          ival = nint(1.e+07*p(ip)*dt)
          ptrue=p(ip)*1000.*dt
          if(ptrue .ne. 0.) then
             vapp=1./ptrue
          else
             vapp=1.e+10
          endif
          if(vapp .gt. 32767) then 
             jval=32767
          elseif(vapp .le. -32767) then
             jval=-32767
          else
             jval=nint(vapp)
          endif
          call savew2(ibuffer(1,ip),ifmt_RedVel,l_RedVel,ln_RedVel,
     1                jval,TRACEHEADER)
          call savew2(ibuffer(1,ip),ifmt_DstUsg,l_DstUsg, ln_DstUsg,
     1                ival,TRACEHEADER)
          call putfp2(ibuffer,ifmt_TVPT21,l_TVPT21,ln_TVPT21,
     1                p(ip),TRACEHEADER)
10000    continue

      else
c_____________________________________________________________________
c        transform from (tau,x,q) to (tau,p,q)
c                               or
c                  from (t,x,y)   to (tau,p,y)
c
c        store p in trace header 'TVPT20'
c_____________________________________________________________________
         call savelu('TVPT20',ifmt_TVPT20,l_TVPT20,ln_TVPT20,
     1               TRACEHEADER)
c_____________________________________________________________________
c        store 'p' in two places:
c        in 'DstUsg' for use in predictive deconvolution (eg taupred).
c        in 'TVPT20' for subsequent (tau,p,q) filtering.
c_____________________________________________________________________
         do 20000 ip=1,np
          call savew2(ibuffer(1,ip),ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                ip     , 1)
          ival = nint(1.e+07*p(ip)*dt)
          call savew2(ibuffer(1,ip),ifmt_DstUsg,l_DstUsg, ln_DstUsg,
     1                ival   , 1)
          call putfp2(ibuffer,ifmt_TVPT20,l_TVPT20,ln_TVPT20,
     1                p(ip),TRACEHEADER)
20000    continue
      endif
c
      return
      end 

