C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine rdgather(tbufin,ibufin,ibufout,
     1               hbegin,nsamp,lentr2,ntr,np,luin,lerr,eod,irec,
     2               lntrhd,l_DstSgn,l_StaCor,l_TrcNum,xwgt,
     4               live,theta,dist,zref,xmax,
     5               l_mute,hyperbolic,parabolic,linear,
     6               fourier,nlive,l_disthdr,ler,lentr2_out,
     7               ifmt_StaCor,ln_StaCor,ifmt_TrcNum,ln_TrcNum,
     8               ifmt_DstSgn,ln_DstSgn,ifmt_disthdr,ln_disthdr,
     9               ifmt_mute,ln_mute,lenhed,tpad,str)
      integer   hbegin
c___________________________________________________________________________
c     ibufin and tbufin are equivalenced by the calling arguments.
c___________________________________________________________________________
      integer   ibufin(lentr2,ntr)
      integer   ibufout(lentr2_out,np)  
      real      tbufin(hbegin:nsamp,ntr)
      real      str(hbegin:nsamp)
      real      dist(ntr),theta(ntr),xwgt(ntr)
      integer   tpad
      logical   live(ntr)
      logical   hyperbolic,parabolic,linear,fourier,eod
c
      nlive = 0
      ierror=0
      do 10000 itr=1,ntr
       nbytes = 0
       call rtape(luin,str(hbegin),nbytes)
       if(nbytes .eq. 0) then
          write(LERR,*)'End of file on input:'
          write(LERR,*)'  rec= ',irec,'  trace= ',itr
          eod=.true.
       endif
       call vmov (str, 1, tbufin(hbegin,itr), 1, 1-hbegin)
       call vmov (str(1), 1, tbufin(tpad+1,itr), 1, nsamp-tpad)
       call savew2(ibufin(1,itr) ,ifmt_mute,l_mute, ln_mute,
     1              0      , 1)
       call saver2(ibufin(1,itr) ,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1              idstsgn, 1)
       call saver2(ibufin(1,itr) ,ifmt_StaCor,l_StaCor, ln_StaCor,
     1              istacor, 1)
       call saver2(ibufin(1,itr) ,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1              itrcnum, 1)
       dist(itr)=idstsgn                   
       if(istacor .eq. 30001) then
c___________________________________________________________________
c         radon transform of data already transformed in one direction.
c         all p or q components are live.
c___________________________________________________________________
          live(itr)=.true. 
          call savew2(ibufin(1,itr) ,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                 30002, 1)
       elseif(istacor .eq. 30000) then
          live(itr)=.false.
          call savew2(ibufin(1,itr) ,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                 30001, 1)
          call vclr(tbufin(1,itr),1,nsamp)
       else
          live(itr)=.true.
          nlive=nlive+1
          if(abs(dist(itr)) .gt. xmax) then
             write(lerr,*) 'command line error!'
             write(lerr,*) 'xmax is not largest offset in data!'
             write(lerr,*) 'xmax from command line = ',xmax     
             write(lerr,*) 'trace distance         = ',dist(itr)
             write(lerr,*) 'record ',irec,' trace ',itr         
             write(ler ,*) 'command line error!'
             write(ler ,*) 'xmax is not largest offset in data!'
             write(ler ,*) 'xmax from command line = ',xmax     
             write(ler ,*) 'trace distance         = ',dist(itr)
             write(ler ,*) 'record ',irec,' trace ',itr         
             ierror=ierror+1
          endif
c___________________________________________________________________
c         mute preservation initialization.
c___________________________________________________________________
          do 4000 isamp=1,nsamp
           if(tbufin(isamp,itr) .ne. 0) then
c             ibufin(l_mute,itr)=isamp-1
              call savew2(ibufin(1,itr),ifmt_mute,l_mute,
     1                     ln_mute, isamp-1-tpad, 1)
              go to 4001
           endif
4000      continue
4001      continue
       endif
       if(linear .or. fourier) then
          theta(itr)=dist(itr)
       elseif(hyperbolic) then
          theta(itr)=sqrt(zref**2+dist(itr)**2)-zref
       else
          theta(itr)=dist(itr)**2
       endif
c___________________________________________________________________________
c      copy input trace header into output trace header.
c
c      copy signed trace distance into location l_disthdr for use
c      in the inverse transform radonr (this location will be different
c      for x or y transforms).
c
c      change the dead trace flag such that programs pred and taupred
c      work correctly.
c      this dead trace flag will be checked for in routine radonr.
c___________________________________________________________________________
       do 9000 k=1,lenhed
        ibufout(k,itr)=ibufin(k,itr)
9000   continue
c      ibufout(l_disthdr,itr)=nint(dist(itr))
       ival = nint(dist(itr))
       call savew2(ibufout(1,itr),ifmt_disthdr,l_disthdr, ln_disthdr,
     1              ival , 1)
       if(.not. live(itr))
     1 call savew2(ibufout(1,itr),ifmt_StaCor,l_StaCor, ln_StaCor,
     2             30001, 1)
10000 continue

      do 12000 itr=ntr+1,np
       do 11000 k=1,lenhed
        ibufout(k,itr)=ibufin(k,ntr) 
11000  continue
       call savew2(ibufout(1,itr) ,ifmt_StaCor,l_StaCor, ln_StaCor,
     1             30001, 1)
12000 continue
c___________________________________________________________________________
c     taper the edges of the data:
c___________________________________________________________________________
      do 15000 itr=1,ntr
       if(xwgt(itr) .ne. 1.) then
          do 14000 isamp=1,nsamp
           tbufin(isamp,itr)=xwgt(itr)*tbufin(isamp,itr)
14000     continue
       endif
15000 continue
c  
      if(ierror .gt. 0) then
         write(lerr,*) 'program terminated in routine rdgather'
         write(lerr,*) 'number of traces failing critereon = ',ierror
         write(lerr,*) 'record number = ',irec
         write(lerr,*) 'check other records and resubmit'
         write(ler ,*) 'program terminated in routine rdgather'
         write(ler ,*) 'number of traces failing critereon = ',ierror
         write(ler ,*) 'record number = ',irec
         write(ler ,*) 'check other records and resubmit'
         close(lerr)
         call exit(30001)
      endif
c
      return
      end

