C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine taup(uin,utaup,ui,len,nfft,nfft2,
     1                ntr,np,firstrec, 
     2                p,theta,w,ndiv,adiv,work,ncount,
     3                live,trcwgt,trcwgtsum,ipw,lerr,pw,
     4                anum,adenom,semblance,taupwgt,             
     5                anum2,swgt,lswgt,lgate,
     6                alphatrim,alpha,cputim,waltim)
c___________________________________________________________________
c     calculate tau-p transform in the x-t domain to avoid wraparound.
c___________________________________________________________________
c     uin    = input (x-t) data.
c     utaup   = output (tau-p) data.                         
c___________________________________________________________________
      real      uin(nfft,ntr)
      real      ui(nfft,ntr)
      real      utaup(nfft,np)  
      real      taupwgt(nfft,np)  
      real      trcwgt(len),trcwgtsum(len)
      real      work(len)
      real      anum(len),adenom(len)
      real      anum2(len)      
      integer   ncount(len)
      real      swgt(0:lswgt)
c
      real      p(np)
      real      theta(ntr)
      real      w(-3:+4,0:ndiv)                         
      integer   firstsamp,lastsamp
      logical   live(ntr)
      logical   semblance,ipw,firstrec

      logical   alphatrim
      real      alpha
      real      cputim(*),waltim(*)
      integer   loidx, hiidx
c
      if(ipw) then
c___________________________________________________________________
c        calculate rms amplitude for normalization
c___________________________________________________________________
         usum2=1.e-20
         do 10200 jtr=1,ntr
          if(live(jtr)) then
             do 10100 isamp=1,len
              usum2=usum2+uin(isamp,jtr)**2
10100        continue
          endif 
10200    continue
         usum2=usum2/(ntr*len)
         eps=pw*usum2 
         firstrec=.false.
      else
         eps=1.e-20
      endif
c___________________________________________________________________
c     loop over all p values.                        
c___________________________________________________________________
      do 80000 jp=1,np
       do 10300 isamp=1,len
        ncount(isamp)=0
103000 continue
       call timstr(v1,w1)
       do 20000 jtr=1,ntr
        if(live(jtr)) then
           ptheta=p(jp)*theta(jtr)
           if(ptheta .ge. 0.) then
              jptheta=ptheta   
           else
              jptheta=ptheta-1.   
           endif
           firstsamp=max(4-jptheta,1)
           lastsamp=min(len,len-(jptheta+4))
           idiv=nint(adiv*(ptheta-jptheta))
c
           do 11000 isamp=1,firstsamp-1
            ui(isamp,jtr)=0.
11000      continue
c
           do 12000 isamp=lastsamp+1,len
            ui(isamp,jtr)=0.
12000      continue
c
           do 13000 isamp=firstsamp,lastsamp
            ileft=isamp+jptheta
            ui(isamp,jtr)= w(-3,idiv)*uin(ileft-3,jtr)
     1                       +w(-2,idiv)*uin(ileft-2,jtr)
     2                       +w(-1,idiv)*uin(ileft-1,jtr)
     3                       +w( 0,idiv)*uin(ileft  ,jtr)
     4                       +w(+1,idiv)*uin(ileft+1,jtr)
     5                       +w(+2,idiv)*uin(ileft+2,jtr)
     6                       +w(+3,idiv)*uin(ileft+3,jtr)
     7                       +w(+4,idiv)*uin(ileft+4,jtr)
            if(ui(isamp,jtr) .ne. 0.) then
                ncount(isamp)=ncount(isamp)+1
            endif
13000      continue
        endif
20000  continue
       call timend(cputim(17),v1,v2,waltim(17),w1,w2)
c
       call timstr(v1,w1)
       call vclr(utaup(1,jp),1,nfft) 
       call vclr(taupwgt(1,jp),1,nfft) 
       if(ipw) then
c__________________________________________________________________
c         inverse power weighting
c__________________________________________________________________
          call vclr(trcwgtsum(1),1,len)
          do 26000 jtr=1,ntr
           if(live(jtr)) then
              do 23000 isamp=1,len
               trcwgt(isamp)=ui(isamp,jtr)**2
23000         continue
c__________________________________________________________________
c             calculate the average inverse over a temporal gate.
c__________________________________________________________________
              do 23500 isamp=1+lgate,len-lgate
               work(isamp)=0.
               do 23400 j=-lgate,+lgate
                work(isamp)=work(isamp)+trcwgt(isamp+lgate)
23400          continue
23500         continue
              do 23600 isamp=1,lgate
               work(isamp)=work(lgate+1)
23600         continue
              do 23700 isamp=len-lgate+1,len  
               work(isamp)=work(len-lgate)
23700         continue
c
              do 23800 isamp=1,len
               trcwgt(isamp)=1./(work(isamp)+eps)
c              trcwgt(isamp)=1.
               trcwgtsum(isamp)=trcwgtsum(isamp)+trcwgt(isamp)
23800         continue
c
              do 24000 isamp=1,len
               utaup(isamp,jp)=utaup(isamp,jp)+
     1                          trcwgt(isamp)*ui(isamp,jtr)
24000         continue
           endif
26000     continue
          do 28000 isamp=1,len
           denom=trcwgtsum(isamp)*ncount(isamp)
           if(denom .ne. 0) then
              utaup(isamp,jp)=utaup(isamp,jp)/denom             
           else
              utaup(isamp,jp)=0.
           endif
28000     continue
       elseif(semblance) then
c__________________________________________________________________
c         semblance weighting
c__________________________________________________________________
          call vclr(anum(1),1,len)
          call vfill(eps,adenom(1),1,len)
c__________________________________________________________________
c         calculate semblance for each sample.
c__________________________________________________________________
          do 52000 jtr=1,ntr
           if(live(jtr)) then
              do 51000 isamp=1,len
               anum(isamp)=anum(isamp)+ui(isamp,jtr)
               adenom(isamp)=adenom(isamp)+ui(isamp,jtr)**2   
51000         continue
           endif
52000     continue
          do 53000 isamp=1,len
           anum2(isamp)=anum(isamp)**2
53000     continue
c__________________________________________________________________
c         integrate semblance over a gated window.
c__________________________________________________________________
          fact=float(lswgt)/ntr   
          do 55000 isamp=1+lgate,len-lgate
           anumsum=0.
           adenomsum=0.
           do 54000 j=-lgate,+lgate
            anumsum=anumsum+anum2(isamp+j)
            adenomsum=adenomsum+adenom(isamp+j)
54000      continue
           jsemb=(anumsum/adenomsum)*fact
           taupwgt(isamp,jp)=swgt(jsemb)
c$         utaup(isamp,jp)=anum(isamp)*taupwgt(isamp,jp)
           utaup(isamp,jp)=anum(isamp)
55000     continue
          do 56000 isamp=1,lgate
           taupwgt(isamp,jp)=taupwgt(lgate+1,jp)
c$         utaup(isamp,jp)=anum(isamp)*taupwgt(isamp,jp)
           utaup(isamp,jp)=anum(isamp)
56000     continue
          do 57000 isamp=len-lgate+1,len
           taupwgt(isamp,jp)=taupwgt(len-lgate,jp)
c$         utaup(isamp,jp)=anum(isamp)*taupwgt(isamp,jp)
           utaup(isamp,jp)=anum(isamp)
57000     continue

          call timend(cputim(18),v1,v2,waltim(18),w1,w2)
       elseif (alphatrim) then
          call timstr(v1,w1)
c__________________________________________________________________
c         alpha trim mean.
c__________________________________________________________________
          call atmean(ui,nfft,len,ntr,1.-alpha,loidx,hiidx,lerr)
          call atmsum(ui,nfft,len,ntr,utaup(1,jp),loidx,hiidx)
          call timend(cputim(19),vsort,v2,waltim(19),wsort,w2)
       else
c__________________________________________________________________
c         conventional sum.
c__________________________________________________________________
          do 40000 jtr=1,ntr
           if(live(jtr)) then
              do 30000 isamp=1,len
               utaup(isamp,jp)=utaup(isamp,jp)+ui(isamp,jtr)
30000         continue
           endif
40000     continue
       endif
80000 continue
c
      return
      end
