C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine FitGain(ipoly,coef,irec,nsamp,ntrc,lucoef,
     :     OutputTrace, mutes,sstep,Gain,value,residual,
     :     agcWindow,maxtop,MedianAdjust,TraceMedians,ierr,CoefTap,
     :     UseCoefsFile)

#include <f77/iounit.h>

c routine to contruct gain trace based on polynomial

      integer ipoly,nsamp,ntrc,iresidual,nn,sstep
      integer j,IndexTrace,i,istarty,mutes(*),irec
      integer agcWindow,maxtop,isam,jsam,ierr,lucoef

      real OutputTrace(*),Gain(*),MaxNegative
      real*8 coef(*),value(*),sample,trace,residual(*)
      real*8 TraceMedians(ntrc),valmin

      character CoefTap*(*)

      logical MedianAdjust,UseCoefsFile

      MaxNegative = 0.0
      

c construct output trace for all samples
      IndexTrace = 1 - nsamp

      DO j=1,ntrc
         
c initialize median for this trace

         IndexTrace = IndexTrace + nsamp

         nn = nsamp - mutes(j) + 1
         if(nn.gt.nsamp)nn = nsamp
         if(mutes(j).ge.nsamp) nn = 0
         istarty = IndexTrace + mutes(j) - 1
         if(mutes(j).lt.1)istarty = istarty + 1
  
         do i = istarty + nn - 1,istarty,-1

            trace = dble(j)
            isam = i - IndexTrace + 1
            sample = dble(isam)
            call peval3(trace,sample,coef,ipoly,value(isam))
            if(i.eq.istarty + nn - 1) then
               valmin = value(isam)
            else
               value(isam) = dmin1(value(isam),value(isam + 1)) 
               valmin = dmin1(value(isam),valmin)
            endif

         enddo

c calculate median if requested by user

         if(MedianAdjust)then

            iresidual = 0
         
            do i = istarty + agcWindow / 2,
     :      istarty + nn - 1 - agcWindow / 2,sstep

               if(maxtop.gt.0.and.i.lt.(IndexTrace+maxtop-1).and.
     :              i.gt.istarty.and.sstep.gt.1) then

                  do kk = i - sstep + 1,i - 1

                    jsam = kk - IndexTrace + 1

                     if(Gain(kk).gt.0.0.and.kk.lt.IndexTrace + maxtop-1)
     :                    then

                        iresidual = iresidual + 1
                    residual(iresidual) = dble(Gain(kk)) - value(jsam)
                        
                     endif

                  enddo

               else

                  isam = i - IndexTrace +1
                  iresidual = iresidual + 1
                  residual(iresidual) = dble(Gain(i)) - value(isam)
              
               endif

            enddo

c calculate median of residuals if there are sufficient values

            if(iresidual.gt.3) then

              call dmdian(iresidual,residual,TraceMedians(j))
            
              if(TraceMedians(j) + valmin.lt.0.0d0) then
            
                if(valmin.gt.0.0d0) then

                    TraceMedians(j) = -0.999d0 * valmin

                elseif(TraceMedians(j).lt.0.0d0.and.valmin.le.0.0d0)then

                    TraceMedians(j) = 0.0d0

                 endif

               endif

              if(mutes(j).ge.nsamp) TraceMedians(j) = 0.0d0

            else

              TraceMedians(j) = 0.0d0

            endif

           else

           TraceMedians(j) = 0.0d0

         endif

c adjust output by median of residuals

         do i = istarty,istarty + nn - 1

            isam = i - IndexTrace + 1
            OutputTrace(i) = sngl(value(isam) + TraceMedians(j))

c watch for negative gain values

            if(OutputTrace(i).lt.0.)then
               MaxNegative = amin1(Maxnegative,OutputTrace(i))
            endif

         enddo
         
      ENDDO

c make certain no negative gain values exist
      IndexTrace = 1 - nsamp

      do j = 1,ntrc
         IndexTrace = IndexTrace + nsamp
         do i = 1,nsamp
            OutputTrace(IndexTrace+i-1) = OutputTrace(IndexTrace+i-1) + 
     :           abs(MaxNegative)*1.0001
         enddo
      enddo            
      
c Record parameters in RavnCoefs file for reapplication or removal of gain

      call RavnCoefOut(ierr,irec,ipoly,coef,lucoef,
     :     TraceMedians,ntrc,MaxNegative,CoefTap,UseCoefsFile)

      return
      end
