C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine RavnCoefOut(ierr,JJ,ipoly,coef,lucoef,
     :     TraceMedians,ntrc,MaxNegative,CoefTap,UseCoefsFile)

#include <f77/iounit.h>

      integer lucoef,ierr,JJ,ipoly,ipoly2,ntrc,lecoef

      real MaxNegative

      real*8 coef(*),TraceMedians(ntrc)

      character CoefTap*(*)

      logical UseCoefsFile

      ipoly2 = (ipoly + 1) * (ipoly + 2) / 2

c only write the output if not using a current Coefficients file

      IF(.not.UseCoefsFile)THEN

         if(CoefTap .eq. ' ')CoefTap = 'RavnCoefs'
         lecoef = lenth(CoefTap)

c - restructured this for the convex - joe m. wade - 12/9/94

#ifdef SUNSYSTEM
         open(unit=lucoef,file=CoefTap(1:lecoef),status='unknown',
     :        fileopt='eof',err=999)
#else
#ifdef CRAYSYSTEM
         open(unit=lucoef,file=CoefTap(1:lecoef),status='unknown',
     :        position='append',err=999)
#else
         open(unit=lucoef,file=CoefTap(1:lecoef),status='unknown',
     :        access='append',err=999)
#endif
#endif

         if(ierr.ne.0)then

c if no surface was generated then output an order = zero
c this will cause the restoregain routine to fill gain with
c 1.0 values only and return

            write(lucoef,*)jj,' 0',' 0'
         else
            write(lucoef,*)JJ,ipoly,ipoly2
            do ii = 1,ipoly2

c since coef(iloc) is passed to FitGain[] which calls this routine the
c               write(lucoef,*)coef(ii + iloc - 1)
c may become:
               write(lucoef,*)coef(ii)

            enddo
         endif

         if(ierr.eq.0)then
         
            do j = 1,ntrc
               write(lucoef,*)j,TraceMedians(j) 
            enddo
            write(lucoef,*)MaxNegative

         endif

         close(lucoef)

      ENDIF
      
      return

 999  continue

      write(LERR,*)'RAVN:  Error opening Coefficients file ',
     :     CoefTap(1:lecoef)
      write(LERR,*)'       Check existance, permissions etc.'
      write(LERR,*)'FATAL'

      write(LER,*)'RAVN:  Error opening Coefficients file ',
     :     CoefTap(1:lecoef)
      write(LER,*)'       Check existance, permissions etc.'
      write(LER,*)'FATAL  device = ',lucoef

      stop
      end
