C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine RestoreGain(CoefTap,coef,nsamp,ntrc,Gain,mutes,istepy,
     :     value,MedianAdjust,irec,lucoef)

#include <f77/iounit.h>

c     routine to contruct gain trace based on polynomial

      integer order,nsamp,ntrc,numcoef,nn,istepy,lucoef,irec
      integer j,IndexTrace,i,istarty,mutes(*),junk,isam,lecoeftap

      real Gain(*),MaxNegative

      real*8 coef(*),value(*),sample,trace
      real*8 median,realjunk,valmin

      character CoefTap*(*)

      logical MedianAdjust

      MaxNegative = 0.0

c open coefficients file 

      lecoeftap = lenth(CoefTap)
      if (lecoeftap .eq. 0) then
	lecoeftap = 1
	go to 990
      else
        open(unit=lucoef,file=CoefTap(1:lecoeftap),status='old',
     :     err=990)
      endif

c get p3eval variables from coefficients file

 10   read(lucoef,*,err=900,end=910)junk,order,numcoef

c read coefs file until record is found

      IF(junk.eq.irec)then

         if(order.ne.0)then

c only read coefficients if they are meaningful.  If order
c is zero then no surface was used and gain applied was 1.0

            do i = 1,numcoef

               read(lucoef,*,err=900,end=910) coef(i)

            enddo

         else

            call vfill(1.0,Gain,1,ntrc*nsamp)
            close(lucoef)
            return

         endif

c construct output trace for all samples

         IndexTrace = 1 - nsamp   

         DO j=1,ntrc

            IndexTrace = IndexTrace + nsamp
            nn = nsamp - mutes(j) + 1
            if(nn.gt.nsamp) nn = nsamp
            if(mutes(j).ge.nsamp) nn = 0
            istarty = IndexTrace + mutes(j) - 1
            if(mutes(j).lt.1) istarty = istarty + 1

c reconstruct surface from coefficients
  
            do i = istarty + nn - 1,istarty,-1

               trace = dble(j)
               isam = i - IndexTrace + 1
               sample = dble(isam)
               call peval3(trace,sample,coef,order,value(isam))

               if(i.eq.istarty + nn - 1) then

                  valmin = value(isam)

               else

                  value(isam) = dmin1(value(isam),value(isam + 1)) 
                  valmin = dmin1(value(isam),valmin)

               endif

            enddo
            
c get median for this trace from coefficients file

            read(lucoef,*,err=900,end=910) junk , median

c adjust output by median of residuals and MaxNegative
c calculated during gain determination in subroutine FitGain.F
c unless it is requested not to by setting the MedianAdjust
c flag to false  (-nomedian on command line)

            if(MedianAdjust)then

               do i = istarty,istarty + nn - 1
                  isam = i - IndexTrace + 1
                  Gain(i) = sngl(value(isam) + median)
               enddo

            else

               do i = istarty,istarty + nn - 1
                  isam = i - IndexTrace + 1
                  Gain(i) = sngl(value(isam))

c make certain no negative gain values exist

                  if(Gain(i).lt.0.)then
                     MaxNegative = amin1(Maxnegative,Gain(i))
                  endif
               enddo

            endif

         ENDDO

c if using median get MaxNegative from file 

         if(MedianAdjust)then

            read(lucoef,*,err=900)MaxNegative

         else

            read(lucoef,*,err=900)realjunk

         endif
 
c adjust for any negative gain values found

         if(abs(MaxNegative).gt.1.e-30)then
            IndexTrace = 1 - nsamp
            do j = 1,ntrc
               IndexTrace = IndexTrace + nsamp
               do i = 1,nsamp
                  Gain(IndexTrace+i-1) = Gain(IndexTrace+i-1) + 
     :                 abs(MaxNegative)*1.0001
               enddo
            enddo 
            
         endif 

      ELSE

         if(order.ne.0)then
            do i = 1,numcoef
               read(lucoef,*,err=900)coef(i)
            enddo
         else
            goto 10
         endif

         do i = 1,ntrc
            read(lucoef,*,err=900) junk , median
         enddo

         read(lucoef,*,err=900)MaxNegative

         goto 10

      ENDIF

      close(lucoef)
      return

 900  continue
      write(LERR,*)'RAVN: Error reading coefficients file'
      write(LERR,*)'      Check existance/permissions/contents'
      write(LERR,*)'FATAL'
      write(LERR,*)' '
      write(LER,*)'RAVN: Error reading coefficients file'
      write(LER,*)'      Check existance/permissions/contents'
      write(LER,*)'FATAL'
      write(LER,*)' '

      stop

 910  continue
      write(LERR,*)'RAVN: Premature EOF on Coefficients file ',
     :     CoefTap(1:lecoeftap)
      write(LERR,*)'FATAL'
      write(LERR,*)' '
      write(LER,*)' '
      write(LER,*)'RAVN: Premature EOF on Coefficients file ',
     :     CoefTap(1:lecoeftap)
      write(LER,*)'FATAL'
      write(LER,*)' '

      stop

 990  continue
      write(LERR,*)'RAVN: Cannot Open Coefficients file ',
     :     CoefTap(1:lecoeftap)
      write(LERR,*)'FATAL'
      write(LERR,*)' '
      write(LER,*)' '
      write(LER,*)'RAVN: Cannot Open Coefficients file ',
     :     CoefTap(1:lecoeftap)
      write(LER,*)'FATAL'
      write(LER,*)' '

      stop
      end



