C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine dmdian(n,x,xmdian)

c***********************************************************************
c     This subroutine determines the median value of an array after
c     sorting into increasing order.
c
c**** Subroutine inputs.
c
c     n = The number of points in the input data array.
c     x = The input array of data values under consideration.
c
c**** Subroutine outputs.
c
c     x = The input array sorted into increasing order.
c     xmdian = The median value of the array x.
c
c**** Subroutines required.
c
c     dslect
c     dminsn
c     dswap
c
c***********************************************************************

      real*8 x(n),xmdian,x1,x2,absx
      integer n,nind2,index2,indexa

      nind2 = n / 2

      if(amod(real(n),2.0).ne.0) then

        call dslect(nind2 + 1,n,x,xmdian)

        else

        call dslect(nind2,n,x,x1)
        call dminsn(nind2,x(nind2 + 1),x2,index2,absx,indexa)
        xmdian = (x1 + x2) / 2.0d0

      endif

      return
      end
