C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine dordr2(r2,n,varlim,ir2opt)

c***********************************************************************
c     During polynomial fitting when the curve begins to be fitted to
c     noise, the goodness of fit (square of the regression coefficient)
c     changes very slowly.  This subroutine determines the order of fit
c     at which this occurs based on searching backwards through the
c     array for the element which deviates from the mean of the
c     subsequent elements by greater than varlim.
c
c**** Subroutine inputs.
c
c     r2 = The array of squares of the regression coefficient.
c     n = The number of regression coefficients, (no. of elements in r2)
c     varlim = The size of the allowed variation from the mean.
c
c**** Subroutine outputs.
c
c     ir2opt = The index of the regression coefficient above which there
c              is little variation (within varlim of the mean of this
c              and the elements with greater indices)
c
c**** Subroutine required
c
c     dxmean
c
c***********************************************************************

      real*8 r2(n),r2mean,varlim
      integer n,ir2opt,i

      r2mean = r2(n)

      do i = n - 1,1,-1

        if(dabs(r2(i) - r2mean).le.varlim) then

          if(i.eq.1) then

            ir2opt = 1
            return

          endif

          call dxmean(r2(i),n - i + 1,r2mean)

          else

          ir2opt = i + 1
          return

        endif

      enddo

      end
