C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine dsdev(x,n,xmean,sdev)

c***********************************************************************
c     This subroutine computes the mean and standard deviation of the
c     elements in an array without round off error
c
c     Hill, I.D. 1979. On calculating a standard deviation.
c     Teaching Statistics, 1: 81-84.
c
c**** Subroutine inputs.
c
c     x = The array of values.
c     n = The number of values in array x.
c
c**** Subroutine outputs.
c
c     xmean = The mean value of the elements in array, x.
c     sdev = The standard deviation of the elements in x.
c
c***********************************************************************

      real*8 x(n),xmean,sdev,delta,dblei
      integer n,i

      xmean = x(1)
      sdev = 0.0d0

      do i = 2,n

        dblei = dble(i)
        delta = (x(i) - xmean) / dblei
        xmean = xmean + delta
        sdev = sdev + dblei * (dblei - 1.0d0) * delta * * 2

      enddo

      sdev = dsqrt(sdev / dble(n - 1))

      return
      end
