C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine dxmean(x,n,xmean)

c***********************************************************************
c     This subroutine computes the mean and standard deviation of the
c     elements in an array without round off error
c
c     Hill, I.D. 1979. On calculating a standard deviation.
c     Teaching Statistics, 1: 81-84.
c
c**** Subroutine inputs.
c
c     x = The array of values.
c     n = The number of values in array x.
c
c**** Subroutine outputs.
c
c     xmean = The arithetic mean value of the elements in array, x.
c
c***********************************************************************

      real*8 x(n),xmean,delta
      integer n,i

      xmean = x(1)

      do i = 2,n

        delta = (x(i) - xmean) / dble(i)
        xmean = xmean + delta

      enddo

      return
      end
