C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine verbal(nsamp,nsi,ntrc,nrec,iform,ntap,otap,CoefTap,
     :     sstep,tstep,tstart,tend,TopOverSample,agcWindow,agcScalar,
     :     ave,rms,median,irtype,limord,NumMedGleanIter,ilim,remove,
     :     UseCoefsFile,MedianAdjust,OutputGainCurveOnly, Sord)

      integer nsamp,nsi,ntrc,nrec,iform,sstep,tstart,tstep,tend
      integer TopOverSample,irtype,limord,NumMedGleanIter,ilim
      integer agcWindow,Sord

      real agcScalar
      character ntap*(*), otap*(*), CoefTap*(*)

      logical ave,rms,median,remove,UseCoefsFile,MedianAdjust
      logical OutputGainCurveOnly

#include <f77/iounit.h>

      write(LERR,*)
      write(LERR,*)' Line Header Input'
      write(LERR,*)
      write(LERR,*) ' # of Samples/Trace =  ', nsamp
      write(LERR,*) ' Sample Interval    =  ', nsi  
      write(LERR,*) ' Traces per Record  =  ', ntrc 
      write(LERR,*) ' Records per Line   =  ', nrec 
      write(LERR,*) ' Format of Data     =  ', iform
      write(LERR,*) ' Start process trace=  1'
      write(LERR,*) ' End process trace  =  ', ntrc
      write(LERR,*)' '
      write(LERR,*)' Command Line Input'
      write(LERR,*)' '
      write(LERR,*)' Input dataset name : ',ntap
      write(LERR,*)' Output dataset name : ',otap
      if(CoefTap .eq. ' ')then
         write(LERR,*)' Coefficients dataset name : RavnCoefs'
      else
         write(LERR,*)' Coefficients dataset name : ',CoefTap
      endif
      write(LERR,*)' '
      write(LERR,*)' Decimation Parameters'
      write(LERR,*) ' Sample step size(ms) = ',sstep*nsi
      write(LERR,*) ' Trace step size = ',tstep
      write(LERR,*) ' First Trace = ',tstart
      write(LERR,*) ' Last Trace  = ',tend
      if(TopOverSample.ne.0) then
      write(LERR,*) ' Oversample top ',nint(100./float(TopOverSample)),
     :     ' percent'
      else
      write(LERR,*) ' Oversample top ',TopOverSample,' percent'
      endif
      write(LERR,*)' '
      write(LERR,*)' Gain Determination Parameters'
      write(LERR,*) ' AGC window size = ',agcWindow,' ms'
      if(agcScalar.gt.1e-21)then
         write(LERR,*) ' AGC amplitude = ',agcScalar,' percent'
      else
         write(LERR,*) ' AGC amplitude = 15 percent'
      endif
      if(ave) then
         write(LERR,*) ' Normalize using average of gain curves in windo
     :w over record'
      elseif(rms) then
         write(LERR,*) ' Normalize using rms of gain curves in window ov
     :er record'
      elseif(median) then
         write(LERR,*) ' Normalize using median of gain curves in window
     : over record'
      endif
      if(irtype.lt.1) then
         write(LERR,*) ' Fitting least squares solution'
      elseif(irtype.gt.0)then
         write(LERR,*) ' Fitting robust polynomial solution'
         write(LERR,*) ' User defined order to fit = ',Sord
      endif
         write(LERR,*) ' Maximum order of surface to test = ',limord
         write(LERR,*) ' Number of bad trace iterations = ',
     :        NumMedGleanIter
         write(LERR,*) ' Number of iterations for polynomial fit = ',
     :        ilim 
         write(LERR,*) ' User defined order to fit = ',Sord
      write(LERR,*)' '
      write(LERR,*)' Gain Application Parameters'

      if(.not.remove)then
         write(LERR,*) ' Gain will be applied to input data'
      else
         write(LERR,*) ' Gain will be removed from input data'
      endif
      if(MedianAdjust)then
         write(LERR,*) ' Gain surface will be constructed using '
         write(LERR,*) ' coefficients WITH MEDIAN ADJUSTMENT'
         write(LERR,*) ' applied to input data'
      else
         write(LERR,*) ' Gain surface will be constructed using '
         write(LERR,*) ' coefficients WITHOUT MEDIAN ADJUSTMENT'
         write(LERR,*) ' applied to input data'
      endif
      if(OutputGainCurveOnly) then
         write(LERR,*) ' Output data are gain surfaces'
      else
         write(LERR,*) ' Output data are scaled records'
      endif
      if(UseCoefsFile)then
         write(LERR,*) 'Gain curves constructed using coefficients file'
      endif

      return
      end
