/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <fcntl.h>
#include <ibm_fmt.h>
#include <cu_defs.h>
#include <io_defs.h>
#include <ut_defs.h>
#include <usp_headers.h>

FILE *prtfile;

void main(argc,argv)
int argc;
char **argv;
{
  int i,fd,bs,bytes,block_knt;
  int orig_block_length,block_length,record_length;
  IBM_Std_Vol_Label Vol_Lbl;
  IBM_Label_1 Lbl1;
  IBM_Label_2 Lbl2;
  char *buffer,*dataptr;
  int luout;
  FILE *outfile;
  char ntap[256],otap[256];
  char prtfilename[32];
  char *prgname;
  char hostname[9];
  int debug,verbose;
  int EOFknt = 0;
  void prt_standard_label();
  void prt_label_1();
  void prt_label_2();

  prgname = (char *)strrchr(argv[0],'/') + 1;
  verbose = C_ARGIS("-?",&argc,argv);
  verbose += C_ARGIS("-h",&argc,argv);
  if (verbose != 0) {
    fprintf(stderr,"\n%s: read NCSI (MSC) IBM format tapes ",prgname);
    fprintf(stderr,"written with writetape\n\n");
    fprintf(stderr,"Command line arguments for %s:\n\n",prgname);
    fprintf(stderr,"  -d dev  - device name for tape ( no default )\n");
    fprintf(stderr,"  -O otap - USP format output file ( stdout )\n");
    fprintf(stderr,"  -V      - verbose output saved to file (off)\n\n");
    fprintf(stderr,"Usage: %s -d dev -O otap -V\n",prgname);
    exit(0);
    }

  debug   = C_ARGIS("-D",&argc,argv);
  verbose = C_ARGIS("-V",&argc,argv);

  if (verbose != 0) {
    sprintf(prtfilename,"READTAPE.%d",getpid());

    if (C_IN_IKP() != 0) {
      if (gethostname(hostname,9) == 0) {
        hostname[8] = '\0';
        strcat(prtfilename,".");
        strcat(prtfilename,hostname);
        }
      }

    prtfile = fopen(prtfilename,"w");
    setlinebuf(prtfile);
    }

  if (prtfile == NULL) prtfile = stderr;
  setlinebuf(stderr);

  C_ARGSTR("-d",ntap," "," ",&argc,argv);
  if (strcmp(ntap," ") == 0)
    fd = 0;
  else {
    fd = open(ntap,O_RDONLY);
    if (fd < 0) {
	perror(prgname);
	exit(1);
	}
    }

  bytes = sizeof(IBM_Std_Vol_Label);
  buffer = (char *) malloc(bytes);
  memset((char *)&Vol_Lbl,0,bytes);
  read(fd,buffer,bytes);
  if (debug != 0)
	fprintf(prtfile,"Volume label is %d bytes\n",bytes);
  F_EBCASC(&Vol_Lbl,buffer,&bytes);
  free(buffer);

  if (verbose != 0) prt_standard_label(&Vol_Lbl);

  bytes = sizeof(IBM_Label_1);
  buffer = (char *) malloc(bytes);
  memset((char *)&Lbl1,0,bytes);
  read(fd,buffer,bytes);
  if (debug != 0)
	fprintf(prtfile,"First IBM label is %d bytes\n",bytes);
  F_EBCASC(&Lbl1,buffer,&bytes);
  free(buffer);

  if (verbose != 0) prt_label_1(&Lbl1);

  bytes = sizeof(IBM_Label_2);
  buffer = (char *) malloc(bytes);
  memset((char *)&Lbl2,0,bytes);
  read(fd,buffer,bytes);
  if (debug != 0)
	fprintf(prtfile,"Second IBM label is %d bytes\n",bytes);
  F_EBCASC(&Lbl2,buffer,&bytes);
  free(buffer);

  if (verbose != 0) prt_label_2(&Lbl2);

  {
  char *tmpbuf;
  tmpbuf = (char *)malloc(sizeof(Lbl2.Block_Length)+1);
  strncpy(tmpbuf,Lbl2.Block_Length,sizeof(Lbl2.Block_Length));
  sscanf(tmpbuf,"%d",&block_length);
  free(tmpbuf);
  }
/*
   tapes have been known to have blocks longer than the length specified
   in the label. bump this value up a bit.
*/
  block_length+=4;
  orig_block_length = block_length;

  buffer = (char *) malloc(block_length);
  if (buffer == NULL) {
    fprintf(prtfile,"%s: unable to allocate %d byte buffer\n",prgname,
		block_length);
    fprintf(stderr,"%s: FATAL ERROR\n",prgname);
    exit(1);
    }

  C_ARGSTR("-O",otap," "," ",&argc,argv);

  if ( Lbl2.Record_Format == 'V' ) {
  if (strcmp(otap," ") == 0)
    luout = 1;
  else
    C_LBOPEN(&luout,otap,"w");

  block_knt = 0;

  do {
    bs = read(fd,buffer,orig_block_length);
    if ( bs < 0) {
      fprintf(prtfile,"%s: EOF encountered\n",prgname);
	perror("read");
      }
    else if ( bs == 0) {
      EOFknt++;
      if (block_knt == 0) {
	if (debug != 0) {
          fprintf(prtfile,"%s: found 0 byte block looking for line header:",
			prgname);
          fprintf(prtfile,"    expected block length of %d bytes\n",
				orig_block_length);
	  }
        bs = read(fd,buffer,orig_block_length);
	if (debug != 0) {
	  fprintf(prtfile,"%s: second try at line header yielded %d bytes\n",
		prgname,bs);
	  }
        if (bs < 0) perror(prgname);
	}
      else {
	fprintf(prtfile,"%s: 0 length block encountered; exiting\n",prgname);
	C_LBCLOS(luout);
	exit(0);
	}
      }
    else {
      if (debug != 0)
        fprintf(prtfile,"%s: data block is %d bytes\n",prgname,bs);
      }

    if (bs > 0) {
      EOFknt = 0;
      bytes = 0;
      dataptr = buffer;
      memcpy((char *)&block_length+2,dataptr,2);
      memcpy((char *)&block_length,dataptr+=2,2);
      if (debug != 0)
        fprintf(prtfile,"block length has been set to %d bytes\n",block_length);
      dataptr += 2;

      do {
/*
    fprintf(prtfile,"buffer = %08x, dataptr = %08x ",buffer, dataptr);
    fprintf(prtfile,"end of buffer = %08x\n",buffer+block_length-1);
*/
	memcpy((char *)&bytes+2,dataptr,2);
	memcpy((char *)&bytes,dataptr+=2,2);

	if (bytes == 0) {
	  if (verbose != 0)
	  fprintf(prtfile,"%s: 0 length green word encountered; exit\n",prgname);
	  C_LBCLOS(luout);
	  exit(0);
	  }

	dataptr += 2;

	if (debug != 0) {
	  fprintf(prtfile,"%s: green word = %d bytes: ",prgname,bytes);
	  fflush(prtfile);

	  if (block_knt == 0) {
	    fprintf(prtfile,"%d recs %d traces %d samples\n",
		((usp_line_header *)dataptr)->NumRec,
		((usp_line_header *)dataptr)->NumTrc,
		((usp_line_header *)dataptr)->NumSmp);
	    }
	  else {
	    fprintf(prtfile,"\n");
/*
        fprintf(prtfile,"rec %d trc %d\n",((usp_trace_header *)dataptr)->RecNum,
		((usp_trace_header *)dataptr)->TrcNum);
*/
	    }
	  }

	block_knt++;
	C_WRTAPE(luout,dataptr,bytes-4);
	dataptr+=bytes-4;
	} while (dataptr < buffer+block_length);
      }
    else {
	fprintf(prtfile,"hit EOF\n");	
	EOFknt++;
	bs = 0;
	}
    if (EOFknt > 1) {
	fprintf(prtfile,"subsequent EOFs; quitting\n");
	bs = -1;
	}
      } while (bs >= 0);
    C_LBCLOS(luout);
    }
  else if ( Lbl2.Record_Format == 'U' ) {
    if (strcmp(otap," ") != 0) {
      outfile = fopen(otap,"w");
      if (outfile == NULL) {
	fprintf(stderr,"%s: Error opening %s - exiting\n",prgname,otap);
	exit(1);
	}
fprintf(stderr,"opened %s for output\n",otap); fflush(stderr);
      }
    else {
      outfile = stdout;
fprintf(stderr,"opened stdout for output\n"); fflush(stderr);
      }

    do {
/* fprintf(stderr,"reading a block\n"); fflush(stderr); */
      bs = read(fd,buffer,orig_block_length);
      if (bs > 0) {
        write(fileno(outfile),buffer,bs);
fprintf(stderr,"writing %d bytes to output file \n",bs); fflush(stderr);
	}
      } while (bs >= 0);
    }

  if (verbose != 0)
    fprintf(prtfile,"%s completed normally\n",prgname);
  exit(0);
}

void prt_standard_label(Vol_Lbl)
IBM_Std_Vol_Label *Vol_Lbl;
{
  void prtline();
  fprintf(prtfile,"\nIBM Standard Volume Label:\n");
  prtline("Label Identifier",sizeof(Vol_Lbl->Label_Identifier),
	Vol_Lbl->Label_Identifier);
  prtline("Label_Number",1,Vol_Lbl->Label_Number);
  prtline("Volume_Serial_Number",sizeof(Vol_Lbl->Volume_Serial_Number),
	Vol_Lbl->Volume_Serial_Number);
  prtline("VTOC_Pointer",sizeof(Vol_Lbl->VTOC_Pointer),Vol_Lbl->VTOC_Pointer);
  prtline("Owner",sizeof(Vol_Lbl->Owner),Vol_Lbl->Owner);
}

void prt_label_1(Lbl1)
IBM_Label_1 *Lbl1;
{
  void prtline();
  fprintf(prtfile,"\nIBM Standard Data Set Label 1:\n");
  prtline("Label_Identifier",sizeof(Lbl1->Label_Identifier),
	Lbl1->Label_Identifier);
  prtline("Label_Number",1,Lbl1->Label_Number);
  prtline("Data_Set_Identifier",sizeof(Lbl1->Data_Set_Identifier),
	Lbl1->Data_Set_Identifier);
  prtline("Data_Set_Serial_Number",sizeof(Lbl1->Data_Set_Serial_Number),
	Lbl1->Data_Set_Serial_Number);
  prtline("Volume_Sequence_Number",sizeof(Lbl1->Volume_Sequence_Number),
	Lbl1->Volume_Sequence_Number);
  prtline("Data_Set_Sequence_Number",sizeof(Lbl1->Data_Set_Sequence_Number),
	Lbl1->Data_Set_Sequence_Number);
  prtline("Generation_Number",sizeof(Lbl1->Generation_Number),
	Lbl1->Generation_Number);
  prtline("Version_Number",sizeof(Lbl1->Version_Number),Lbl1->Version_Number);
  prtline("Creation_Date",sizeof(Lbl1->Creation_Date),Lbl1->Creation_Date);
  prtline("Expiration_Date",sizeof(Lbl1->Expiration_Date),
	Lbl1->Expiration_Date);
  prtline("Data_Set_Security",sizeof(Lbl1->Data_Set_Security),
	Lbl1->Data_Set_Security);
  prtline("	Block_Count",sizeof(Lbl1->Block_Count),Lbl1->Block_Count);
  prtline("	System_Code",sizeof(Lbl1->System_Code),Lbl1->System_Code);
}

void prt_label_2(Lbl2)
IBM_Label_2 *Lbl2;
{
  void prtline();
  fprintf(prtfile,"\nIBM Standard Data Set Label 2:\n");
  prtline("Label_Identifier", sizeof(Lbl2->Label_Identifier),
	Lbl2->Label_Identifier);
  prtline("Label_Number", sizeof(Lbl2->Label_Number),Lbl2->Label_Number);
  prtline("Record_Format", sizeof(Lbl2->Record_Format),Lbl2->Record_Format);
  prtline("Block_Length", sizeof(Lbl2->Block_Length),Lbl2->Block_Length);
  prtline("Record_Length", sizeof(Lbl2->Record_Length),Lbl2->Record_Length);
  prtline("Tape_Density", sizeof(Lbl2->Tape_Density),Lbl2->Tape_Density);
  prtline("Data_Set_Position", sizeof(Lbl2->Data_Set_Position),
	Lbl2->Data_Set_Position);
  prtline("Job_Identification", sizeof(Lbl2->Job_Identification),
	Lbl2->Job_Identification);
  prtline("Tape_Recording_Technique", sizeof(Lbl2->Tape_Recording_Technique),
	Lbl2->Tape_Recording_Technique);
  prtline("Control_Character", sizeof(Lbl2->Control_Character),
	Lbl2->Control_Character);
  prtline("Block_Attribute", sizeof(Lbl2->Block_Attribute),
	Lbl2->Block_Attribute);
  prtline("Checkpoint_Data_Set_Identifier",
	sizeof(Lbl2->Checkpoint_Data_Set_Identifier),
	Lbl2->Checkpoint_Data_Set_Identifier);
  fprintf(prtfile,"\n");
}

void prtline(comment,length,address)
char *comment;
int length;
char *address;
{
	int i;
	char *chrptr = address;
	fprintf(prtfile,"  %30s - ",comment);
	if (length > 1) {
	  for (i=0; i<length; i++, chrptr++)
	    fprintf(prtfile,"%c",*chrptr);
	  }
	else
	    fprintf(prtfile,"%c",(char)chrptr);
	fprintf(prtfile,"\n");
}
