C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c reads in an x and a y dataset and outputs
c polar transformation datasets of radius and angle.
c angles are calculated assuming positive x is east and positive y is north.
c zero degrees is north

c declare variables
 
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      integer     lhedx(SZLNHD), lhedy(SZLNHD) 
      integer     nsamp, nsi, ntrc, nrec, iform, obytes
      integer     luinx ,luiny,  luoutr, luoutt, lbytes, nbytes, lbyout
      integer     irs,ire,ns,ne,argis,pipei(2),pipeo(2)
 
      real X( SZLNHD ), Y( SZLNHD ), radius ( SZLNHD ), angle( SZLNHD ) 
      real rad2deg, deg2rad, MaxAngle, MinAngle, AngleNullValue

      character   xtap*100, ytap*100, rtap*100, atap*100, name*7

      logical     verbos, reverse,query,DeadX,IKP
 
      data lbytes / 0 /, nbytes / 0 /, name/'REC2POL'/
      data pipei/0,3/,pipeo/1,4/
      rad2deg = 57.29578 
      deg2rad = 0.017453293
      DeadX = .false.
      IKP = .false.
 
      query = ( argis ( '-?' ) .gt. 0 .or. argis ( '-h' ) .gt. 0   )
      if ( query )then
            call help()
            stop
      endif
 
#include <f77/open.h>
 
      call cmdln(xtap,ytap,rtap,atap,ns,ne,irs,ire,MaxAngle,MinAngle,
     :     AngleNullValue,reverse,IKP,verbos)

c assign logical units [watch for ikp execution]

      if (IKP) then
         call sisfdfit(luinx,pipei(1))
         call sisfdfit(luiny,pipei(2))
         call sisfdfit(luoutr,pipeo(1))
         call sisfdfit(luoutt,pipeo(2))
      else
         call getln(luinx , xtap,'r', 0)
         call getln(luiny , ytap,'r', 0)
         call getln(luoutr, rtap,'w', 1)
         call getln(luoutt, atap,'w', 1)
      endif

c open -N1 dataset

      call rtape  ( luinx, lhedx, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'REC2POL: no header read from ',xtap
         write(LOT,*)'FATAL'
         stop
      endif
 
      call saver(lhedx, 'NumSmp', nsamp, LINHED)
      call saver(lhedx, 'SmpInt', nsi  , LINHED)
      call saver(lhedx, 'NumTrc', ntrc , LINHED)
      call saver(lhedx, 'NumRec', nrec , LINHED)
      call saver(lhedx, 'Format', iform, LINHED)
 
      call hlhprt (lhedx, lbytes, name, 7, LERR)
 
c modify line header to reflect actual number of traces output

      if(ire.lt.1)ire = nrec
      if(ne.lt.1)ne = ntrc
      nrecc = ire - irs + 1
      call savew(lhedx, 'NumRec', nrecc, LINHED)
      jtr   = ne - ns + 1
      call savew(lhedx, 'NumTrc', jtr  , LINHED)
 
c number output bytes

      obytes = SZTRHD + nsamp * SZSMPD
      call savhlh(lhedx,lbytes,lbyout)

c write line header to output [-O1 and -O2] datasets

      call wrtape ( luoutr, lhedx, lbyout  )
      call wrtape ( luoutt, lhedx, lbyout  )

c open -N2 dataset

      call rtape  ( luiny, lhedy, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'REC2POL: no line header read from ',ytap
         write(LOT,*)'FATAL'
         stop
      endif

c echo key parameters
 
      call verbal(nsamp, nsi, ntrc, nrec, iform,irs,ire,ns,ne,
     1     xtap,ytap,rtap,atap,MaxAngle,MinAngle,AngleNullValue,
     2     IKP,reverse)
 
c skip unwanted records

      call recskp(1,irs-1,luinx,ntrc,itr)
      call recskp(1,irs-1,luiny,ntrc,itr)
 
c process desired trace records [RECORD LOOP]

      do 100 jj = irs, ire
 
c skip to start trace [TRACE LOOP]

         call trcskp(jj,1,ns-1,luinx,ntrc,itr)
         call trcskp(jj,1,ns-1,luiny,ntrc,itr)
 
         do 1000  kk = ns, ne
 
c read -N1 trace

            nbytes = 0
            call rtape( luinx, lhedx, nbytes)

            if(nbytes .eq. 0) then
               write(LERR,*)'End of file on input:', xtap
               write(LERR,*)'  rec= ',jj,'  trace= ',kk
               go to 999
            endif

c assign as X or radius as requested by user

            if(.not.reverse)then
               call vmov (lhedx(ITHWP1), 1, X, 1, nsamp)
            else
               call vmov (lhedx(ITHWP1), 1, Radius, 1, nsamp)
            endif

c handle dead traces

            call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,
     :           TRACEHEADER)
            call saver2(lhedx,ifmt_StaCor,l_StaCor, ln_StaCor,
     :           stacor , TRACEHEADER)
            
            if (stacor .eq. 30000) DeadX = .true.
            
c     read -N2 trace
            
            nbytes = 0
            call rtape( luiny, lhedy, nbytes)
            
            if(nbytes .eq. 0) then
               write(LERR,*)'End of file on input:', ytap
               write(LERR,*)'  rec= ',jj,'  trace= ',kk
               go to 999
            endif

c assign as Y or angle as requested by user

            if(.not.reverse)then
               call vmov (lhedy(ITHWP1), 1, Y, 1, nsamp)
            else
               call vmov (lhedy(ITHWP1), 1, angle, 1, nsamp)
            endif

c handle dead traces

            call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,
     :           TRACEHEADER)
            call saver2(lhedy,ifmt_StaCor,l_StaCor, ln_StaCor,
     :           stacor , TRACEHEADER)

            if (stacor .eq. 30000 .or. DeadX) then
               if(.not.reverse)then
                  call vclr (radius,1,nsamp)
                  call vclr (angle,1,nsamp)
                  call vmov(radius,1,lhedx(ITHWP1),1,nsamp)
                  call vmov(angle,1,lhedy(ITHWP1),1,nsamp)
                  call wrtape(luoutr,lhedx,obytes)
                  call wrtape(luoutt,lhedy,obytes)
                  goto 1000
               else
                  call vclr (X,1,nsamp)
                  call vclr (Y,1,nsamp)
                  call vmov(X,1,lhedx(ITHWP1),1,nsamp)
                  call vmov(Y,1,lhedy(ITHWP1),1,nsamp)
                  call wrtape(luoutr,lhedx,obytes)
                  call wrtape(luoutt,lhedy,obytes)
                  goto 1000
               endif
            endif

c [SAMPLE LOOP]

            do 2000 ll = 1,nsamp

               if(.not.reverse)then

c RECTANGULAR -> POLAR 

c quadrant one

                  IF(x(ll) .ge. 0. .and. y(ll) .ge. 0.)then

                     radius(ll) = sqrt(x(ll)**2 + y(ll)**2)
                     if(abs(y(ll)).lt.1.e-31)then
                        angle(ll) = 0.0
                     else
                        angle(ll) = atan(x(ll)/y(ll))*rad2deg
                     endif

c quadrant two

                  ELSEIF(x(ll) .gt. 0. .and. y(ll) .lt. 0.)then
                     radius(ll) = sqrt(x(ll)**2 + y(ll)**2)
                     angle(ll) = 90. + atan(abs(y(ll))/x(ll))*rad2deg
c quadrant three

                  ELSEIF(x(ll) .lt. 0. .and. y(ll) .lt. 0.)then
                     radius(ll) = sqrt(x(ll)**2 + y(ll)**2)
                     angle(ll)=180.+atan(abs(x(ll))/abs(y(ll)))*rad2deg
c quadrant four
                     
                  ELSEIF(x(ll) .lt. 0. .and. y(ll) .gt. 0.)then
                     radius(ll) = sqrt(x(ll)**2 + y(ll)**2)
                     angle(ll) = 270. + atan(y(ll)/abs(x(ll)))*rad2deg

c on an axis

                  ELSEIF(x(ll) .lt. 1.e-31)then
                     radius(ll) =  y(ll)
                     if(y(ll).gt.0.)then
                        angle(ll) = 0.
                     else
                        angle(ll) = 180.
                     endif

                  ELSEIF(y(ll) .lt. 1.e-31)then
                     radius(ll) =  x(ll)
                     if(x(ll).gt.0.)then
                        angle(ll) = 90.
                     else
                        angle(ll) = 270.
                     endif

                  ENDIF

c Output data within limits only, angular null value outside limits

                  if(angle(ll).gt.MaxAngle .or. 
     :                 angle(ll).lt.MinAngle)angle(ll)=AngleNullValue

               else

c POLAR -> RECTANGULAR within limits

                  if(angle(ll).gt.MaxAngle .or. angle(ll).lt.MinAngle)
     :                 then 
                     X(ll) = 0.0
                     Y(ll) = 0.0
                  else
                     X(ll) = radius(ll) * cos(angle(ll)*deg2rad)
                     Y(ll) = radius(ll) * sin(angle(ll)*deg2rad)
                  endif

               endif

 2000       continue
 
            if(.not.reverse)then
               call vmov(radius,1,lhedx(ITHWP1),1,nsamp)
               call vmov(angle,1,lhedy(ITHWP1),1,nsamp)
            else
               call vmov(X,1,lhedx(ITHWP1),1,nsamp)
               call vmov(Y,1,lhedy(ITHWP1),1,nsamp)
            endif

            call wrtape(luoutr,lhedx,obytes)
            call wrtape(luoutt,lhedy,obytes)
 
 1000    continue
 
c skip to end of record

         call trcskp(jj,ne+1,ntrc,luin,ntrc,itr)
 
 100  continue
 
 999  continue
 
      call lbclos ( luinx )
      call lbclos ( luiny )
      call lbclos ( luoutr )
      call lbclos ( luoutt )
 
      write(LERR,*)'REC2POL, processed',nrec,' record(s)',
     :     ' with ',ntrc, ' traces'
      write(LER,*)'REC2POL: Normal Termination'
      stop      
      end
