C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine verbal(nsamp, nsi, ntrc, nrec, iform,irs,ire,ns,ne,
     1     xtap,ytap,rtap,atap,MaxAngle,MinAngle,AngleNullValue,
     2     IKP,reverse)

c verbose output of processing parameters

#include <f77/iounit.h>
 
      integer     nsamp, nsi, ntrc, nrec, iform
      integer     irs,ire,ns,ne
      real        MaxAngle,MinAngle,AngleNullValue
      character   xtap*(*), ytap*(*),rtap*(*), atap*(*)
      logical     reverse,IKP
 
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace =  ', nsamp
            write(LERR,*) ' sample interval    =  ', nsi
            write(LERR,*) ' traces per record  =  ', ntrc
            write(LERR,*) ' records per line   =  ', nrec
            write(LERR,*) ' format of data     =  ', iform
            write(LERR,*) ' start record       =  ', irs
            write(LERR,*) ' end record         =  ', irs
            write(LERR,*) ' start trace        =  ', ns
            write(LERR,*) ' end trace          =  ', ne

            if(.not.reverse)then

               write(LERR,*) 'Rectangular to Polar conversion'
               write(LERR,*) 'input X coordinate data set name =  ',xtap
               write(LERR,*) 'input Y coordinate data set name =  ',ytap  
               write(LERR,*) 'output radius data set name =  ',rtap
               write(LERR,*) 'output angle data set name = ',atap

            else

               write(LERR,*) 'Polar to Rectangular conversion'
               write(LERR,*) 'input radius data set name =  ',xtap
               write(LERR,*) 'input angle data set name = ',ytap
               write(LERR,*) 'output X coordinate data set name =  ',rtap
               write(LERR,*) 'output Y coordinate data set name =  ',atap 

            endif 

            write(LERR,*) ' Minimum output angle = ',MinAngle,' degrees'
            write(LERR,*) ' Maximum output angle = ',MaxAngle,' degrees'
            write(LERR,*) ' Angular output Null Value = ',AngleNullValue
     :,' degrees'
            write(LERR,*)' '
            if(IKP)write(LERR,*)' Running inside IKP'
            write(LERR,*)' '

      return
      end
 
