C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine PickCount ( lupick, NumEntries, NumSegs, RecUnits, 
     :     TrcUnits, SmpUnits, RecOffset, TrcOffset, SmpOffset, 
     :     FormatIn )

#include <f77/iounit.h>

      integer nrec, ntrc, nsamp, lupick, NumSegs, NumEntries

      real RecUnits, TrcUnits, SmpUnits, RecOffset, TrcOffset, SmpOffset
      real value

      character FormatIn*20, key*10, card * 80

c read pick file header information to determine memory acquisition requirements
c in main 
 
      IF ( FormatIn .eq. 'xsd' ) then

c read pick file header assuming new XSD format.

         read ( lupick, '(a80)', err = 900 , end = 901 ) card
         if (card(1:5) .ne. 'Units') then
            write(LERR,*)'Pickfile not xsd format -- FATAL'
            call ccexit (666)
         endif
         rewind (lupick)

         read ( lupick, 10, err = 900 , end = 901 ) RecUnits, 
     :        TrcUnits, SmpUnits, nrec, ntrc, nsamp, 
     :        RecOffset, TrcOffset, SmpOffset, Numsegs, 
     :        NumEntries
 10      format ( 6x, f12.6, 1x, f12.6, 1x, f12.6, 1x, i5, 1x, i5, 1x, 
     :        i5, 7x, f12.6, 1x, f12.6, 1x, f12.6, 8x, i5, 1x, i5 )
         return
       
      ELSEIF ( FormatIn .eq. 'xsdheader' ) then

         read ( lupick, '(a80)', err = 900 , end = 901 ) card
         if (card(1:6) .ne. 'No_Seg') then
            write(LERR,*)'Pickfile not xsd header format -- FATAL'
            call ccexit (666)
         endif
         rewind (lupick)

c read file header

         do while ( 1 .eq. 1 )

            read ( lupick, '(a10,1x,f17.6)', err=900, end=901 ) 
     :           key, value

            if (key.EQ.'No_Seg') NumSegs = nint(value)
            if (key.EQ.'Max_Pick') NumEntries = nint(value)
            if (key.EQ.'UnitRec') RecUnits = value
            if (key.EQ.'UnitTrc') TrcUnits = value
            if (key.EQ.'UnitSmp') SmpUnits = value
            if (key.EQ.'OffsetRec') RecOffset = value
            if (key.EQ.'OffsetTrc') TrcOffset = value
            if (key.EQ.'OffsetSmp') SmpOffset = value
            if (key.EQ.'NumRec') nrec = nint(value)
            if (key.EQ.'NumTrc') ntrc = nint(value)
            if (key.EQ.'NumSmp') nsamp = nint(value)
            if (key.EQ.'NumSmp') return
         enddo

      ELSEIF ( FormatIn .eq. 'flat') then

           rewind (lupick)
           NumEntries = 0
           do while ( 1 .eq. 1 )

            read ( lupick, '(a80)', err=900, end=801 ) card
            NumEntries = NumEntries + 1
           enddo
801        continue
           if (NumEntries .eq. 0) go to 901
           return

      ENDIF

c error messages

 900  continue
      write(LERR,*)'RECSHIFT: error reading velocity file'
      write(LERR,*)'FATAL'
      write(LER,*)' '
      write(LER,*)'RECSHIFT: error reading velocity file'
      write(LER,*)'FATAL'
      write(LER,*)' '
      stop

 901  continue
      write(LERR,*)' RECSHIFT: empty input velocity file'
      write(LERR,*)' FATAL '
      write(LER,*)' '
      write(LER,*)' RECSHIFT: empty input velocity file'
      write(LER,*)' FATAL '
      write(LER,*)' '
      stop

      end
