C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine Xsd_ReadHeaderPicks ( luin, Record, Trace, Time,
     :     N, NumEntries, SegNum, mnemonic, SmpUnits, SmpOffset )

c routine to requested segment from read xsd header value at pick file to 
c retrieve times.  Assumption made is that user has detected same
c index header mnemonic as supplied to recshift routine.

#include <f77/iounit.h>

c variables passed from calling routine

      integer luin, NumEntries, N, SegNum

      real Record(NumEntries), Trace(NumEntries), Time(NumEntries)
      real SmpUnits, SmpOffset

      character Xsd_SegName*20, mnemonic*6, tmp * 80

c local variables 
      
      integer count, last

      real value

      character key*10

      logical ThisIsIt

c initialize variables

      ThisIsIt = .false.
      N = 0
      last = 0
      count = 0

c load picks
      rewind (luin)

      DO while(1.eq.1)
            
         read( luin,'(a10,1x,f17.6)', err=900, end=901 ) key, value

         if ( key(1:5) .eq. 'Segme' ) then
            if ( nint(value) .eq. SegNum ) ThisIsIt = .true.
            read ( luin, '(a10,1x,a20)', err=900, end=901 ) 
     :           key, Xsd_SegName
c           read( luin,'(a80)', err=900, end=901 ) tmp
c           call trimc (tmp, 80)
c           key(1:5) = tmp(1:5)
         endif

           if ( key(1:5) .EQ. 'Picks' .and. ThisIsIt ) then
              N = nint(value)
           endif

c get sample value of pick

           if ( key(1:5) .EQ. 'Sampl' .and. ThisIsIt ) then
              Time(count) = value * SmpUnits + SmpOffset
           endif

c get trace value of pick

           if ( key(1:5) .EQ. 'Trace' .and. ThisIsIt ) then
              Trace(count) = value
           endif

c get record value of pick

           if ( mnemonic .eq. ' ' ) then
              if ( key(1:5) .eq. 'Recor' .and. ThisIsIt ) then
                 Record(count) = value
              endif
           else
              if ( key(1:5) .EQ. mnemonic(1:5)  .and. ThisIsIt ) then
                 Record(count) = value
              endif
           endif

c Increment pick counter

           if ( key(1:4) .EQ. 'Pick' .and. ThisIsIt ) then
              count = count+1
              if ( count .eq. N ) then

                 do while ( 1 .eq. 1 )

c                   read( luin,'(a10,1x,f17.6)', err=900, end=901 ) 
c    :                   key, value
                    read( luin,'(a80)', err=900, end=901 ) tmp
                    call trimc (tmp, 80)
                    call fsscnf ( tmp, '%s %f', key(1:5), value)

c get sample value of pick

                    if ( key(1:5) .EQ. 'Sampl' ) then
                       Time(count) = value * SmpUnits + SmpOffset
                       last = last + 1
                    endif
c get record value of pick

                    if ( key(1:5) .EQ. 'Trace' ) then
                       Trace(count) = value
                       last = last + 1
                    endif

c get Tracevalue of pick

                    if ( mnemonic(1:1) .eq. ' ' ) then
                       if ( key(1:5) .eq. 'Recor') then
                          Record(count) = value
                          last = last + 1
                       endif
                    else
                       if ( key(1:5) .EQ. mnemonic(1:5) ) then
                          Record(count) = value
                          last = last + 1
                       endif
                    endif

c if last pick is completely read return and leave file pointer
c at next Segment card

                    if ( last .eq. 3 ) then
                       write(LERR,*)' '
                       write(LERR,*)' Data Read From Pickfile '
                       write(LERR,*)' '
                       write(LERR,*)' Record      Trace      Time '
                       write(LERR,*)' '
                       
                       do i = 1, N
                          write(LERR,*) Record(i), Trace(i), Time(i)
                       enddo
                       write(LERR,*)' '
                       call hsort3 ( N, Record, Trace, Time )
                       return
                    endif                       
                       
                 enddo
              endif
           endif
      ENDDO

 900  continue
      write(LERR,*)' '
      write(LERR,*)' RECSHIFT: Error reading input Pickfile'
      write(LERR,*)' FATAL'
      write(LERR,*)' '
      write(LER,*)' '
      write(LER,*)' RECSHIFT: Error reading input Pickfile'
      write(LER,*)' FATAL'
      write(LER,*)' '
      stop

 901  continue
      write(LERR,*)' '
      write(LERR,*)' RECSHIFT: Premature EOF reading input Pickfile'
      write(LERR,*)' FATAL'
      write(LERR,*)' '
      write(LER,*)' '
      write(LER,*)' RECSHIFT: Premature EOF reading input Pickfile'
      write(LER,*)' FATAL'
      write(LER,*)' '
      stop

      end




