C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine SailShift ( isail, irec, li, di, timer, nf,
     1                       record, time, shift, N, datum,
     2                       isaillast, gotsail)

#include <f77/iounit.h>
      
      integer  li(nf), di(nf)
      real     timer(nf)
      integer isail, irec, N, ishift, datum, isaillast

      real Record(N), Time(N), fac, shift
      logical gotsail

      IF (.not. gotsail) THEN

         num = 0
         do  j = 1, nf
             if (isail .eq. li(j)) then
                 num = num + 1
                 record(num) = di(j)
                 time  (num) = timer(j)
             endif
         enddo    

         write(LERR,*)''
         write(LERR,*)'Sail Line ',isail
         write(LERR,*)'Previous Sail Line (if any) ',isaillast
         write(LERR,*)'Control record numbers'
         write(LERR,100)(record(ii),ii=1,num)
         write(LERR,*)'Control times'
         write(LERR,110)(time(ii),ii=1,num)
         write(LERR,*)''
100      format(8(f7.0,3x))
110      format(8f8.3)

         N = num
         gotsail = .true.
         isaillast = isail
      ENDIF


         IF ( irec .lt. nint(Record(1)) ) then
            shift = Time(1)
            return
         ELSEIF ( irec .gt. nint(Record(N)) ) then
            shift = Time(N)
            return
         ELSEIF ( irec .eq. nint(Record(1)) ) then
            shift = Time(1)
            if ( datum .ne. 0 ) shift = datum - shift
            return
         ELSEIF ( irec .eq. nint(Record(N)) ) then
            shift = Time(N)
            if ( datum .ne. 0 ) shift = datum - shift
            return
         ELSE
            do i = 2, N
               if ( irec .lt. nint(Record(i)) ) then
                  fac = ( float(irec) - Record(i-1) ) / 
     :                 ( Record(i) - Record(i-1) )
                  shift = (Time(i-1) + fac * 
     :                 ( Time(i) - Time(i-1) ))
                  if ( datum .ne. 0 ) shift = datum - shift
                  return
               endif
            enddo
         
         ENDIF

      end
