C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine verbal ( nsamp, nsi, ntrc, nrec, iform, iseg, N, 
     :     Record, Time, ntap, otap, ptap, SmpUnitOverride, it0, stawrd,
     :     recwrd, FormatIn, limin, limax, dimin, dimax, D3,
     :     sail, linwrd, flt, li, di, timer, verbos, recrd)

#include <f77/iounit.h>

      integer     nsamp, nsi, ntrc, nrec, N, iseg, iform, it0
      integer     limin, limax, dimin, dimax

      real        Record(*),Time(*), SmpUnitOverride, timer(*)
      integer     li(*), di(*)

      character   ntap*(*), otap*(*), ptap*(*), stawrd*6, recwrd*6
      character   FormatIn*20, linwrd*6
      logical     D3, sail, flt, verbos, recrd
 
      write(LERR,*)' '
      write(LERR,*)' line header values after default check '
      write(LERR,*) ' # of samples/trace =  ', nsamp
      write(LERR,*) ' sample interval    =  ', nsi
      write(LERR,*) ' traces per record  =  ', ntrc
      write(LERR,*) ' records per line   =  ', nrec
      write(LERR,*) ' format of data     =  ', iform
      write(LERR,*) ' input data set name =  ', ntap
      write(LERR,*) ' output data set name=  ', otap

      IF (recrd) THEN

      write(LERR,*) ' Shifts will be extracted from traces,'
      write(LERR,*) ' averaged and the average put into ',stawrd

      ELSE

      IF (D3) THEN

      write(LERR,*) '3D data assumed'
      write(LERR,*) ' Min LI =  ',limin
      write(LERR,*) ' Max LI =  ',limax
      write(LERR,*) ' Min DI =  ',dimin
      write(LERR,*) ' Max DI =  ',dimax

      ELSEIF (sail) THEN

      write(LERR,*) 'Sail line option:'
      write(LERR,*) 'Sail line ID word   = ',linwrd
      write(LERR,*) 'Control record word = ',recwrd
      if (verbos) then
          write(LERR,*)''
          write(LERR,*)'Entry   Sail   Rec   Time'
          do  j = 1, nf
              write (LERR, *) j,li(j), di(j), timer(j)
          enddo
          write(LERR,*)''
      endif


      ELSE

      if (ptap .ne. ' ')  then
         if ( FormatIn .eq. 'xsd' ) then
            write(LERR,*) ' Xsd pickfile used'
         elseif ( FormatIn .eq. 'xsdheader' ) then
            write(LERR,*) 
     :' Xsd header value at pick location file used'
         endif
         write(LERR,*) ' Pick file name      =  ', ptap
         write(LERR,*) ' Pick segment to use =  ', iseg
         write(LERR,*) ' Sample override     =  ', SmpUnitOverride
      endif
      if ( recwrd .ne. ' ') then
         write(LERR,*)' Input index is: ',recwrd
      else
         write(LERR,*)' Input index is sequential record number'
      endif
      write(LERR,*)' '
      write(LERR,*)'Control points'
      do  j = 1, N
          write(LERR,*)'Record  ',Record(j),'   Time  ',Time(j)
      enddo
      write(LERR,*)' '

      ENDIF

      ENDIF

      write(LERR,*)' Shift stored in trace header entry: ',stawrd
      if (flt) then
      write(LERR,*)' Shift word is for floating point numbers'
      else
      write(LERR,*)' Shift word is for integer numbers'
      endif
      write(LERR,*) ' Datum time          =  ', it0
      write(LERR,*)' '
            
      return
      end
