C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c -----------------  Main Routine -----------------------
c

c     Program Changes:

c      - original written: December 15, 1994

c     Program Description:

c      - template for trace processing in USP.  This is a very basic version
c     and contains only the bare minimum of functionality.  For a complete
c     picture see ~usp/src/cmd/prgm.F

c get machine dependent parameters 

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h> 

c dimension standard USP variables 

      integer     itr ( SZLNHD )
     
      integer     nsamp, nsi, ntrc, ntrco, nrec, nreco, iform
      integer     luin , luout, lbytes, nbytes, lbyout, obytes
      integer     obytes2
      integer     ist, iend, irs, ire, ns, ne, argis
      integer     start, end

      real        tri ( SZLNHD )
      real        junk ( SZLNHD )
      real        data(2)
      real        z(2,2), a(2,2), est(2)
  

      character   ntap*255, otap*255, name*8, atap*255

      logical     verbos

c Program Specific _ dynamic memory variables

      integer TraceSize, errcd1, abort

      real    Trace_WorkSpace

      pointer (wkadr1, Trace_WorkSpace(200000))

c Program Specific _ static memory variables

      integer ifmt_RecNum,l_RecNum,ln_RecNum, RecNum
      integer ifmt_TrcNum,l_TrcNum,ln_TrcNum, TrcNum
      integer ifmt_DstSgn,l_DstSgn,ln_DstSgn, DstSgn
      integer ifmt_StaCor,l_StaCor,ln_StaCor, StaCor

c Initialize variables

      data abort/1/
      data name/"REDUCE"/

      
      data luat/-1/
c give command line help if requested

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif

c open printout file

#include <f77/open.h>

c get command line input parameters

      call cmdln ( ntap, otap, ns, ne, irs, ire, ist, iend, 
     :     name, verbos, atap, start, end )

c open input and output files

      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)
      if (atap(1:1) .ne. ' ' ) then
         call getln(luat, atap,'w', -1)
      endif

c  read input line header and save certain parameters

      call rtape(luin,itr,lbytes)
      if(lbytes.eq.0)then
         write(LER,*)'PRGM: no line header on input dataset',ntap
         write(LER,*)'FATAL'
         stop
      endif

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)

c define pointers to header words required by your routine

      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

c update historical line header and print to printout file 

      call hlhprt (itr, lbytes, name, 4, LERR)

c check user supplied boundary conditions and set defaults

      if ( irs .eq. 0 ) irs = 1
      if ( ire .eq. 0 .or. ire .gt. nrec ) ire = nrec

      if ( ns .eq. 0 ) ns = 1
      if ( ne .eq. 0 .or. ne .gt. ntrc ) ne = ntrc

      ist = nint ( float(ist) / float(nsi) )
      iend = nint ( float(iend) / float(nsi) )

      if ( ist .eq. 0 ) ist = 1
      if ( iend .eq. 0 .or. iend .gt. nsamp ) iend = nsamp

      start = nint ( float(start) / float(nsi) )
      end = nint ( float(end) / float(nsi) )

      if ( start .eq. 0 ) start = 1
      if ( end .eq. 0 .or. end .gt. nsamp ) end = nsamp

      nreco = ire - irs + 1
      ntrco = ne - ns + 1

c modify line header to reflect actual record configuration output
c NOTE: in this case the sample limits ist and iend are used to 
c       limit processing only.   All data samples are actually passed.

      call savew(itr, 'NumRec', nreco, LINHED)
      call savew(itr, 'NumTrc', ntrco  , LINHED)

c number output bytes

      obytes = SZTRHD + SZSMPD * nsamp 
      obytes2 = SZTRHD + SZSMPD * 2
c save out hlh and line header

      call savhlh  ( itr, lbytes, lbyout )
      call wrtape ( luout, itr, lbyout )
c
c
c     
      if (atap(1:1) .ne. ' ') then
         call savew(itr, 'NumSmp', 2 , LINHED)
         call savew(itr, 'NumRec', nreco, LINHED)
         call savew(itr, 'NumTrc', ntrco  , LINHED)
         call wrtape (luat, itr, lbyout )
      endif

c verbose output of all pertinent information before processing begins

      call verbal( ntap, otap, nsamp, nsi, ntrc, nrec, iform, ist, 
     :     iend, irs, ire, ns, ne, verbos, atap)

c dynamic memory allocation:  

      TraceSize = nsamp 
      call galloc (wkadr1, TraceSize * SZSMPD, errcd1, abort)
    
      if ( errcd1 .ne. 0 )then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) TraceSize * SZSMPD, '  bytes'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'Unable to allocate workspace:'
         write(LER,*) TraceSize * SZSMPD, '  bytes'
         write(LER,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) TraceSize * SZSMPD, '  bytes'
         write(LERR,*)' '
      endif

c initialize memory
         
      call vclr ( Trace_WorkSpace, 1, TraceSize )

c BEGIN PROCESSING 

c skip unwanted input records

      call recskp ( 1, irs-1, luin, ntrc, itr )

      DO JJ = irs, ire
 
c skip to start trace

         call trcskp ( JJ, 1, ns-1, luin, ntrc, itr )

         DO KK = ns, ne

            nbytes = 0
            call rtape( luin, itr, nbytes)

c if end of data encountered (nbytes=0) then bail out

            if(nbytes .eq. 0) then
               write(LERR,*)'Premature EOF on input at:'
               write(LERR,*)'  rec= ',JJ,'  trace= ',KK
               go to 999
            endif

c get required trace header information

            call saver2( itr, ifmt_RecNum, l_RecNum, ln_RecNum, 
     :           RecNum, TRACEHEADER )

            call saver2( itr, ifmt_TrcNum, l_TrcNum, ln_TrcNum, 
     :           TrcNum, TRACEHEADER )

            call saver2( itr, ifmt_DstSgn, l_DstSgn, ln_DstSgn, 
     :           DstSgn, TRACEHEADER )

            call saver2( itr, ifmt_StaCor, l_StaCor, ln_StaCor, 
     :           StaCor, TRACEHEADER )

c process only live traces

            if ( StaCor .ne. 30000) then

               call vmov ( itr(ITHWP1), 1, tri, 1, nsamp )
               
c================================================================= 
               a(1,1)=0.
               a(1,2)=0.
               a(2,1)=0.
               a(2,2)=0.
               z(1,1)=0.
               z(1,2)=0.
               z(2,1)=0.
               z(2,2)=0.
               data(1)= 0.
               data(2) = 0.
               est(1)=0.
               est(2)=0.
               
               do i =start,end
                 
                  a(1,2) = a(1,2) + i
                  a(2,2) = a(2,2) + i**2
               enddo
               a(1,1) = end - start +1
               a(2,1) = a(1,2)

          
               do i = start,end
                  data(1) = data(1) + tri(i)
                  data(2) = data(2) + i*tri(i)
                  
               enddo             
          
               call matinv(a,2,2,z)
               call rmmuls(z,2,data,2,est,2,2,1,2)
c              write(6,*)est(1),est(2)

               do i=ist,iend
                  temp = est(1) + est(2)*i
               junk(i)=tri(i)-temp
               enddo
                  
c=================================================================               
               do i = ist,iend
                  tri(i) = junk(i)
               enddo
               
               call vmov ( tri, 1, itr(ITHWP1), 1, nsamp )
               
            endif
c     write output data
            
            call wrtape (luout, itr, obytes)
            if (atap(1:1) .ne. ' ') then
               if (Stacor .eq. 30000) then
                  est(1)=0.
                  est(2)=0.
               endif
               
               call vmov ( est, 1, itr(ITHWP1), 1, 2 )
               
               call savew(itr, 'NumSmp', 2 , LINHED)
               
               
               call wrtape (luat, itr, obytes2)
            endif
         ENDDO
      
c     skip to end of record
         
         call trcskp ( JJ, ne+1, ntrc, luin, ntrc, itr )
         
      ENDDO

c close data files 
      
      call lbclos ( luin )
      call lbclos ( luout )
      if (atap(1:1) .ne. ' ') then
         call lbclos ( luat )
      endif
      write(LERR,*)'reduce: Normal Termination'
      write(LER,*)'reduce: Normal Termination'
      stop
      
 999  continue
      
      call lbclos ( luin )
      call lbclos ( luout )
      if (atap(1:1) .ne. ' ') then
         call lbclos ( luat )
      endif
      write(LERR,*)'reduce: ABNORMAL Termination'
      write(LER,*)'reduce: ABNORMAL Termination'
      stop
      end

c -----------------  Subroutine -----------------------

      subroutine help()

c provide terse online help [detailed help goes in man page]

#include <f77/iounit.h>

      write(LER,*)' '
      write(LER,*)'===================================================='
      write(LER,*)' '
      write(LER,*)' Command Line Arguments for REDUCE'
      write(LER,*)' Fits a line to each trace and removes that from'
      write(LER,*)' the data.'
      write(LER,*)' '
      write(LER,*)' For a more detailed description of these parameters'
      write(LER,*)' see the online man page using uman, xman or xuspman'
      write(LER,*)' '
      write(LER,*)'Input...................................... (def)'
      write(LER,*)' '
      write(LER,*)'-N[]   -- input data set                  (stdin)'
      write(LER,*)'-O[]   -- output data set                (stdout)'
      write(LER,*)'-M[]   -- optional output map of '
      write(LER,*)'                       intercept and slope (none)'
      write(LER,*)'-s[]   -- process start time (ms)             (1)'
      write(LER,*)'-e[]   -- process end time (ms)     (last sample)'
      write(LER,*)'-ns[]  -- start trace number                  (1)'
      write(LER,*)'-ne[]  -- end trace number           (last trace)'
      write(LER,*)'-rs[]  -- start record                        (1)'
      write(LER,*)'-re[]  -- end record                (last record)'
      write(LER,*)'-swin[] -- Start Model Window                 (1)'
      write(LER,*)'-ewin[] -- End Model Window         (last sample)'
      write(LER,*)'-V     -- verbos printout'
      write(LER,*)' '
      write(LER,*)'Usage:'
      write(LER,*)'       reduce -N[] -O[] -s[] -e[] -ns[] -ne[] -rs[]'
      write(LER,*)'            -re[] -V { -M[] -swin[] -ewin[] }'
      write(LER,*)' '
      write(LER,*)'===================================================='
      
      return
      end

c -----------------  Subroutine -----------------------

c pick up command line arguments 

      subroutine cmdln ( ntap, otap, ns, ne, irs, ire, ist, iend, 
     :     name, verbos,atap, start, end )

#include <f77/iounit.h>

      integer    ist, iend, ns, ne, irs, ire, argis
      integer    start, end

      character  ntap*(*), otap*(*), name*(*), atap*(*)

      logical    verbos
           call argi4 ( '-ewin', end, 0,0)
           call argi4 ( '-e', iend, 0, 0 )
           call argstr ( '-M', atap, ' ', ' ' )

           call argi4 ( '-ne', ne, 0, 0 )
           call argi4 ( '-ns', ns, 0, 0 )
           call argstr ( '-N', ntap, ' ', ' ' ) 

           call argstr ( '-O', otap, ' ', ' ' ) 

           call argi4 ( '-re', ire, 0, 0 )
           call argi4 ( '-rs', irs, 0, 0 )
           call argi4 ( '-swin', start, 1,1)
           call argi4 ( '-s', ist, 1, 1 )

           verbos = (argis('-V') .gt. 0)

c check for extraneous arguments and abort if found to
c catch all manner of user typo's

      call xtrarg ( name, ler, .FALSE., .FALSE. )
      call xtrarg ( name, lerr, .FALSE., .TRUE. )

           
      return
      end

c -----------------  Subroutine -----------------------

c verbal printout of pertinent program particulars


      subroutine verbal ( ntap, otap, nsamp, nsi, ntrc, nrec, iform, 
     :     ist, iend, irs, ire, ns, ne, verbos, atap)

#include <f77/iounit.h>

      integer    nsamp, ntrc, iform, ist, iend, irs, ire, ns, ne, nsi

      character  ntap*(*), otap*(*), atap*(*)

      logical    verbos

      write(LERR,*)' '
      write(LERR,*)' Input Line Header Parameters'
      write(LERR,*)' '
      write(LERR,*) ' input data set name   =  ', ntap
      write(LERR,*) ' samples per trace     =  ', nsamp
      write(LERR,*) ' traces per record     =  ', ntrc
      write(LERR,*) ' number of records     =  ', nrec
      write(LERR,*) ' data format           =  ', iform
      write(LERR,*) ' sample interval       =  ', nsi
      write(LERR,*)' '
      write(LERR,*)' '
      write(LERR,*)' Command Line Parameters '
      write(LERR,*)' '
      write(LERR,*) ' output data set name  =  ', otap
      if (atap(1:1) .ne. ' ') then
      write(LERR,*) ' output data map of intercept and slope
     :     =  ', atap
      endif
      write(LERR,*) ' start record          =  ', irs 
      write(LERR,*) ' end record            =  ', irs 
      write(LERR,*) ' start trace           =  ', ns
      write(LERR,*) ' end trace             =  ', ne
      write(LERR,*) ' processing sample start = ', ist
      write(LERR,*) ' processing sample end   = ', iend
      if ( verbos )  write(LERR,*) ' verbose printout requested'
      write(LERR,*)' '
      write(LERR,*)'========================================== '
      write(LERR,*)' '

      return
      end





