C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine FileInsert(tri, nsamp, new_vel, tri2, nsamp2,
     :              Index_Constraint,Pick_Constraint,
     :              Null_Constraint, value_constraint,value,
     :              hdrwd1,hdrwd2,hdrwd3,
     :              iword1,iword2,iword3,
     :              irs, ire, ns, ne, nsi,
     :              recnum, trcnum, nullval,
     :              Start_End_Constraint,ist,iend,
     :              hang,single)

      implicit none

c     Subroutine to perform a file replacement based on the 
c     given constraint conditions and outputs the 
c     the new time series as NEW_VEL.
c     
c     
c     James M. Gridley
c     USP Team
c     July 1996
      
c     variables passed from calling routine
      
      integer nsamp, irs, ire, ns, ne, ist, iend, nsi
      integer iword1, iword2, iword3, nullval
      integer recnum,trcnum,nsamp2

      real tri(nsamp),tri2(nsamp)
      real new_vel(nsamp)
      real value

      logical  Index_Constraint, Pick_Constraint
      logical  Null_Constraint, hang, single
      logical  Start_End_Constraint, value_constraint

      character   hdrwd1 * 6, hdrwd2 * 6, hdrwd3 * 6

c local variables

      integer i
c=============================================================================
c     process data
c=============================================================================
      
    
c=============================================================================
      
      if (Null_Constraint  .and. iword3 .eq. nullval) then
    
         do i = 1, nsamp
           
            new_vel(i) = tri2(i)
         enddo
         go to 999
      endif
c=============================================================================
         
      if(Pick_Constraint .and. Index_Constraint) then
      
         do i = 1,nsamp
            if(i .ge. iword1/nsi .and.
     :           i .le. iword2/nsi .and.
     :           recnum .ge. irs .and. recnum .le. ire .and.
     :           trcnum .ge. ns .and. trcnum .le. ne) then
               
               if (hang) then
                 
                  new_vel(i) = tri2(i-(iword1/nsi)+1)
               else
                  new_vel(i) = tri2(i)
               endif
            else
               new_vel(i) = tri(i)
            endif
         enddo
         go to 999
      endif

c=============================================================================

      if(Index_Constraint) then

         do i = 1, nsamp
            if(recnum .ge. irs .and. recnum .le. ire .and.
     :           trcnum .ge. ns .and. trcnum .le. ne .and.
     :           i .ge. ist .and. i .le. iend) then
               
               if(hang) then
                
                  new_vel(i) = tri2(i-(iword1/nsi)+1)
               else
                  
                  new_vel(i) = tri2(i)
               endif
            else
               new_vel(i) = tri(i)
            endif
            
         enddo
         go to 999
      endif
      
c=============================================================================

         if(Start_End_Constraint) then
           
            do i = 1, nsamp
               if (i .ge. ist .and. i .le. iend) then
                  
                  if (hang) then
                    
                     new_vel(i) = tri2(i-ist+1)
                  else
                     new_vel(i) = tri2(i)
                  endif
               else
                  new_vel(i) = tri(i)
               endif
            enddo
            goto 999
         endif
c=============================================================================         
         if(Pick_Constraint) then
   
            do i = 1, nsamp
               if(i .ge. iword1/nsi .and.
     :              i .le. iword2/nsi ) then
                  if (hang) then
                  
                     new_vel(i) = tri2(i-(iword1/nsi)+1)
                  else
                     new_vel(i) = tri2(i)
                  endif
               else
                  new_vel(i)=tri(i)
               endif
            enddo
            go to 999
         endif
c=============================================================================    
        if(value_Constraint) then
   
            do i = 1, nsamp
              if ( abs( tri(i)- value ) .le. 1.0e-32 ) then
                 new_vel(i) = tri2(i)
              else
                 new_vel(i) = tri(i)
              endif
            enddo
            go to 999
         endif   
c=============================================================================    
      
 999  return
      end
