C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine stak (x, y, nsamp, SZSMPD)

#include <f77/iounit.h>

      real    x (*), y (*)
      real    z
      pointer (wkz, z(1))
      integer nsamp, SZSMPD, ier, iab
      data    iab/0/

      item = nsamp * SZSMPD
      call galloc (wkz, item, ier, iab)
      if (ier .ne. 0) then
         write(LER)'FATAL ERROR in resorter: 3D stack option'
         write(LER)'Could not allocate memory (bytes) ',item
         call ccexit (666)
      endif

      do  i = 1, nsamp
          xi = x (i)
          yi = y (i)
          if (abs(xi) .ne. 0.0 .AND. abs (yi) .ne. 0.0) then
             z (i) = 0.5
          else
             z (i) = 1.0
          endif
          x (i) = xi + yi
      enddo
      do  i = 1, nsamp
          x (i) = x (i) * z (i)
      enddo

      call gfree (wkz)
      return
      end
