C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine pkdt (tri_att, tri_env, nsampo, threshold, tri )

c get machine dependent parameters

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c declare variables passed from calling routine

      integer     nsampo

      real        tri_att ( nsampo ), threshold
      real        tri_env ( nsampo ), tri(nsampo)

c declare local variables 

      integer  JP, IPEAK( SZLNHD ), JT, ITRF( SZLNHD ) 
      integer index, i , k

      real scalar, envmax, x, y, sample_location
      real PEAK( SZLNHD )

C***********************************************************************
C       FIND ARRAY POSITIONS OF MAXIMA AND MINIMA. THEN SET PEAK VALUES
C        OF INPUT tri_att AT IPEAK(I) ARRAY POSITIONS
C***********************************************************************

      CALL MNMX(tri_env,nsampo,IPEAK,JP,ITRF,JT)
 
      call maxmgv (tri_env,1,envmax,index,nsampo)

      scalar = threshold * envmax
C
      DO 200 I=1,JP

         K = IPEAK(I)

c
c       compute x-loc of envelope max using a parabola fit
c

         call parab(tri_env(k-1), tri_env(k), tri_env(k+1), x, y )

c
c       find secondary data function at x using a quadratic fit
c
         sample_location = 2.0 + x
         call vqint (tri_att(k-2),5,sample_location , 1, peak(i), 1 , 1)

  200 CONTINUE

C***********************************************************************
C  SET ENVELOPE LOBES TO IPEAK VALUES, if IPEAK > thresh
C***********************************************************************

      J = 1
      ISTRT = 1
  250 IEND = ITRF(J)

      DO I = ISTRT, IEND

         if ( abs( tri_env(ipeak(j)) ) .gt. scalar ) then
            tri(i) = peak(j)
         else
            tri(i) = 0.0
         endif

      ENDDO

C
      J = J+1
      IF(IEND .EQ. nsampo) GO TO 350
      ISTRT = IEND
      GO TO 250
C
  350 CONTINUE
C
      RETURN
      END

