C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine getavg(nx,ns,x,y,mode,lwin,nwin,ovlp,
     : havg, z, dead, ierror)
      real x(*),y(*),work(1),havg(*),medarr(1)
      integer z(*)
      real hmed(1)
      logical dead(*)
      integer ovlp,lwin,nwin,mode,ns,nx,knt(1)
      integer mids(1),firsts(1),lasts(1),jmoves(1)
      POINTER (pw,work),(pk,knt),(pmedarr,medarr)
      POINTER (phmed,hmed),(pmids,mids)
      POINTER (pfirsts,firsts),(plasts,lasts),(pjmoves,jmoves)
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
c +=======================================+
c | allocate space for local work buffers |
c +=======================================+
      iget = nx*nwin*ISZBYT
      error=0
      abort=0
c     +---------------------------------+
c     | vector to hold count per window |
c     +---------------------------------+
      call galloc(pk,iget,error,abort)
      iget = ns*ISZBYT
c          +-------------+
c          | work vector |
c          +-------------+
      call galloc(pw,iget,error,abort)
      iget = nwin * ISZBYT
c +----------------------------------------+
c | vectors to hold idexes to mid-point,   |
c | first sample, and last sample , and    |
c | number samples to move for each window |
c +----------------------------------------+
      call galloc(pmids,iget,error,abort)
      call galloc(pfirsts,iget,error,abort)
      call galloc(plasts ,iget,error,abort)
      call galloc(pjmoves,iget,error,abort)
c +----------------------------------------+
c | if median mode, also need vector to    |
c | do median sort in and a matrix to hold |
c | the medians.                           |
c +----------------------------------------+
      if(mode.eq.3)then
       iget = ns*ISZBYT
       call galloc(pmedarr,iget,error,abort)
       iget = nx*nwin*ISZBYT
       call galloc(phmed,iget,error,abort)
       do i=1,nwin
        ndx=(i-1)*nx
        do j=1,nx
         mdx=ndx+j
         hmed(mdx)=0.
        end do
       end do
      endif
      if(error.ne.0)then
       ierror =error
       return
      endif
C +---------------------------------------------------------+
C |                                                         |
C | Parameters are:                                         |
C |   nx     - number of traces to be processed             |
C |   ns     - Number of samples per trace                  |
C |    x     - data to be processed                         |
C |    y     - computed average gain curve                  |
C |    z     - work array (center sample # for each window) |
C |   lwin   - Length of the sliding window                 |
C |   nwin   - Number of windows                            |
C |   ovlp   - Overlap between windows (in samples)         |
C |   scale  - % of 2047 to scale to                        |
C |                                                         |
C +---------------------------------------------------------+
c +====================================+
c | First compute the window positions |
c | and move lengths.                  |
c +====================================+
      do kk=1,nwin
       if(kk.eq.1)then
        ifirst = 1
        ilast  = lwin
        nmove = lwin
        if(lwin.eq.ns)nmove=ns
       else
        ifirst = ifirst+ovlp
        ilast = ifirst+lwin-1
        nmove=lwin
        if(ilast.gt.ns)then
         nmove=ns-ifirst+1
         ilast = ns
        endif
       endif
       jmoves(kk)=nmove
       firsts(kk)=ifirst
       lasts(kk)=ilast
       mids(kk)=ifirst+ovlp
       if(mids(kk).gt.ns)mids(kk)=ns
       z(kk)=mids(kk)
      end do
c +================================+
c | clear all appropriate buffers  |
c +================================+
      do j=0,nx-1
       ib=j*nwin
       do i=1,nwin
        havg(i+ib)=0
        knt(i+ib)=0
        y(i+ib)=0
       end do
      end do
c +======================================+
c | Loop over all traces in the ensemble |
c | and compute the window averages      |
c +======================================+
      do itrace=1,nx
       if(.not.dead(itrace)) then
        ib=(itrace-1)*nwin
        mdx = (itrace-1)*ns
        mm = 1
        ifs = 1
c +===================================+
c | find first live sample this trace |
c +===================================+
        do while(x(mdx+mm).eq.0.0.and.mm.le.ns)
         ifs = mm
         mm = mm+1
        end do
c +==================================+
c | from the first live sample, find |
c | first window to work in          |
c +==================================+
        mm = 1
        jfw = 1
        do while(mm.lt.nwin.and.mids(mm).lt.ifs)
         jfw=mm
         mm=mm+1
        end do
c +==========================================+
c | now loop over all windows for this trace |
c +==========================================+
        do kk=jfw,nwin
         ifirst = firsts(kk)
         ilast = lasts(kk)
         nmove = jmoves(kk)
         mid = mids(kk)
         do mm=1,nmove
          work(mm)=0.
         end do
         ndx=(itrace-1)*ns+ifirst
         do m=1,nmove
          work(m)=x(ndx+m-1)
         end do
c +======================+
c | Get the ensemble sum |
c +======================+
         xavg=0.
         if(mode.eq.3)then
          jk=0
          do i=1,nmove
           if(work(i).ne.0.0)then
            jk=jk+1
            medarr(jk)=abs(work(i))
           endif
          end do
          if(jk.ne.0)then
           call hsort(jk,medarr)
           if(jk/2*2.ne.jk)then
            ndx=jk/2+1
            xavg = medarr(ndx)
           else
            ndx=jk/2
            ndx1=ndx+1
            xavg=medarr(ndx1)+medarr(ndx)
            xavg=xavg/2.
           endif
          else
           xavg=0.
          endif
          hmed(ib+kk)=xavg
          if(xavg.eq.0.and.kk.gt.1)then
           hmed(ib+kk)=hmed(ib+kk-1)
          endif
          knt(kk+ib)=1
         else
          xknt=0.
          do i=1,nmove
           yx = work(i)
           xy = abs(yx)
           if(xy.ne.0.0)then
            if(mode.eq.0)then
             xavg = xavg+xy
            elseif(mode.eq.2)then
             xavg=xavg+log(xy)
            elseif(mode.eq.4)then
             xavg=xavg+yx
            elseif(mode.eq.1)then
             xavg=xavg+xy*xy
            endif
            xknt = xknt+1.
           endif
          end do
          knt(ib+kk)=xknt
          havg(ib+kk)=xavg
          if(xknt.eq.0.and.kk.gt.jfw)then
           knt(ib+kk)=knt(ib+kk-1)
           havg(ib+kk)=havg(ib+kk-1)
          endif
         endif
        end do
       endif
       do m=1,nmove
        work(m)=0.
       end do
      end do
c +==========================+
c | Get the ensemble average |
c +==========================+
      do itrace=0,nx-1
       ib=itrace*nwin
       if(mode.eq.3)then
        do i=1,nwin
         havg(i+ib)=hmed(i+ib)
        end do
       else 
        do kk=1,nwin
         xknt=knt(ib+kk)
         xavg=havg(ib+kk)
         if(xknt.ne.0.0)then
          if(mode.eq.0.or.mode.eq.4)then
           xavg = xavg/xknt
          elseif(mode.eq.2)then
           xavg = xavg/xknt
           xavg = exp(xavg)
          elseif(mode.eq.1)then
           xavg=xavg/xknt
           xavg = sqrt(xavg)
          endif
         else
          xavg = 0.
         end if
         havg(ib+kk)=xavg
        end do
       endif
      end do
c +================================+
c | free the local dynamic buffers |
c +================================+
      call gfree(pw)
      call gfree(pmids)
      call gfree(pk)
      call gfree(pfirsts)
      call gfree(plasts)
      call gfree(pjmoves)
      if(mode.eq.3)then
       call gfree(pmedarr)
       call gfree(phmed)
      endif
      return
      end
