C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************c
c rhgain reads records of data, computes gain crvs for input, applies
c a rho filter, computes gain crvs of filtered data, and maps 
c amplitude of input onto the filtered data.  Output is created by
c averaging the input and filtered data, with user-specified weighting
c on input.
c**********************************************************************c
      implicit none
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h>
      integer    jerr,jtst,mode,lwin,lsm,lname,ierr,ner,iget
      integer    memsum,nrecc,igap,nwin,iend,istrt,ier,jj,i,j,kk
      integer    istrc,ldo,ndx,isthd,mdx,itrace,ib,ia,li
      integer    m,isthdr,jwin
      integer    ifmt_NumSmp,l_NumSmp,ln_NumSmp,LH
      integer    ifmt_SmpInt,l_SmpInt,ln_SmpInt
      integer    ifmt_NumTrc,l_NumTrc,ln_NumTrc
      integer    ifmt_NumRec,l_NumRec,ln_NumRec
      integer    ifmt_Format,l_Format,ln_Format
      integer    ifmt_TrcNum,l_TrcNum,ln_TrcNum,TH
      integer    ifmt_RecNum,l_RecNum,ln_RecNum
      integer    ifmt_DstUsg,l_DstUsg,ln_DstUsg
      integer    ifmt_StaCor,l_StaCor,ln_StaCor
      integer    itr ( SZLNHD ),z(1),abort1
      integer    nsamp, nsi, ntrc, nrec, iform, obytes
      integer    luin , luout, lbytes, nbytes, lbyout
      integer    irs,ire,ns,ne,tst,jlag
      integer    static,argis,getnwin,mk,mm
      real       weight,unitsc,dt,sr,rl,ul,ovlp
      real       ywin,xm,aa,bb,cc,slope,r
      real       havg(1),bigar1(1),trhdrs(1),a(1),b(1),work(1)
      real       c(1),bigc(1),chavg(1),rz(1)
      real       tempo(1),ctempo(1)
      real       expon,fed,fst,dn
      character  ntap * 256, otap * 256, name*6
      logical    verbos, dead(1)
      pointer    (pbigar, bigar1),(phdrs,trhdrs)
      pointer    (pdead,dead),(pa,a),(pww,work)
      pointer    (ptempo,tempo),(phavg,havg),(pz,z),(pb,b)
      pointer    (pc,c),(pbigc,bigc),(pch,chavg),(prz,rz)
      pointer    (pctemp,ctempo)
 
      data name/'RHGAIN'/
c +===========================================================+
c | read program parameters from command line card image file |
c +===========================================================+
      if ( argis('-h').gt.0.or. ( argis ( '-?' ) .gt. 0 )) then
       call help(ler)
       stop
      endif
 
#include <f77/open.h>
 
      TH = TRACEHEADER
      LH = LINEHEADER
      ovlp = 0.5
      call gcmdln(ntap,otap,irs,ire,mode,lwin,
     : verbos,fst,fed,expon,lsm,weight,tst,name,LER,LERR)

      weight = weight/100.
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

c +===========================+
c | read line header of input |
c | save certain parameters   |
c +===========================+
      lbytes = 0
      call rtape  ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'RHGAIN: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif
c +==============================================+
c | Set up locations and offsets for, then read  |
c | some lineheader info.  Set up locations and  |
c | offsets for trace header info                |
c +==============================================+
      call savelu('NumSmp',ifmt_NumSmp,l_NumSmp,ln_NumSmp,LH)
      call savelu('SmpInt',ifmt_SmpInt,l_SmpInt,ln_SmpInt,LH)
      call savelu('NumTrc',ifmt_NumTrc,l_NumTrc,ln_NumTrc,LH)
      call savelu('NumRec',ifmt_NumRec,l_NumRec,ln_NumRec,LH)
      call savelu('Format',ifmt_Format,l_Format,ln_Format,LH)

      call saver2(itr,ifmt_NumSmp,l_NumSmp,ln_NumSmp,nsamp,LH)
      call saver2(itr,ifmt_SmpInt,l_SmpInt,ln_SmpInt,nsi  ,LH)
      call saver2(itr,ifmt_NumTrc,l_NumTrc,ln_NumTrc,ntrc ,LH)
      call saver2(itr,ifmt_NumRec,l_NumRec,ln_NumRec,nrec ,LH)
      call saver2(itr,ifmt_Format,l_Format,ln_Format,iform,LH)
      call saver(itr, 'UnitSc', unitsc, LH)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LH)
      endif

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)


      lname = 6
      call hlhprt (itr, lbytes, name, lname, LERR)

c +==============================================================+
c | ensure that command line values are compatible with data set |
c | (i.e. start/end traces; start/end records)                   |
c +==============================================================+
      ns = 1
      ne = ntrc
      call cmdchk(ns,ne,irs,ire,ntrc,nrec)

c +----------------------------------+
c | malloc space we are going to use |
c +----------------------------------+

      ierr = 0
      ner = 0
      abort1 = 0

      iget = ntrc * nsamp * ISZBYT
      call galloc (pbigar, iget, ierr, abort1)
      memsum=iget
      if (ierr .ne. 0.) ner=ner+1
      call galloc(pa, iget, ierr, abort1)
      memsum=memsum+iget
      if (ierr .ne. 0.) ner=ner+1
      call galloc (pbigc, iget, ierr, abort1)
      memsum=iget
      if (ierr .ne. 0.) ner=ner+1
      call galloc(pc, iget, ierr, abort1)
      memsum=memsum+iget
      if (ierr .ne. 0.) ner=ner+1

      iget =ntrc*ISZBYT
      call galloc (pdead, iget, ierr, abort1)
      memsum=memsum+iget
      if (ierr .ne. 0.) ner=ner+1

      iget = ntrc*ITRWRD*ISZBYT
      call galloc (phdrs, iget, ierr, abort1)
      memsum=memsum+iget
      if (ierr .ne. 0.) ner=ner+1

      if(ntrc.gt.nsamp)then
       iget = ntrc*3*ISZBYT
      else
       iget = nsamp*ISZBYT
       if(ntrc.gt.nsamp/3)iget=nsamp*3*ISZBYT
      endif
      call galloc(pb     , iget, ierr, abort1)
      memsum=memsum+iget
      if (ierr .ne. 0.) ner=ner+1
      call galloc(pww, iget, ierr, abort1)
      memsum=memsum+iget
      if (ierr .ne. 0.) ner=ner+1
      call galloc(ptempo , iget, ierr, abort1)
      memsum=memsum+iget
      if (ierr .ne. 0.) ner=ner+1
      call galloc(pctemp , iget, ierr, abort1)
      memsum=memsum+iget
      if (ierr .ne. 0.) ner=ner+1

      iget = nsamp*ISZBYT
      call galloc(prz    , iget, ierr, abort1)
      memsum=memsum+iget
      if (ierr .ne. 0.) ner=ner+1

      if (ner.ne.0)then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) memsum,'  bytes'
         write(LERR,*)' '
         call lbclos(luin)
         call lbclos(luout)
         stop    
      endif
c +==============================================================+
c | modify line header to reflect actual number of traces output |
c +==============================================================+
      nrecc=ire - irs+1
      call savew2(itr,ifmt_NumRec,l_NumRec,ln_NumRec,nrecc,LH)
      call savew2(itr,ifmt_NumTrc,l_NumTrc,ln_NumTrc,ntrc ,LH)

c +---------------------+
c | number output bytes |
c +---------------------+
      obytes = SZTRHD + nsamp * ISZBYT
      call savhlh(itr,lbytes,lbyout)
      call wrtape ( luout, itr, lbyout                 )

c +-------------------------------------+
c | Compute sample interval in seconds. |
c | Handle microseconds if necessary    |
c +-------------------------------------+
      dt = float (nsi) * unitsc
      sr = float (nsi)
      if(fed.eq.0.0)fed = 1./(2.*dt)
      jtst = tst
      tst = tst/nsi+1
      if(tst.gt.nsamp-50) then
       write(LER ,*)'Start time too great.  FATAL'
       call lbclos(luin)
       call lbclos(luout)
       stop 100
      endif
      if(tst.ge.50)then
       jlag = 25
      else
       jlag = tst/2
       if(tst.eq.1)jlag=0
      endif
c +-----------------------------------+
c | Compute window length in samples  |
c | and number of windows.            |
c +-----------------------------------+
      if(lwin.eq.0)then
        lwin = 1000/sr
      else
        lwin = lwin/sr
      endif
      ywin = ((float(lwin)-1.)/2.)*2.+1.
      lwin = ywin
      if(mode.gt.3)mode=0

      if( verbos ) then
       jwin = lwin * sr
       call verbal(nsamp, nsi, ntrc, nrec,mode,jwin,
     :             lsm,ntap,otap,fst,fed,expon,weight,jtst,LERR)
      end if
      igap = lwin * ovlp
      nwin=0
      iend=lwin
      istrt=1
      nwin = getnwin(istrt,lwin,igap,nsamp)
c------------------------------------------
c  now allocate the work arrays for getavg         
c-----------------------------------------
      ner = 0
      ier = 0
      abort1 = 0
      iget = nwin*ntrc*ISZBYT
      call galloc(phavg , iget, ierr, abort1)
      memsum=memsum+iget
      if (ierr .ne. 0.) ner = ner+1
      call galloc(pch   , iget, ierr, abort1)
      memsum=memsum+iget
      if (ierr .ne. 0.) ner = ner+1
      call galloc(pz , iget, ierr, abort1)
      memsum=memsum+iget
      if (ierr .ne. 0.) ner = ner+1

      if (ner.ne.0) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) memsum,'  bytes'
         write(LERR,*)' '
         call lbclos(luin)
         call lbclos(luout)
         stop    
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) memsum,'  bytes'
         write(LERR,*)' '
      endif

c +================================+
c |     BEGIN PROCESSING           |
c | first skip unwanted records    |
c +================================+
      if(irs.gt.1)then
       iget=(irs-1)*ntrc+1
       call recskp(1,irs-1,luin,ntrc,itr)
      end if
c +================================+
c |  process desired trace records |
c +================================+
      do jj = irs, ire
       do i=1,ntrc
        dead(i)=.false.
       end do
       do i=1,ntrc
        j=(i-1)*nsamp
        do kk=1,nsamp
         a(j+kk)=0.
        end do
       end do
       do kk = 1,ntrc
        nbytes = 0
        call rtape( luin, itr, nbytes)
        if(nbytes .eq. 0) then
         write(LERR,*)' Premature end of file on input'
         write(LERR,*)'Abnormal Termination'
         write(LERR,*)' at sequential record ',jj
         write(LERR,*)' at sequential trace ',kk
         write(LER,*)' '
         write(LER,*)'RHGAIN:'
         write(LER,*)' Premature end of file on input'
         write(LER,*)' at sequential record ',jj
         write(LER,*)' at sequential trace ',kk
         write(LER,*)' '
         write(LER,*)' Abnormal Termination'
         write(LER,*)'WARNING'
         call lbclos(luin)
         call lbclos(luout)
         stop
        endif
        call saver2(itr,ifmt_StaCor,l_StaCor,ln_StaCor,static,TH)
        dead(kk)=.false.
        if (static .eq. 30000) then
          call vclr (itr(ITHWP1),1,nsamp)
          dead(kk)=.true.
        end if
        istrc = (kk-1)*nsamp
        call vmov (itr(ITHWP1),1, bigar1(istrc+1),1,nsamp)
        if(.not.dead(kk))then
         call vclr(rz,1,nsamp)
         ldo = nsamp-tst+jlag+1
         ndx = ITHWP1+tst-1-jlag
         call rho(itr(ndx),ldo,rz,dt,expon,fst,fed,lsm,ierr,LERR)
         if(jlag.gt.0)then
          call vmov(itr(ITHWP1),1,bigc(istrc+1),1,tst)
          dn=1
          mk=tst
          do mm = jlag,1,-1
           rl = (26. - dn)/25.
           ul = 1. - rl
           bigc(istrc+mk)=bigc(istrc+mk)*ul+rz(mm)*rl
           dn = dn+1.
           mk = mk-1
          end do
          call vmov(rz(jlag+1),1,bigc(istrc+tst),1,
     :         (nsamp-tst+1))
         else
          call vmov(rz,1,bigc(istrc+1),1,nsamp)
         endif
        else
         call vclr(bigc(istrc+1),1,nsamp)
        endif
        isthd = (kk-1)*ITRWRD
        call vmov(itr,1,trhdrs(isthd+1),1,ITRWRD)
       end do    
       ierr = 0
c +===============================+
c | Compute the temporal averages |
c +===============================+
       do i=1,nwin
         ndx = (i-1)*ntrc
        do j=1,ntrc
         mdx = ndx + j
         havg(mdx)=0.
        end do
       end do
       call getavg (ntrc, nsamp, bigar1, a,mode,lwin,nwin,igap,
     :   havg, z, dead, ierr)
       call getavg (ntrc, nsamp, bigc, c,mode,lwin,nwin,igap,
     :   chavg, z, dead, ierr)
       if(ierr.ne.0)then
        write(LERR,*)' '
        write(LERR,*)'Unable to allocate workspace for getavg'
        write(LERR,*)' '
        call lbclos ( luin )
        call lbclos ( luout )
        stop
       endif
c +=============================+
c | do temporal interpolation   |
c +=============================+
       do itrace=0,ntrc-1
        ib=itrace*nwin
        ia=itrace*nsamp
        do kk=1,nwin
         if(kk.eq.1)then
          li=z(kk)
          do j=1,li
           a(j+ia)=havg(kk+ib)
           c(j+ia)=chavg(kk+ib)
          end do
         else
          j=z(kk)
          li=z(kk-1)
          xm = j-li
          aa=havg(kk+ib-1)
          bb=havg(kk+ib)
          slope=(bb-aa)/xm
          r=0
          do m=li+1,j
           r=r+1
           a(m+ia)=aa+slope*r
          end do
          aa=chavg(kk+ib-1)
          bb=chavg(kk+ib)
          slope=(bb-aa)/xm
          r=0
          do m=li+1,j
           r=r+1
           c(m+ia)=aa+slope*r
          end do
         endif
        end do
        li=z(nwin)
        if(li.lt.nsamp)then
         do j=li+1,nsamp
          a(j+ia)=havg(nwin+ib)
          c(j+ia)=chavg(nwin+ib)
         end do
        endif
       end do
c +====================+
c | write output data  |
c +====================+
c +==============================+
c | apply the gain to the data   |
c | and output.                  |
c +==============================+
       do i=0,ntrc-1
        ndx=i*nsamp
        do j=1,nsamp
         bb = bigar1(ndx+j)
         if(bb.ne.0)then
          cc = c(j+ndx)
          if(cc.ne.0.0)then
           b(j)=bigc(ndx+j)/cc*a(j+ndx)
           b(j)=(b(j)*weight+bb)/2.
          else
           b(j)=0.
          endif
         else
          b(j)=0.
         endif
        end do
       isthdr = i*ITRWRD+1
        call vmov(trhdrs(isthdr),1,itr,1,ITRWRD)
        call saver2(itr,ifmt_StaCor,l_StaCor,ln_StaCor,static,TH)
        if (static .ge. 30000) then
          call vclr (itr(ITHWP1),1,nsamp)
        else
          call vmov(b,1,itr(ITHWP1),1,nsamp)
        endif
        call wrtape(luout,itr,obytes)
       end do
      end do

c +======================+
c | close data files and |
c | end processing       |
c +======================+
      call lbclos ( luin )
      call lbclos ( luout )
      stop
      end
 
C***********************************************************************
      subroutine help(ler)
         write(LER,*)
     :'***************************************************************'
        write(LER,*) ' '
        write(LER,*)
     :'rhgain computes the average amplitude decay for a record of   '
        write(LER,*)
     :'data before and after application of a rho filter, maps the'
        write(LER,*)
     :'amplitude structure of the original data onto the filtered '
        write(LER,*)
     :'data, and averages the weighted filtered data with the '
        write(LER,*)
     :'original data.'
        write(LER,*)
     :'see manual pages for details ( online by typing uman prg )'
        write(LER,*)' '
        write(LER,*)
     :'execute rhgain by typing rhgain and the of program parameters'
        write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
        write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
        write(LER,*)' '
        write(LER,*)
     :' -N [ntap]    (stdin)              : input data file name'
        write(LER,*)
     :' -O [otap]    (stdout)             : output data file name'
        write(LER,*)
     :' -rs[irs]     (default = first)    : start record number'
        write(LER,*)
     :' -re[ire]     (default = last)     : end record number'
        write(LER,*)
     :' -md[md]      (default = 0)        : averaging mode'
        write(LER,*)
     :'                                     0 = AAA'
        write(LER,*)
     :'                                     1 = rms' 
        write(LER,*)
     :'                                     2 = GMAA'
        write(LER,*)
     :'                                     3 = median  '
        write(LER,*)
     :' -w[lwin]    (default = 1000 ms)   : window length (ms) '
        write(LER,*)
     :' -sm[lsm]  (default = 0)           : temporal smoothing for  '
        write(LER,*)
     :'                                     filtered data (0 = none)'
        write(LER,*)
     :' -fl          (default = 0)        : Frequency to start weight'
        write(LER,*)
     :'                                     computation'
        write(LER,*)
     :' -fh          (default = 0)        : Frequency to end weight'
        write(LER,*)
     :'                                     computation'
        write(LER,*)
     :' -ex          (default = 1.)       : Weighting exponent'
        write(LER,*)
     :' -cw          (default = 100%)     : scaling for filtered data '
        write(LER,*)
     :'                                     when averged with input'
        write(LER,*)
     :'                                     in percent'
        write(LER,*)
     :' -s           (default = 0)        : start time for filter app '
        write(LER,*) ' '
        write(LER,*)
     :' -V  include on command line if verbose printout is desired'
        write(LER,*)
     :'usage:   rhgain -N[] -O[] -rs[] -re[] -md[md], w[], '
        write(LER,*)
     :'  -sm[] -fl[] -fh[] -ex[] -cw[] -s[] -V'
        write(LER,*) ' '
        write(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
      subroutine gcmdln(ntap,otap,irs,ire,mode,lwin,
     : verbos,fst,fed,expon,lsm,weight,tst,name,LER,LERR)
c-----
c     get command arguments
c
c     ntap    - C*100    input file name
c     otap    - C*100    output file name
c     irs     - I*4      starting record index
c     ire     - I*4      ending record index
c     mode    - I*4      average mode 
c                        0=arith  
c                        1=rms
c                        2=geometric
c                        3=median
c     lwin    - I*4      window length 
c     fst     - R*4      minimum frequency for weight
c     fed     - R*4      maximum frequency for weight
c     expon   - R*4      weighting exponent
c     lsm     - I*4      temporal smoothing length for filterd output
c     weight  - R*4      weight for filtered data added to input
c     tst     - I*4      window overlap (50%)
c     verbos    L        verbose output or not
c-----
      implicit none
      character   ntap*(*), otap*(*),name
      integer     irs, ire,LER,LERR
      integer     mode, lwin,lsm,tst
      real        weight,fst,fed,expon
      logical     verbos
      integer     argis
 
c-------
c     see manual pages on the argument handler routines
c     for the meanings of these functions
c-------
            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            call argi4 ( '-rs', irs ,   0  ,  0    )
            call argi4 ( '-re', ire ,   0  ,  0    )
            call argi4 ( '-md', mode,  0, 0 )
            call argi4 ( '-w' , lwin,  0, 0)
            call argr4 ( '-cw',weight,100.0,100.0)
            call argi4 ( '-sm', lsm, 0, 0)
            call argr4 ( '-fl',fst,0.0,0.0)
            call argr4 ( '-fh',fed,0.0,0.0)
            call argr4 ( '-ex',expon,1.0,1.0)
            call argi4 ( '-s',tst,0,0)
            verbos =   (argis('-V') .gt. 0)
            call xtrarg (name, LER , .FALSE., .FALSE.)
            call xtrarg (name, LERR, .FALSE., .TRUE.)
      return
      end
 
      subroutine verbal(nsamp, nsi, ntrc, nrec,mode,lwin,
     :                  lsm,ntap,otap,fl,fh,ex,cw,tst,LERR)

      implicit none
      integer    nsamp, nsi, ntrc, nrec,LERR
      integer    mode,lwin,lsm,tst,lenth
      real       cw,ex,fl,fh
      character  ntap*(*), otap*(*)
 
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace      =  ', nsamp
            write(LERR,*) ' sample interval         =  ', nsi
            write(LERR,*) ' traces per record       =  ', ntrc
            write(LERR,*) ' records per line        =  ', nrec
            write(LERR,*) ' input data set name     =  ', 
     :               ntap(1:lenth(ntap))
            write(LERR,*) ' output data set name    =  ', 
     :               otap(1:lenth(otap))
            if(mode.eq.0)then
             write(LERR,*)' averaging method        =  AAA'
            endif
            if(mode.eq.1)then
             write(LERR,*)' averaging method        =  RMS '
            endif
            if(mode.eq.2)then
             write(LERR,*)' averaging method        =  GMAA'
            endif
            if(mode.eq.3)then
             write(LERR,*)' averaging method        =  median'
            endif
            write(LERR,*) ' window length           = ',lwin,' ms'
            if (lsm.ne. 0) then
            write(LERR,*)' Temporal smoothing       = ',lsm,' samples'
            endif
            write(LERR,*)' Minimum freq for weights = ',fl,' Hz'
            write(LERR,*)' Maximum freq for weights = ',fh,' Hz'
            write(LERR,*)' Rho filter exponent      = ',ex
            write(LERR,*)' Mix weighting factor     = ',cw
            write(LERR,*)' Filter start time        = ',tst
            write(LERR,*)' '
            write(LERR,*)' '
 
      return
      end
