C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine rho(x,lx,y,sr,expon,fst,fed,sm,ierr,LERR)
      real x(*), y(*), work(1),quad(1)
      real abs_in(1),abs_out(1),temp(1)
      real fnyq,delf,sr,fst,fed
      integer sm
      complex wc(1), fop
      POINTER (pw, work),(pwc,wc)
      POINTER (pqi,quad),(ptmp,temp)
      POINTER (pai,abs_in),(pao, abs_out)
      integer lx,ierr,n2,iget,iabort,i,n6

      n2 = 32
      lx2 = lx+lx
      do while(n2.lt.lx2)
       n2=n2+n2
      end do
      n3 = n2/2+1
      n6=n3+n3
      fnyq=1./(2.*sr)
      delf=fnyq/float(n3-1)
      call sizefloat(isz)
      iget = n6*isz
      ierr = 0
      iabort = 0
      call galloc(pw,  iget,ierr,iabort)
      call galloc(pwc, iget,ierr,iabort)
      call galloc(pqi, iget,ierr,iabort)
      call galloc(pai, iget,ierr,iabort)
      call galloc(pao, iget,ierr,iabort)
      iget=lx*isz
      call galloc(ptmp,iget,ierr,iabort)
      if(ierr.ne.0)return
      do i=lx,n6
        work(i)=0.
      end do
      do i=1,lx
       work(i)=x(i)
      end do
      call hilbertx(work,lx,quad,ierr)
      if(ierr.ne.0)return
      do i=1,lx
       a = work(i)
       a = a*a
       b = quad(i)
       b = b*b
       abs_in(i)=sqrt(a+b)
      end do
      if(sm.ne.0)then
       call smooth(abs_in,lx,temp,sm)
      endif
      call rfft(work,n2,1)
      call rfftsc(work,n2,3,1)
      j=-1
      do i=1,n3
        j=j+2
        xy = float(i-1)*delf
        if (xy.ge. fed) then
          xy = fed**expon
        elseif(xy.ge.fst.and.expon.ne.0.0) then
          xy = xy**expon
        elseif (fst .gt. 0.0) then
          xy = fst**expon
        else
          xy = 1.0
        endif
        fop=cmplx(xy,0.0)
        wc(i)=cmplx(work(j),work(j+1))*fop
      end do
      j=-1
      do i=1,n3
       j=j+2
       work(j)=real(wc(i))
       work(j+1)=aimag(wc(i))
      end do
      call rfftsc(work,n2,-3,0)
      call rfft(work,n2,-1)
      call hilbertx(work,lx,quad,ierr)
      if(ierr.ne.0)return
      do i=1,lx
       a = work(i)
       a = a*a
       b = quad(i)
       b = b*b
       xy=sqrt(a+b)
       abs_out(i)=xy
      end do
      if(sm.ne.0)then
       call smooth(abs_out,lx,temp,sm)
      endif
      do i=1,lx
       if(abs_out(i).ne.0.0)then
        y(i)=work(i)*abs_in(i)/abs_out(i)
       else
        y(i)=0.
       endif
      end do
      call gfree(pw)
      call gfree(pwc)
      call gfree(pai)
      call gfree(pao)
      call gfree(pqi)
      call gfree(ptmp)
      return
      end
      subroutine smooth(x,lx,temp,sm)
      real x(*),temp(*)
      integer sm

      do i=1,lx
       jts = i-sm+1
       jte = i+sm
       if(jts.lt.1)jts=1
       if(jte.gt.lx)jte=lx
       icnt=0
       do j=jts,jte
        if(x(j).ne.0)then
         icnt=icnt+1
         temp(icnt)=x(j)
        endif
       end do
       if(icnt.gt.0)then
        avg=0
        do j=1,icnt
         avg=avg+temp(j)
        end do
        avg=avg/float(icnt)
        x(i)=avg
       endif
      end do
      return
      end
