C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE PFFT(carray,N,delta)          
 
CHEADER************************************************************************C
C*                                                                            *C
C*                                                                            *C
CT  TITLE        : DELTA                                                      *C
C*                                                                            *C
CD  DESCRIPTION  : THIS SUBROUTINE PERFORMS A 1-D FFT TO COMPLEX DATA.        *C
C*                                                                            *C
CK  KEYWORDS     : FFT                                                        *C
C*                                                                            *C
CL  LANGUAGE     : FORTRAN77                                                  *C
C*                                                                            *C
CS  CALLING SEQ. : CALL PFFT(CX,N,DELTA)                                      *C
C*                                                                            *C
CI  INPUTPAR.    : CX     - ARRAY CONTAINING COMPLEX DATA                     *C
CI               : N      - FOURIER NUMBER                                    *C
CI               : DELTA  - REAL SCALING FACTOR                               *C
C*                                                                            *C
CO  OUTPUTPAR.   : CX     - ARRAY CONTAINING FFT-ED DATA.                     *C
C*                                                                            *C
CE  ENTRY POINTS : NONE                                                       *C
C*                                                                            *C
CB  COMMON BLOCK : NONE                                                       *C
C*                                                                            *C
CU  UPDATE       : 14-01-93 - CREATION BY RGVB                                *C
C*                                                                            *C
CC  COMMENT      : IF SIGN(DELTA) = -1 --> EXP(-j(m-1)(n-1))                  *C
CC               : IF SIGN(DELTA) =  1 --> EXP(+j(m-1)(n-1))                  *C
C*                                                                            *C
C*                                                                            *C
C*                                                                            *C
C*  (C) 1993                                                                  *C
C*      LABORATORY OF TECHNICAL GEOPHYSICS                                    *C
C*      DEPARTMENT OF MINING ENGINEERING                                      *C
C*      DELFT UNIVERSITY OF TECHNOLOGY                                        *C
C*      DELFT, THE NETHERLANDS                                                *C
C*                                                                            *C
C*                                                                            *C
C************************************************************************HEADERC
#include <save_defs.h>
#include <f77/lhdrsz.h>
 
C       ... IMPLICIT NONE ...
 
	integer j,i,N,m,istep,l
        complex carray(SZLNHD),cw,cwork
	real signi,sc,delta,arg
 
C       ... START OF SUBROUTINE ...
        j=1
	if (delta.lt.0.) then
		signi	= -1.
	else
		signi	= 1.
	endif
	sc	= abs(delta)
        do 630 i=1,N
        if(i.gt.j) goto 610
        cwork=carray(j)*sc
        carray(j)=carray(i)*sc
        carray(i)=cwork
610     m=N/2
620     if(j.le.m) goto 630
        j=j-m
        m=m/2
        if(m.ge.1) goto 620
630     j=j+m
        l=1
640     istep=2*l
        do 650 m=1,l
c        carg=cmpN(0.,1.)*(3.141592653*signi*(m-1))/l
        arg=3.141592653*signi*(m-1)/l
        cw=cmplx(cos(arg),sin(arg))
        do 650 i=m,N,istep
        cwork=cw*carray(i+l)
        carray(i+l)=carray(i)-cwork
650     carray(i)=carray(i)+cwork
        l=istep
        if(l.lt.N) goto 640

C       ... END OF SUBROUTINE ...
        return
        end
