C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
       subroutine mivs(tbufdata,tbufmodel,hbegin,nsamp,
     1                 unoise,nfft,theta,nttaper,
     2                 dist,xmin,dx,bigmem,noffset, 
     3                 live,np,ifl,ifh,irec,lenhed, 
     4                 a,utrans,u,rnorm,wgt,
     5                 v,r,e,ec,temp,rc,
     6                 s,freq,p,udata,
     7                 dp,minpnoise,maxpnoise,interpolate,
     8                 radon,cincr,white,df,  
     9                 ist,iend,lenwnd,lenwnd_out,nsm,nem,nsa,nea,ntr,
     a                 rtabf,itabf,initfftf,work,
     b                 rtabi,itabi,initffti,tabled,lastpat,
     c                 lenrtab,lenitab,lenwork,distpat,maxpat,
     d                 nlive,taper,wrmodel,signal,pass,
     e                 muteend,mute,lerr,cputim,waltim,verbose,
     f                 tracebuf,delt,nbytes_spec,luspec,
     g                 wrspectrum,l_trcnum,l_dstsgn,l_recnum)
      integer   hbegin
c_________________________________________________________________________
c     unfiltered gather in, filtered gather out.
c_________________________________________________________________________
      real   tbufdata(hbegin:nsamp,ntr)    
c_________________________________________________________________________
c     modeled 'noise' traces. (output multiple gather)
c_________________________________________________________________________
      real   tbufmodel(hbegin:nsamp,ntr)    
c_________________________________________________________________________
c     buffer for data spectrum.                             
c_________________________________________________________________________
      real   tracebuf(hbegin:2*nfft)
c_________________________________________________________________________
c     moveout function theta(x)    
c     trace distances  dist(x)     
c_________________________________________________________________________
      real       theta(ntr)     
      real       dist(ntr)     
      real       distpat(ntr,0:maxpat)     
c_________________________________________________________________________
c     live trace indicator
c_________________________________________________________________________
      logical    live(ntr)
c_________________________________________________________________________
c     radon transformed data.
c_________________________________________________________________________
      complex    utrans(ifl:ifh,np)
c_________________________________________________________________________
c     model trace.     
c_________________________________________________________________________
      real       unoise(nfft,nsa:nea)
c_______________________________________________________________
c     fourier transform of windowed input data trace.                           
c_______________________________________________________________
      real       udata(nfft,nsm:nem)
c_______________________________________________________________
c     fourier transform table and work arrays.                       
c_______________________________________________________________
      real       rtabf(lenrtab)        
      integer    itabf(lenitab)
      real       rtabi(lenrtab)        
      integer    itabi(lenitab)
      real       work(lenwork)
c_______________________________________________________________
c     matrices for normal equations and solutions.                   
c_______________________________________________________________
      complex    a(ifl:ifh,np,0:maxpat)
      complex    u(ifl:ifh,np)
c_______________________________________________________________
c     work arrays for weiner levinson recursion formula.
c_______________________________________________________________
      real       rnorm(ifl:ifh)
      complex    s(np,ifl:ifh)
      complex    v(ifl:ifh),r(ifl:ifh)
      complex    e(ifl:ifh),ec(ifl:ifh)
      complex    temp(ifl:ifh),rc(ifl:ifh)
c_______________________________________________________________
c     radon transform matrix
c_______________________________________________________________
      complex    radon(ifl:ifh,np,0:noffset)               
c_______________________________________________________________
c     tabled arrays.
c_______________________________________________________________
      real       freq(ifl:ifh)
      real       p(np)
      real       delt(np)
      complex    cincr(np)                           
      real       wgt(np)     
c_______________________________________________________________
c     mute preservation array
c_______________________________________________________________
      integer    muteend(ntr)
c_______________________________________________________________
c     timing arrays.
c_______________________________________________________________
      real       cputim(*),waltim(*)
c_______________________________________________________________
c     logical control directives.
c_______________________________________________________________
      logical    taper,wrmodel
      logical    bigmem,forward       
      logical    interpolate,noise
      logical    tabled(0:maxpat)
      logical    verbose             
      logical    wrspectrum
      logical    signal(np)
      logical    pass
      logical    mute
c
      if(mute) then
c___________________________________________________________________
c        mute preservation initialization.
c___________________________________________________________________
         do 5000 jtr=1,ntr
          do 4000 isamp=1,nsamp
           if(tbufdata(isamp,jtr) .ne. 0) then
              muteend(jtr)=isamp-1
              go to 4001
           endif
4000      continue
4001      continue
5000     continue
      endif
c___________________________________________________________________
c     build the model.         
c___________________________________________________________________
      df=freq(ifl+1)-freq(ifl)
c___________________________________________________________________
c     clear transform space
c     any dead traces have been zeroed out in calling program.
c___________________________________________________________________
      call vclr(utrans,1,np*(ifh-ifl+1)*2)
      do 40000 itr=nsm,nem
c___________________________________________________________________
c      copy window of trace data into work array udata.
c___________________________________________________________________
       kt=0
       do 11000 jt=ist,min(nsamp,ist+nfft-1)
          kt=kt+1
          udata(kt,itr)=tbufdata(jt,itr)
11000  continue
c___________________________________________________________________
c      zero pad beyond the end of the data if necessary.
c___________________________________________________________________
       if ( (ist+nfft-1) .gt. nsamp ) then
          do 12000 jt=nsamp+1,ist+nfft-1
             kt=kt+1
             udata(kt,itr)=0.
12000     continue
       endif
40000 continue
c___________________________________________________________________
c     take forward Fourier transform.    
c___________________________________________________________________
      forward=.true.
      call timstr(v1,w1)
      call rmmfft(udata(1,nsm),work,itabf,rtabf,forward,
     1            nfft,lenwork,lenitab,lenrtab,
     2            nfft,(nem-nsm+1),initfftf,lerr)
      initfftf=0
      call timend(cputim(2),v1,v2,waltim(2),w1,w2)
c______________________________________________________________________
c     determine which gather distance pattern we are working with.
c______________________________________________________________________
      call getpat(dist,distpat,ntr,nsm,nem,lastpat,maxpat,ipat,
     1            live)
      if(verbose) write(lerr,*) 'ipat = ',ipat
      lena=2*np*(ifh-ifl+1)
      if(.not. tabled(ipat)) then
c______________________________________________________________________
c                                         T
c        initialize normal matrix: [A]=[R] [R]
c_____________________________________________________________________
         call vclr(a(ifl,1,ipat),1,lena)
      endif

      do 60000 itr=nsm,nem
       if(.not. live(itr)) go to 60000
       if(bigmem) then
          ioffset=nint((dist(itr)-xmin)/dx)+1
c_____________________________________________________________________
c         check for unsorted data and discard.
c         bad command lines have been tagged in routine rdgather.
c_____________________________________________________________________
          if(ioffset .lt. 1 .or. ioffset .gt. noffset) then
             ioffset=0
             call timstr(v1,w1)
             call getradon(radon(ifl,1,ioffset),p,ifl,ifh,
     1                  df,np,freq,theta(itr),cincr)
             call timend(cputim(3),v1,v2,waltim(3),w1,w2)
          endif
       else
          call timstr(v1,w1)
          ioffset=0
          call getradon(radon(ifl,1,ioffset),p,ifl,ifh,
     1                  df,np,freq,theta(itr),cincr)
          call timend(cputim(3),v1,v2,waltim(3),w1,w2)
       endif
c___________________________________________________________________
c      take forward Radon transform 
c___________________________________________________________________
       call timstr(v1,w1)
       call radfwd(udata(2*(ifl-1)+1,itr),utrans,
     1             radon(ifl,1,ioffset),ifl,ifh,np)
       call timend(cputim(4),v1,v2,waltim(4),w1,w2)
       if(.not. tabled(ipat)) then
c___________________________________________________________________
c         accumulate normal equations by integrating over x.
c___________________________________________________________________
          call timstr(v1,w1)
          call accnorm(a(ifl,1,ipat),radon(ifl,1,ioffset),ifl,ifh,np)
          call timend(cputim(10),v1,v2,waltim(10),w1,w2)
       endif
60000 continue
      if(.not. tabled(ipat)) then
c______________________________________________________________________
c        add white noise for stability
c______________________________________________________________________
         do 65000 ifreq=ifl,ifh
          a(ifreq,1,ipat)=a(ifreq,1,ipat)*(1.0+white)
65000    continue
         if(ipat .ne. 0) then
c______________________________________________________________________
c           normal equation assembly complete. it is now 'tabled'
c______________________________________________________________________
            tabled(ipat)=.true.
            write(lerr,*)
            write(lerr,*) 'trace distance pattern # ',ipat,' tabled'
            write(lerr,'(i12,f12.3)') (i,distpat(i,ipat),i=nsm,nem)
         endif
      endif
      if(tabled(ipat)) then
c______________________________________________________________________
c        move tabled normal equations into work area (ipat = 0)
c        Toeplitz matrix solution destroys the input array a.
c______________________________________________________________________
         call vmov(a(ifl,1,ipat),1,a(ifl,1,0),1,lena)
      endif
c______________________________________________________________________
c     build intermediate inverse
c     solve equations using a complex levinson recurrsion algorithm
c     use non recursive version on vector computer,
c     use recursive version on scalar computer.
c______________________________________________________________________
      call timstr(v1,w1)
      call mclev(np,a(ifl,1,0),utrans,u,s,ifl,ifh,
     1           rnorm,v,r,e,ec,temp,rc)
      call timend(cputim(5),v1,v2,waltim(5),w1,w2)
c___________________________________________________________________
c     taper the data in p space to reduce flairs.
c___________________________________________________________________
      do 67000 ip=1,np           
       if(wgt(ip) .ne. 1) then
          do 66000 ifreq=ifl,ifh         
           u(ifreq,ip)=u(ifreq,ip)*wgt(ip)
66000     continue
       endif
67000 continue
      if(wrspectrum) then
         call spectrum(u,tracebuf,tracebuf,delt,ifl,ifh,nfft,
     1                 np,hbegin,nbytes_spec,luspec,irec,
     2                 l_trcnum,l_dstsgn,l_recnum)
      endif 
c___________________________________________________________________
c     compute modeled data. 
c___________________________________________________________________
      call timstr(v1,w1)
      do 70000 itr=nsa,nea
       call vclr(unoise(1,itr),1,nfft)         
       if(live(itr)) then           
          if(bigmem) then
             ioffset=nint((dist(itr)-xmin)/dx)+1
c_____________________________________________________________________
c            check for unsorted data and discard.
c            bad command lines have been tagged in routine rdgather.
c_____________________________________________________________________
             if(ioffset .lt. 1 .or. ioffset .gt. noffset) then
                ioffset=0
                call timstr(v1,w1)
                call getradon(radon(ifl,1,ioffset),p,ifl,ifh,
     1                     df,np,freq,theta(itr),cincr)
                call timend(cputim(3),v1,v2,waltim(3),w1,w2)
             endif
          else
             call timstr(v1,w1)
             ioffset=0
             call getradon(radon(ifl,1,ioffset),p,ifl,ifh,
     1                     df,np,freq,theta(itr),cincr)
             call timend(cputim(3),v1,v2,waltim(3),w1,w2)
          endif
c___________________________________________________________________
c         take inverse Radon transform over 'noise' components.
c___________________________________________________________________
          noise=.true.
          call timstr(v1,w1)
          call radinv(u,unoise(2*(ifl-1)+1,itr),
     1                radon(ifl,1,ioffset),signal,
     1                ifl,ifh,np,noise)
         call timend(cputim(6),v1,v2,waltim(6),w1,w2)
       elseif(interpolate) then
          if(bigmem) then
             ioffset=nint((dist(itr)-xmin)/dx)+1
c_____________________________________________________________________
c            check for unsorted data and discard.
c            bad command lines have been tagged in routine rdgather.
c_____________________________________________________________________
             if(ioffset .lt. 1 .or. ioffset .gt. noffset) then
                ioffset=0
                call timstr(v1,w1)
                call getradon(radon(ifl,1,ioffset),p,ifl,ifh,
     1                     df,np,freq,theta(itr),cincr)
                call timend(cputim(3),v1,v2,waltim(3),w1,w2)
             endif
             if(verbose) write(lerr,*) 
     1          '      interpolate trace itr ',itr,ioffset
          else
             call timstr(v1,w1)
             ioffset=0
             call getradon(radon(ifl,1,ioffset),p,ifl,ifh,
     1                     df,np,freq,theta(itr),cincr)
             call timend(cputim(3),v1,v2,waltim(3),w1,w2)
          endif
c___________________________________________________________________
c         take inverse Radon transform over 'signal' components.
c___________________________________________________________________
          noise=.false.
          call timstr(v1,w1)
          call radinv(u,unoise(2*(ifl-1)+1,itr),
     1                radon(ifl,1,ioffset),signal,
     1                ifl,ifh,np,noise)
         call timend(cputim(11),v1,v2,waltim(11),w1,w2)
       endif
70000 continue
c_____________________________________________________________________
c     transform noise component back to time
c_____________________________________________________________________
      call timstr(v1,w1)
      forward=.false.
      call rmmfft(unoise(1,nsa),work,itabi,rtabi,forward,
     1            nfft,lenwork,lenitab,lenrtab,
     2            nfft,(nea-nsa+1),initffti,lerr)
      initffti=0
      call timend(cputim(7),v1,v2,waltim(7),w1,w2)
c
c
      call timstr(v1,w1)
      if(taper) then                                               
c_____________________________________________________________________
c        taper the modeled data.
c_____________________________________________________________________
         do 82000 i=0,nttaper
          xwgt=float(i)/nttaper
          do 81000 itr=nsa,nea
           unoise(1+i,itr)=xwgt*unoise(1+i,itr)
           unoise(lenwnd-i,itr)=xwgt*unoise(lenwnd-i,itr)
81000     continue
82000    continue
      endif
c
      if(wrmodel) then
c_____________________________________________________________________
c        clear and copy trace headers from input data.           
c        copy modeled data window into output model traces.
c_____________________________________________________________________
         do 80000 itr=nsa,nea
          call vclr(tbufmodel(1,itr),1,nsamp)
          call vmov(tbufdata(hbegin,itr),1,
     1              tbufmodel(hbegin,itr),1,lenhed)
          if(live(itr)) then
             call vmov(unoise(1,itr),1,tbufmodel(ist,itr),1,lenwnd_out)
          endif
80000    continue
      endif
c
      do 90000 itr=nsa,nea
       if(live(itr)) then
c_____________________________________________________________________
c         subtract multiple from original record.
c_____________________________________________________________________
          call vsub(tbufdata(ist,itr),1,unoise(1,itr),1,
     1              tbufdata(ist,itr),1,lenwnd_out)
        elseif(interpolate) then
c___________________________________________________________________
c          dead trace.
c          interpolate dead traces using the primary component of the
c          model.
c___________________________________________________________________
           call vclr(tbufdata(1,itr),1,nsamp)
           call vmov(unoise(1,itr),1,tbufdata(ist,itr),1,lenwnd_out)
        endif
c
90000 continue
      if(mute) then
c___________________________________________________________________
c        mute preservation initialization.
c___________________________________________________________________
         do 95000 jtr=1,ntr
          do 94000 isamp=1,muteend(jtr)
           tbufdata(isamp,jtr)=0.
           tbufmodel(isamp,jtr)=0.
94000     continue
95000    continue
      endif
c
      call timend(cputim(8),v1,v2,waltim(8),w1,w2)
c
      return
      end

