C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine rdgather(rbuffer,ibuffer,hbegin,nsamp,nsi,
     1     lentr2,ntr,luin,lerr,eod,irec,lenhed,
     3     live,theta,dist,zref,iend,iend0,
     4     hyperbolic,parabolic,linear,nlive,ist,
     5     interpolate,ndiscard,ninterp,wbt,ist0,
     6     nsm,nem,nsa,nea,xmin,dx,noffset,bigmem,
     7     nttaper,tscl, lenwnd_out )

      integer   hbegin, lenwnd_out
c___________________________________________________________________________
c     ibuffer and rbuffer are equivalenced by the calling arguments.
c___________________________________________________________________________
      integer   ibuffer(lentr2,ntr)
      integer   static, recnum, trcnum
      real      rbuffer(hbegin:nsamp,ntr)
      real      dist(ntr),theta(ntr)
      logical   live(ntr)
      logical   hyperbolic,parabolic,linear,eod,wbt
      logical   bigmem,interpolate

      common /thdr/ ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     1              ifmt_RecNum,l_RecNum,ln_RecNum,
     2              ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,
     3              ifmt_RecInd,l_RecInd,ln_RecInd,
     4              ifmt_DphInd,l_DphInd,ln_DphInd,
     5              ifmt_DstSgn,l_DstSgn,ln_DstSgn,
     6              ifmt_DstUsg,l_DstUsg,ln_DstUsg,
     7              ifmt_StaCor,l_StaCor,ln_StaCor,
     8              ifmt_SoPtNm,l_SoPtNm,ln_SoPtNm,
     9              ifmt_hdrwrd,l_hdrwrd,ln_hdrwrd

c
      ivalmin = 999999999
      nlive = 0
      do 10000 itr=1,ntr
       nbytes = 0
       call rtape(luin,rbuffer(hbegin,itr),nbytes)
       if(nbytes .eq. 0) then
          write(LERR,*)'End of file on input:'
          write(LERR,*)'  rec= ',irec,'  trace= ',itr
          eod=.true.
       endif

       call saver2(ibuffer(1,itr),ifmt_StaCor,l_StaCor, ln_StaCor,
     1             static , 1)
       call saver2(ibuffer(1,itr),ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1             ival , 1)
       dist(itr) = ival
       call saver2(ibuffer(1,itr),ifmt_RecNum,l_RecNum, ln_RecNum,
     1             recnum , 1)
       call saver2(ibuffer(1,itr),ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1             trcnum , 1)

       if(static .eq. 30000) then
           live(itr)=.false.
           call vclr(rbuffer(1,itr),1,nsamp)
       else
           live(itr)=.true.
           nlive=nlive+1
           if (wbt) then
              call saver2(ibuffer(1,itr),ifmt_hdrwrd,l_hdrwrd,ln_hdrwrd,
     1                    iist , 1)
              if (iabs(ival) .le. ivalmin) then
                  ivalmin = iabs(ival)
                  istmin  = float(iist) * tscl
              endif
           endif
       endif
       if(linear) then
          theta(itr)=dist(itr)
       elseif(hyperbolic) then
          theta(itr)=sqrt(zref**2+dist(itr)**2)-zref
       else
          theta(itr)=dist(itr)**2
       endif
10000 continue

      if (wbt) then
         istmin = istmin / nsi
         ist = istmin + ist0
         iwin = iend0 - ist0 + 1
         if (ist .le. 0) ist = 1

         if (ist .ge. nsamp) then
            write(LERR,*)'FATAL ERROR in rmmult water bottom option:'
            write(LERR,*)'Header start sample= ',istmin,' on min dist'
            write(LERR,*)'Resultant start sample= ',ist,' > ',nsamp
            call ccexit (666)
         endif
         
         iend = ist + iwin - 1
         
         if (iend .gt. nsamp) then
            write(LERR,*)'WARNING in rmmult water bottom option:'
            write(LERR,*)'Header start sample= ',istmin,' on min dist'
            write(LERR,*)'Resultant end sample= ',ist+iend,' > ',nsamp
            iend = nsamp
         endif

         if(nttaper.gt.(iend-ist)) then
            write(LERR,*)'FATAL ERROR in rmmult water bottom option:'
            write(LERR,*)'taper longer than window length:',nttaper
            write(LERR,*)'ist= ',ist,' iend= ',iend0,' nttaper= ',
     :           nttaper
            call ccexit (666)
         endif

c this option requires that the output number of samples changes 
c for each record as a function of the water bottom time.  The 
c lenwnd_out variable is used in the mivs.F routine as the number
c of samples to write into the output array below the ist.  As ist
c is changing here so must lenwnd_out.  The taper logic above will
c not let the window size get larger than the array.... Garossino

         lenwnd_out = iend - ist + 1
         
      else
         ist = ist0
         iend = iend0
      endif


      write(LERR,*)'Record ',recnum,'  start sample ',ist

      if(bigmem) then
c_____________________________________________________________________
c         check trace headers if bigmem option has been chosen.
c
c         assume that data that falls outside the window has not been
c         carefully sorted.
c         do not perform analysis on this trace.               
c
c         assume that data that falls unevenly within the window is a
c         user error.
c_____________________________________________________________________
         do 60000 itr=min(nsa,nsm),max(nea,nem)
          if(live(itr)) then
            ioffset=nint((dist(itr)-xmin)/dx)+1
            xnear=xmin+(ioffset-1)*dx
            if(ioffset .lt. 1) then
               write(lerr,*) 'record # ',irec,' trace # ',itr
               write(lerr,*) 'distance = ',dist(itr), ' .lt. xmin!'
               write(lerr,*) 'consider decreasing xmin'       
               ndiscard=ndiscard+1
            elseif(ioffset .gt. noffset) then
               write(lerr,*) 'record # ',irec,' trace # ',itr
               write(lerr,*) 'distance = ',dist(itr), ' .gt. xmax!'
               write(lerr,*) 'consider increasing xmax'      
               ndiscard=ndiscard+1
            elseif(abs(dist(itr)-xnear) .gt. .1*dx) then
               write(lerr,*) 'trace header distance does not fall'
     1                       //' on predefined regular grid'
               write(lerr,*) 'record # ',irec,' trace # ',itr
               write(lerr,*) 'distance = ',dist(itr), ' xnear = ',
     1                        xnear,' xmin = ',xmin,' dx = ',dx
               write(lerr,*) 'examine command line options or rerun'
     1                     //' job without the -dx and -xmin options'
               write(lerr,*) ' irregular data will take longer to'
     1                     //' process!'
               write(lerr,*) ' program aborted in routine rdgather'
               call exit(7666)
            endif
          elseif(interpolate) then
             ninterp=ninterp+1
          endif
60000  continue
      endif
c
      return
      end

