C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************c
c Changes: Mar 16, 1998 --> fixed lenwnd_out logic for waterbottom option
c                           as it needed to be reset for every trace but
c                           was not done......Garossino
c
c rmmult reads seismic trace data from an input file,
c performs forward tau-p transform in the frequency domain and
c writes the results to an output file
c
c
c**********************************************************************c
c
c     declare variables
c
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

 
      parameter (maxs=0 000 002)
      dimension s(maxs)
      pointer   (pntrs,s)

      parameter   (pi=3.1415926,twopi=2.*pi)
      parameter   (maxarg=10000)           
      parameter   (maxpat=6)                 
c
      integer     hbegin
      integer     lineheader(SZLNHD)
      integer     nsamp, nsi, ntr, nrec, iform
      integer     nsm,nem,nsa,nea
      integer lenwnd, lenwnd_out
      integer     luin ,luout,luat, lbytes, nbyptr         
      real        xmax,white
      real        pminmodel,pmaxmodel,pminnoise,pmaxnoise
      integer     ist,iend,nfft,ifl,ifh
      integer     mmin,mmax,rmin,rmax,nlive,minlive
      logical     tabled(0:maxpat)
      real        cputim(20),waltim(20)
      character*256  ntap,otap,atap,stap
      character*6    name
      character      hdrwrd * 6
      logical     verbos,bigmem,wbt
      logical     interpolate
      logical     mute
      integer     argis
      logical     taper,wrmodel,linear,parabolic,hyperbolic,eod
      logical     wrspectrum
      logical     pass

      common /thdr/ ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     1              ifmt_RecNum,l_RecNum,ln_RecNum,
     2              ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,
     3              ifmt_RecInd,l_RecInd,ln_RecInd,
     4              ifmt_DphInd,l_DphInd,ln_DphInd,
     5              ifmt_DstSgn,l_DstSgn,ln_DstSgn,
     6              ifmt_DstUsg,l_DstUsg,ln_DstUsg,
     7              ifmt_StaCor,l_StaCor,ln_StaCor,
     8              ifmt_SoPtNm,l_SoPtNm,ln_SoPtNm,
     9              ifmt_hdrwrd,l_hdrwrd,ln_hdrwrd
 
      data        name/'RMMULT'/, luat/-1/
c_______________________________________________________________
c     initialize timing arrays.
c_______________________________________________________________
      call vclr(cputim,1,20)
      call vclr(waltim,1,20)
      call timstr(vtot,wtot)
      call timstr(v1,w1)
      lastpat=0
      do 10000 ipat=0,maxpat
       tabled(ipat)=.false.
10000 continue
c_______________________________________________________________
c     read program parameters from command line card image file
c_______________________________________________________________
      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-help') .gt. 0 .or. 
     :     argis ( '-h') .gt. 0 ) then
         call help()
         call exit(0)
      endif
c_______________________________________________________________
c     open printout files
c_______________________________________________________________
#include <f77/open.h>
c_______________________________________________________________
c     get i/o data set names
c_______________________________________________________________
      call cmdln(ntap,otap,atap,stap,verbos)
c_______________________________________________________________
c     get logical unit numbers for input and output
c_______________________________________________________________
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)
      if (atap .ne. ' ') then
         call getln(luat, atap,'w', -1)
         wrmodel=.true.
      else
         wrmodel=.false.
      endif
      if(stap .ne. ' ') then
         call getln(luspec,stap,'w',-1)
         wrspectrum=.true.
      else
         wrspectrum=.false.
      endif
c_______________________________________________________________
c     read line header of input
c     save certain parameters
c_______________________________________________________________
      call rtape(luin,lineheader,lbytes)
      if(lbytes .eq. 0) then
         write(lerr,*)'RMMULT: no header read from unit ',luin
         call exit(0)
      endif
c
      call saver(lineheader, 'NumSmp', nsamp, LINEHEADER)
      call saver(lineheader, 'SmpInt', nsi  , LINEHEADER)
      call saver(lineheader, 'NumTrc', ntr , LINEHEADER)
      call saver(lineheader, 'NumRec', nrec , LINEHEADER)
      call saver(lineheader, 'Format', iform, LINEHEADER)
      call saver(lineheader, 'DptInt', dpint, LINEHEADER)
      call saver(lineheader, 'UnitSc', unitsc, LINEHEADER)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(lineheader, 'UnitSc', unitsc, LINEHEADER)
      endif
      dt = float(nsi) * unitsc
      dtmsec = 1000 * dt

      call hlhprt (lineheader,lbytes,name,6,lerr)

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('MulSkw',ifmt_MulSkw,l_MulSkw,ln_MulSkw,TRACEHEADER)
      call savelu('SoPtNm',ifmt_SoPtNm,l_SoPtNm,ln_SoPtNm,TRACEHEADER)
 
      lenhed=ITRWRD
      hbegin=1-lenhed

c_______________________________________________________________
c     read in remaining parameters from command line
c_______________________________________________________________
      call rdparm(nsi,nsamp,nrec,ntr,nsm,nem,nsa,nea,
     1            ist,iend,fl,fh,mmin,mmax,hdrwrd,wbt,
     2            np,minlive,rmin,rmax,nttaper,tscl,
     3            xmin,xmax,offmax,white,verbos,dx,bigmem,
     4            taper,linear,parabolic,hyperbolic,zref,
     5            nptaper,interpolate,pass,lerr,ierror,
     6            mute,unitsc)
      if (ierror .ne. 0) then
         write(lerR,*)'Program abort due to ,',ierror,
     1                ' command line errors'
         go to 99000
      endif

      if (wbt)
     1call savelu(hdrwrd,ifmt_hdrwrd,l_hdrwrd,ln_hdrwrd,TRACEHEADER)
      ist0  = ist
      iend0 = iend
c_______________________________________________________________
c     initialize mivs parameters
c_______________________________________________________________
      call msize (nsi,nsamp,nfft,ist,iend,lenwnd,lenwnd_out,
     1            rmin,rmax,mmin,mmax,
     2            fl,fh,ifl,ifh,nf,nfmax,
     3            pminmodel,pmaxmodel,np,
     4            pminnoise,pmaxnoise,
     5            linear,parabolic,hyperbolic,zref,
     5            offmax,factor,lerr,dt,wbt)
c______________________________________________________________________
c     calculate buffer requirements for nested mixed radix ffts.
c     cray scilib routine rfftmlt runs twice as fast as mathadvantage
c     routine rnfftm.
c
c     buffer   mathadvantage rnfftm        cray scilib rfftmlt
c
c     itab      nfft+34                      2*nfft
c     rtab      3(nfft/2)+13                 2*nfft
c     work      18*ntr                       4*nfft*ntr
c______________________________________________________________________
      if(szsmpd .eq. 4) then
         lenitab=nfft+34
         lenrtab=3*(nfft/2)+13
         lenwork=18*ntr
      else
         lenitab=max(2*nfft,nfft+34)
         lenrtab=max(2*nfft,3*(nfft/2)+13)
         lenwork=max(4*(ntr+1)*nfft,18*ntr)
      endif
      if(bigmem) then
c___________________________________________________________________
c        assume xmax read in explicitly (and correctly)
c        assume xmin may have been defaulted to zero
c____________________________________________________________________
         noffset=nint((xmax-xmin)/dx)+1
         xmin=xmax-(noffset-1)*dx
         lenradon=2*nf*np*(noffset+1)
      else
         noffset=0
         lenradon=2*nf*np
      endif
C_______________________________________________________________________
c     output of all pertinent information before
c     memory allocation
C_______________________________________________________________________
      write(lerR,*)' '
      write(lerR,*)' line header values after default check '
      write(lerR,*)' '
      if(linear) then
         write(lerr,*) 'fit data with LINEAR curves'
      elseif(parabolic) then
         write(lerr,*) 'fit data with PARABOLIC curves'
      elseif(hyperbolic) then
         write(lerr,*) 'fit data with HYPERBOLIC curves'
         write(lerr,*) ' reference depth      = ',zref
      endif
      write(lerr,*)
      write(lerR,*) ' input data set name   =  ', ntap
      write(lerR,*) ' output data set name  =  ', otap
      write(lerR,*) ' multiple output file  =  ', atap
      write(lerR,*) ' # of samples/trace    =  ', nsamp
      write(lerR,*) ' sample interval       =  ', nsi
      write(lerR,*) ' traces per record     =  ', ntr
      write(lerR,*) ' records per line      =  ', nrec
      write(lerR,*) ' format of data        =  ', iform
      write(lerR,*)' '
      write(lerR,*) ' start freq index      =  ', ifl
      write(lerR,*) ' end freq index        =  ', ifh
      write(lerR,*) ' computation freq      =  ', nf
      write(lerR,*) ' fft freq              =  ', nfmax
      write(lerR,*) ' length of FFT         =  ', nfft
      write(lerR,*)' '
      write(lerR,*) ' first model param     =  ', pminmodel
      write(lerR,*) ' last model param      =  ', pmaxmodel
      write(lerR,*) ' first noise param     =  ', pminnoise
      write(lerR,*) ' last noise param      =  ', pmaxnoise
      write(lerR,*) ' number of param       =  ', np
      write(lerR,*) ' taper length in param =  ', nptaper
      write(lerr,*)
      write(lerR,*) ' start trc of model    =  ', nsm
      write(lerR,*) ' end   trc of model    =  ', nem
      write(lerR,*) ' start trc of atten    =  ', nsa
      write(lerR,*) ' end   trc of atten    =  ', nea
      write(lerR,*)' '
      write(lerR,*) ' prewhitening          =  ', white
      write(lerR,*) ' length taper (pts)    =  ', nttaper
      if (wbt) then
      write(lerR,*) ' Using water bottom header word start time'
      write(lerR,*) ' water bottom time scaler =  ',tscl
      endif
      write(lerR,*) ' starting sample       =  ', ist
      write(lerR,*) ' ending sample         =  ', iend
      write(lerR,*) ' big memory?           =  ', bigmem
      write(lerR,*) ' xmin                  =  ', xmin
      write(lerR,*) ' xmax                  =  ', xmax
      write(lerR,*) ' number of tabled offsetsi = ',noffset
      write(lerR,*) ' max absolute offset   =  ', offmax
      write(lerR,*) ' interpolate dead traces? ',interpolate
      write(lerR,*) ' pass noise?              ',pass       
      write(lerR,*) ' preserve early mute?     ',mute       
      if(bigmem) then
         write(lerR,*) ' dx                 =  ', dx
      endif
      write(lerR,*)' '
c______________________________________________________________________
c     calculate memory requirements
c______________________________________________________________________
      write(lerr,'(///,80a1)') ('_',i=1,80)
      write(lerr,'(A)')'storage map of major arrays'
      write(lerr,'(80a1)') ('_',i=1,80)
C
      l_free=1
      lenbuf=ntr*(nsamp+lenhed)
c____________________________________________________________________
      write(lerr,'(a20,3a10)')'variable name','begin','end','length'
      call mapmem('tbufdata',l_tbufdata,l_free,lenbuf,lerr)
      call mapmem('tbufmodel',l_tbufmodel,l_free,lenbuf,lerr)
      call mapmem('tracebuf',l_tracebuf,l_free,lenhed+2*nfft,lerr)
      call mapmem('theta',l_theta,l_free,ntr,lerr)
      call mapmem('dist',l_dist,l_free,ntr,lerr)
      call mapmem('distpat',l_distpat,l_free,ntr*(maxpat+1),lerr)
      call mapmem('muteend',l_muteend,l_free,ntr,lerr)
      call mapmem('live',l_live,l_free,ntr,lerr)
      call mapmem('unoise',l_unoise,l_free,nfft*(nea-nsa+1),lerr)
      call mapmem('radon',l_radon,l_free,lenradon,lerr)
      call mapmem('cincr',l_cincr,l_free,2*np,lerr)
      call mapmem('udata',l_udata,l_free,nfft*(nem-nsm+1),lerr)
      call mapmem('rtabf',l_rtabf,l_free,lenrtab,lerr)
      call mapmem('itabf',l_itabf,l_free,lenitab,lerr)
      call mapmem('rtabi',l_rtabi,l_free,lenrtab,lerr)
      call mapmem('itabi',l_itabi,l_free,lenitab,lerr)
      call mapmem('work',l_work,l_free,lenwork,lerr)
      call mapmem('rtrans',l_rtrans,l_free,2*nf*np,lerr)
      call mapmem('a',l_a,l_free,2*nf*np*(maxpat+1),lerr)
      call mapmem('u',l_u,l_free,2*nf*np,lerr)
      call mapmem('s',l_s,l_free,2*nf*np,lerr)
      call mapmem('v',l_v,l_free,2*nf,lerr)
      call mapmem('r',l_r,l_free,2*nf,lerr)
      call mapmem('rc',l_rc,l_free,2*nf,lerr)
      call mapmem('e',l_e,l_free,2*nf,lerr)
      call mapmem('ec',l_ec,l_free,2*nf,lerr)
      call mapmem('temp',l_temp,l_free,2*nf,lerr)
      call mapmem('rnorm',l_rnorm,l_free,nf,lerr)
      call mapmem('freq',l_freq,l_free,nf,lerr)
      call mapmem('p',l_p,l_free,np,lerr)
      call mapmem('wgt',l_wgt,l_free,np,lerr)
      call mapmem('delt',l_delt,l_free,np,lerr)
      call mapmem('signal',l_signal,l_free,np,lerr)
C_______________________________________________________________________
C     allocate dynamic memory.
C_______________________________________________________________________
      lens=l_free-1
      write(lerr,'(a20,10x,i10)') 'total vector length',lens
      call galloc(pntrs,lens*szsmpd,ierrcd,0)
      if(ierrcd .ne. 0 ) then
         write(lerr,*)'galloc memory allocation error from main'
         write(lerr,*)'ierrcd = ',ierrcd
         write(lerr,*)
         write(lerr,*)'probable cause: too much memory requested!'
         if(bigmem) then
            write(lerr,*) 'take the big memory -dx option off your'//
     1                   ' command line!'
         endif
         write(lerr,*)'go check your seismic headers and command'//
     1                ' line arguments!'
         write(lerr,*)
         write(lerr,*)'program RMMULT aborted'
         call exit(101)
      endif
C_______________________________________________________________________
c     modify line header to reflect actual number of traces output
C_______________________________________________________________________
      call savew(lineheader,'NumRec',nrec,LINEHEADER)
      call savew(lineheader,'NumTrc',ntr,LINEHEADER)
      call savew(lineheader,'OrNTRC',ntr,LINEHEADER)
      call savhlh(lineheader,lbytes,lbyout)
      call wrtape(luout,lineheader,lbyout)
      if(wrmodel) then 
         call wrtape(luat,lineheader,lbyout)
      endif
      if(wrspectrum) then
         call savew(lineheader,'NumTrc',np,LINEHEADER)
         call savew(lineheader,'NumSmp',nfft,LINEHEADER)
         call wrtape(luspec,lineheader,lbyout)
      endif
      call timend(cputim(1),v1,v2,waltim(1),w1,w2)
c_______________________________________________________________
c     precompute tabled arrays that will be remain invariant for all
c     seismic gathers.
c_______________________________________________________________
      call gettab(s(l_freq),s(l_p),s(l_wgt),s(l_delt),df,dp,nf,np,
     1            pi,twopi,ifl,ifh,
     2            minpnoise,maxpnoise,pminnoise,pmaxnoise,
     3            pminmodel,pmaxmodel,nptaper,
     4            nfft,s(l_signal),pass, 
     5            s(l_radon),s(l_cincr),noffset,
     6            linear,parabolic,hyperbolic,zref,
     7            xmin,xmax,dx,factor,bigmem,lerr,cputim,waltim)
c_____________________________________________________________   
c     calculate length of trace in integer*2 words.
c     calculate number of bytes in output trace
c     calculate trace header position of key variables.
c_____________________________________________________________   
      lentr2=(lenhed+nsamp)
      nbyptr=(nsamp+lenhed)*szsmpd
      nbytes_spec=(2*nfft+lenhed)*szsmpd
c     call savelu('DstSgn',ifmt,l_dstsgn,length,TRACEHEADER)
c     call savelu('StaCor',ifmt,l_StaCor,length,TRACEHEADER)
c     call savelu('TrcNum',ifmt,l_TrcNum,length,TRACEHEADER)
c     call savelu('RecNum',ifmt,l_RecNum,length,TRACEHEADER)
c_____________________________________________________________   
c     zero out modeled trace.
c_____________________________________________________________   
      call clrgather(s(l_tbufmodel),hbegin,nsamp,ntr)
      initfftf=1
      initffti=1
      ndiscard=0
      ninterp=0
      ndeadrec=0
c_____________________________________________________________   
c     loop over all records.
c_____________________________________________________________   
      do 20000 irec = 1, nrec
       call rdgather(s(l_tbufdata),s(l_tbufdata),hbegin,nsamp,nsi,
     1        lentr2,ntr,luin,lerr,eod,irec,lenhed,
     3        s(l_live),s(l_theta),s(l_dist),zref,iend,iend0,
     4        hyperbolic,parabolic,linear,nlive,ist,
     5        interpolate,ndiscard,ninterp,wbt,ist0,
     6        nsm,nem,nsa,nea,xmin,dx,noffset,bigmem,
     7        nttaper,tscl,lenwnd_out )
       if(eod) go to 99000
c
       if(nlive .ge. minlive) then
c_____________________________________________________________   
c         go filter the data.
c_____________________________________________________________   
          call mivs(s(l_tbufdata),s(l_tbufmodel),hbegin,nsamp,
     1              s(l_unoise),nfft,s(l_theta),nttaper,  
     2              s(l_dist),xmin,dx,bigmem,noffset,
     3              s(l_live),np,ifl,ifh,irec,lenhed,
     4              s(l_a),s(l_rtrans),s(l_u),s(l_rnorm),s(l_wgt),
     5              s(l_v),s(l_r),s(l_e),s(l_ec),s(l_temp),s(l_rc),
     6              s(l_s),s(l_freq),s(l_p),s(l_udata),
     7              dp,minpnoise,maxpnoise,interpolate,
     8              s(l_radon),s(l_cincr),white,df,
     9              ist,iend,lenwnd,lenwnd_out,nsm,nem,nsa,nea,ntr,
     a              s(l_rtabf),s(l_itabf),initfftf,s(l_work),         
     b              s(l_rtabi),s(l_itabi),initffti,tabled,lastpat,
     c              lenrtab,lenitab,lenwork,s(l_distpat),maxpat,
     d              nlive,taper,wrmodel,s(l_signal),pass,
     e              s(l_muteend),mute,lerr,cputim,waltim,verbos,
     f              s(l_tracebuf),s(l_delt),nbytes_spec,luspec,
     g              wrspectrum,l_trcnum,l_dstsgn,l_recnum)
       else
c_____________________________________________________________   
c         zero out modeled trace.
c_____________________________________________________________   
          ndeadrec=ndeadrec+1
          write(lerr,*) 'record ',irec,' has only ',nlive,
     1                   ' live traces. bypass processing'
          call clrgather(s(l_tbufmodel),hbegin,nsamp,ntr)
       endif
c_____________________________________________________________   
c      write out data.         
c_____________________________________________________________   
       call timstr(v1,w1)
       call wrgather(s(l_tbufdata),hbegin,nsamp,
     1               ntr,luout,nbyptr)
       if(wrmodel) then
          call wrgather(s(l_tbufmodel),hbegin,nsamp,
     1                  ntr,luat,nbyptr)
       endif
       call timend(cputim(9),v1,v2,waltim(9),w1,w2)
       if (verbos)
     1 write(LER,*)'Completed sequential record ',irec
20000 continue
99000 continue
c_____________________________________________________________   
c     write out timing statistics.
c_____________________________________________________________   
      call timend(cputim(20),vtot,V2,waltim(20),wtot,W2)
      write(lerr,'(A30,2A15,/)') 'routine','cpu time','wall time'
      write(lerr,'(A30,2f15.3)')
     1         'setup',cputim(1),waltim(1),
     2         'forward fft',cputim(2),waltim(2),
     3         'calculate radon',cputim(3),waltim(3),
     4         'forward radon',cputim(4),waltim(4),
     5         'form normal eqns',cputim(10),waltim(10),
     6         'invert normal eqns',cputim(5),waltim(5),
     7         'inverse radon',cputim(6),waltim(6),
     8         'interpolate dead traces',cputim(11),waltim(11),
     9         'inverse fft',cputim(7),waltim(7),
     a         'vsub',cputim(8),waltim(8),
     b         'write output',cputim(9),waltim(9),
     c         'total',cputim(20),waltim(20)
c_____________________________________________________________   
c     close data files
c_____________________________________________________________   
      call lbclos ( luin )
      call lbclos ( luout )
      if(wrmodel) call lbclos (luat)
      if(wrspectrum) call lbclos (luspec)

      write(lerr,*)'end of rmmult, processed',nrec,' record(s)',
     :            ' with ',ntr, ' traces'
      write(lerr,*)'number of traces outside (xmin,xmax) window  = ',
     1              ndiscard     
      write(lerr,*)'number of interpolated traces = ',ninterp      
      write(lerr,*)'number of mostly dead records = ',ndeadrec     
      write(lerR,*)'end of rmmult, processed',nrec,' record(s)',
     :            ' with ',ntr, ' traces'
      write(lerR,*)'number of traces outside (xmin,xmax) window  = ',
     1              ndiscard
      write(lerR,*)'number of interpolated traces = ',ninterp
      write(lerR,*)'number of mostly dead records = ',ndeadrec
      close(lerr)
      call exit(0)
      end
 
C***********************************************************************
 

      subroutine cmdln( ntap, otap, atap,stap, verbos)

      character*(*)  ntap,otap,atap,stap
      integer    argis
      logical    verbos

      call argstr('-N',ntap, ' ', ' ')
      call argstr('-O',otap, ' ', ' ')
      call argstr('-A',atap, ' ', ' ')
      call argstr('-S',stap, ' ', ' ')
      verbos = (argis('-V') .gt. 0)

      return
      end

      subroutine help
#include <f77/iounit.h>

         write(ler,*)
     1'***************************************************************'
       write(ler,*)' '
        write(ler,*)
     1'execute rmmult by typing rmmult and  list of program parameters.'
        write(ler,*)
     1'note that each parameter is proceeded by -a where "a" is '
        write(ler,*)
     1'a character(s) corresponding to some parameter.'
        write(ler,*)
     1'users enter the following parameters, or use the default values'
       write(ler,*)' '
        write(ler,*)
     1' -N [ntap]  (stdin)   : input data file name'
        write(ler,*)
     1' -O [otap]  (stdout)  : output data file name'
        write(ler,*)
     1' -A [atap]  (optional): rejected noise file name'  
        write(ler,*)
     1' -S [atap]  (optional): model spectrum file name'  
        write(ler,*)
     1' -s[ist]    (1st samp) :  start of processing window (ms)'
        write(ler,*)
     1' -e[iend]   (last samp):  end of processing window (ms)'
        write(ler,*)
     1' -hw[hdrwrd] (ignore)  :  start time header word (min offset)'
        write(ler,*)
     1' -tscl[tscl] (2)       :  start time scale factor'
        write(ler,*)
     1' -fl[ifl]   (5)        :  start frequency (Hz)'
        write(ler,*)
     1' -fh[ifh]   (Nyquist)  :  end frequency (Hz)'
        write(ler,*)
     1' -xmin[xmin](0.0)      :  min signed distance (ft,m) to be'
     2                                //'MODELED'
        write(ler,*)
     1' -xmax[xmax](none)     :  max signed distance (ft,m) to be'
     2                                //'MODELED'
        write(ler,*)
     1' -dx[dx]  (undefined)  : common shot seismic group '
     2                           //'interval (ft,m)'
        write(ler,*)
     1'                 (-dx triggers a more efficient big memory run)'
        write(ler,*)' '
        write(ler,*) '_________________________________________________'
     1               //'___________________'
        write(ler,*)'the following 4 parameters are defined at '//        
     1              'x=max(-xmin,+xmax) :'
        write(ler,*) '_________________________________________________'
     1               //'___________________'
        write(ler,*)
     1' -mmin[mmin]   (0)   :  minimum moveout to be MODELED (ms)'
        write(ler,*)
     1' -mmax[mmax]   (none):  maximum moveout to be MODELED (ms)'
        write(ler,*)
     1' -rmin[rmin]   (mmin):  minimum moveout to be REJECTED (ms)'
        write(ler,*)
     1' -rmax[rmax]   (mmax):  maximum moveout to be REJECTED (ms)'
        write(ler,*)
     1' -np[np]       (Nyquist):  number of parameters/curves '
        write(ler,*)
     1'                             used to span MODELED space'   
c____________________________________________________________________
c       marfurt hasn't been able to get the following option to work.
c       let's hide it for now.
c____________________________________________________________________
c       write(ler,*)
c    1' -ptaper[nptaper] (def= 0)  :  number of parameters/curves'
c    2                               //' in taper'
c____________________________________________________________________
c       marfurt HATES the following 4 options, since they are only
c       meaningful for data that have been run through disort.
c       let's hide them and see if anyone complains!
c____________________________________________________________________
c       write(ler,*)
c    1' -nsm[nsm]      (1)    :  starting trace to be MODELED'
c       write(ler,*)
c    1' -nem[nem]      (last) :  ending trace to be MODELED'
c       write(ler,*)
c    1' -nsa[nsa]      (1)    :  starting trace for noise REJECT' 
c       write(ler,*)
c    1' -nea[nea]      (last) :  ending trace for noise REJECT'
        write(ler,*)
     1' -prew[white]   (5.0)  :  % prewhitening for inverse'
        write(ler,*)
     1' -live[nlive]   (1)    :  minimum # live traces required'
        write(ler,*)
     1' -ttaper[nttaper] (0)  :  length (ms) of temporal taper'
        write(ler,*)' '
        write(ler,*)
     1' -L                         : fit data with linear curves'  
        write(ler,*)
     1' -P             (default)   : fit data with parabolic curves'  
        write(ler,*)
     1' -H                         : fit data with hyperbolic curves'  
        write(ler,*)
     1' -zref          (xmax)      : reference depth for hyperbolae'   
        write(ler,*)
     1' -pass                      :  if present, pass noise curves'
     2                               //' reject signal'
        write(ler,*)
     1' -I                         :  if present, interpolate dead'
     2                               //' traces'
        write(ler,*)
     1' -mute                      :  if present, preserve early mute'
        write(ler,*)
     1' -V                         :  if present, verbose printout'
       write(ler,*)' '
       write(ler,*)'usage:'
       write(ler,*)
       write(ler,*)'rmmult -N[ntap] -O[otap] -A[atap] -S[stap]'
       write(ler,*)'       -s[] -e[] -hw[] -tscl[] -ttaper[] -fl[]'
       write(ler,*)'       -fh[] -mmin[] -mmax[] -rmin[] -rmax[] -np[]'
       write(ler,*)'       -xmin[] -xmax[] -dx[] -zref[]    '
       write(ler,*)'       -prew[] -live[]'
       write(ler,*)'       [ -L -P -H -I -V -pass -mute]'
       write(ler,*)' '
       write(ler,*)
     1'***************************************************************'

      return
      end
 

