C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************c

c Changes:

c
c rnmo reads seismic (MBS depth migrated CRPs) trace data from an input file,
c and applies a gamma-dependent NMO and
c writes the results to an output file
c
c
c**********************************************************************c
c
c     declare variables
c
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
 
      integer     itr ( 2*SZLNHD )
      integer     lhed( 2*SZLNHD )
      integer     vtr ( 2*SZLNHD )
      integer     vhed( 2*SZLNHD )

      integer     nsamp, nsi, ntrc, nrec, iform,obytes
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     JJ, KK , errcd, abort
      integer     argis, pipe
      integer     ifmt_RecNum, l_RecNum, ln_RecNum, RecNum
      integer     ifmt_DstSgn, l_DstSgn, ln_DstSgn, DstSgn
      integer     ifmt_StaCor, l_StaCor, ln_StaCor, StaCor
      integer     ifmt_LinInd, l_LinInd, ln_LinInd, LinInd
      integer     ifmt_DphInd, l_DphInd, ln_DphInd, DphInd
      integer     irecg, itrcg

      real        sii, offset

      real        tri, xtr, v_trace, work
      pointer     (wkwork   , work   (10000000))
      pointer     (wktri    , tri    (10000000))
      pointer     (wkxtr    , xtr    (10000000))
      pointer     (wkv_trace, v_trace(10000000))

      character   ntap * 256, otap * 256, vtap * 256, name*4

      logical     remove, verbos, heap
 
      equivalence ( itr(  1), lhed(1) )
      equivalence ( vtr(  1), vhed(1) )

      data  lbytes /0/
      data  nbytes /0/
      data  abort /0/
      data  name /'RNMO'/
      DATA  pipe/3/

c get command line help if requested

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif
 
c open printout files

#include <f77/open.h>

c parse command line
 
      call gcmdln ( ntap, otap, vtap, siscl, giscl, remove, verbos)

c check for extraneous arguments and abort if found

      call xtrarg ( name, LER, .FALSE., .FALSE. )
      call xtrarg ( name, LERR, .FALSE., .TRUE. )

c get logical unit numbers for input and output

      call getln ( luin , ntap, 'r', 0 )
      call getln ( luout, otap, 'w', 1 )

      if (vtap .ne. ' ') then
          call getln(luvel, vtap, 'r',-1)
      else
          write(LERR,*)'anmo assumed to be running inside IKP'
          call sisfdfit (luvel, pipe)
      endif
      if(luvel .lt. 0)   then
         write(lerr,*)'rnmo error: gamma file -G not accessible'
      endif

c read line header of input
c save certain parameters

      vflag=1
      lbytes=0
      call rtape ( luin, itr, lbytes )
      if(lbytes .eq. 0) then
         write(LOT,*)'RNMO: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that
c     refers to the trace header
 
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

c_____________________________________________________________________
c     read in gamma worktape line header.
c_____________________________________________________________________
      call rtape ( luvel, vtr, lvbytes )
      if(lvbytes .eq. 0) then
         write(LOT,*)'RNMO: no header read from unit ',luvel
         write(LOT,*)'FATAL'
         stop
      endif
 
      call saver(vtr, 'NumSmp', nsampv, LINHED)
      call saver(vtr, 'SmpInt', nsiv  , LINHED)
      call saver(vtr, 'NumTrc', ntrcv , LINHED)
      call saver(vtr, 'NumRec', nrecv , LINHED)
      call saver(vtr, 'Format', iformv, LINHED)
      call saver(vtr, 'T_Unit', iscl  , LINHED)

      if (nsi .ne. nsiv) then
        write(LERR,*)'FATAL ERROR from rnmo:'
        write(LERR,*)'Sample interval of input data and input gamma'
        write(LERR,*)'traces (',nsi,nsiv,') are not same.'
        write(LER ,*)'FATAL ERROR from rnmo:'
        write(LER ,*)'Sample interval of input data and input gamma'
        write(LER ,*)'traces (',nsi,nsiv,') are not same.'
        call ccexit (666)
      endif
      if (iscl .eq. 0 .AND. giscl .eq. 0.0) then
        write(LERR,*)'WARNING FROM rnmo:'
        write(LERR,*)'Line Header gamma scaler was zero. Also there'
        write(LERR,*)'was no cmd line scale factor given. Will set'
        write(LERR,*)'scaler to 1. Be sure that gammas in input data'
        write(LERR,*)'vary around 1.0'
        write(LER ,*)'WARNING FROM rnmo:'
        write(LER ,*)'Line Header gamma scaler was zero. Also there'
        write(LER ,*)'was no cmd line scale factor given. Will set'
        write(LER ,*)'scaler to 1. Be sure that gammas in input data'
        write(LER ,*)'vary around 1.0'
        iscl = 1
      endif
      if (giscl .gt. 0.0) then
          scl = 1.0 / giscl
          iscl = giscl
      else
          scl = 1.0 / float (iscl)
      endif

c_____________________________________________________________________
c     vflag=0 single gamma function
c     vflag=1 multiple gamma function
c_____________________________________________________________________
      if (ntrcv*nrecv .le. 1) vflag=0


c print historical line header to printout file

      call hlhprt (itr, lbytes, name, 4, LERR)

      if (siscl .gt. 0.0) then
          sii = siscl * float (nsi)
      else
          sii = float (nsi)
      endif


         write(LERR,*)' '
         write(LERR,*)' Values read from input seismic worktape'
         write(LERR,*)' # of Samples/Trace =  ',nsamp
         write(LERR,*)' Sample Interval    =  ',nsi
         write(LERR,*)' Traces per Record  =  ',ntrc
         write(LERR,*)' Records per Line   =  ',nrec
         write(LERR,*)' Format of Data     =  ',iform
         if (vflag .eq. 0) then
            write(LERR,*)' Single gamma function will be used'
         endif
         if (remove)write(LERR,*)' Remove normal moveout'
         write(LERR,*)' Values read from gamma worktape '
         write(LERR,*)' # of Samples/Trace =  ',nsampv
         write(LERR,*)' Sample Interval    =  ',nsiv
         write(LERR,*)' Traces per Record  =  ',ntrcv
         write(LERR,*)' Records per Line   =  ',nrecv
         write(LERR,*)' Format of Data     =  ',iformv
         write(lerr,*)' input data unit  luin  = ',luin
         write(lerr,*)' output data unit luout = ',luout
         write(lerr,*)' gamma unit    luvel    = ',luvel
         write(lerr,*)' gamma scale factor     =  ',iscl
         write(lerr,*)' Input S.I. scaler      =  ',siscl
         write(LERR,*)' '

      if (nsampv .lt. nsamp) then
          write(lerr,*)'gamma trace(s) too short; contains ',nsampv,
     1                  ' samples'
          write(lerr,*)'orig input data contains ',nsamp,' samples'
          write(lerr,*)'rerun gamma create job so that trace at least ',
     1                  nsi*nsamp,' ms long'
         call exit(2666)
      endif

      heap = .true.
      item = max (nsamp,nsampv) * SZSMPD

      call galloc (wkv_trace, item, errcd, abort)
      if (errcd .ne. 0)  heap = .false.
      call galloc (wkwork   , item, errcd, abort)
      if (errcd .ne. 0)  heap = .false.
      call galloc (wktri    , item, errcd, abort)
      if (errcd .ne. 0)  heap = .false.
      call galloc (wkxtr    , item, errcd, abort)
      if (errcd .ne. 0)  heap = .false.

      if (.not. heap) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) item,'  bytes'
         write(LERR,*) item,'  bytes'
         write(LERR,*) item,'  bytes'
         write(LERR,*) item,'  bytes'
         write(LER ,*)' '
         write(LER ,*)'FATAL ERROR rnmo: Unable to allocate workspace:'
         write(LER ,*) item,'  bytes'
         write(LER ,*) item,'  bytes'
         write(LER ,*) item,'  bytes'
         write(LER ,*) item,'  bytes'
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) item,'  bytes'
         write(LERR,*) item,'  bytes'
         write(LERR,*) item,'  bytes'
         write(LERR,*) item,'  bytes'
      endif


c update historical line header

      call savhlh ( itr,lbytes,lbyout )

c write output lineheader

      call wrtape ( luout, itr, lbyout )

c calculate number of output bytes per trace

      obytes = SZTRHD + nsamp * SZSMPD

c echo pertinent information to printout file

c BEGIN PROCESSING

c
c ----- single gamma function -----
c
 
      if(vflag .eq. 0) then
 
         nvbytes=0
         call rtape(luvel,vtr,nvbytes)
         if(nvbytes .eq. 0) then
            write(LERR,*)' '
            write(LERR,*)'RNMO: No gamma data found after '
            write(LERR,*)'       lineheader in ',vtap,' check '
            write(LERR,*)'       velin run thoroughly.'
            write(LERR,*)'FATAL'
            write(LER,*)' '
            write(LER,*)'RNMO: No gamma data found after '
            write(LER,*)'       lineheader in ',vtap,' check '
            write(LER,*)'       velin run thoroughly.'
            write(LER,*)'FATAL'
            goto 999
         endif
         call vsmul (vtr(ITHWP1), 1, scl, v_trace, 1, nsampv)
 
         if(verbos) then
            write(LERR,*)'gamma'
            write(LERR,777)(v_trace(i),i=1,nsampv)
 777        format(10f8.2)
         endif
c
c ----- check for valid velocities -----
c
 
         call dotpr (v_trace, 1, v_trace, 1, vdot, nsampv)
         if (abs(vdot) .lt. 1.e-06) then
            write(LERR,*)' '
            write(LERR,*)'RNMO: gamma trace contains zeros'
            write(LERR,*)'       Check the velin step thoroughly'
            write(LERR,*)'FATAL '
            write(LER,*)' '
            write(LER,*)'RNMO: gamma trace contains zeros'
            write(LER,*)'       Check the velin step thoroughly'
            write(LER,*)'FATAL '
            go to 999
         endif
 
 
      endif

      
c process all record and traces input

      DO  JJ = 1, nrec

c---
c For multiple gamma functions read gamma trace each time we read a gather
c---
         if (vflag .eq. 1) then
            nvbytes = 0
            call rtape (luvel, vtr, nvbytes)
            if (nvbytes .eq. 0) then
               write(LERR,*)' '
               write(LERR,*)'RNMO: Premature EOF on gamma Dataset'
               write(LERR,*)'       at sequential record number ',JJ
               write(LERR,*)'FATAL'
               write(LER,*)' '
               write(LER,*)'RNMO: Premature EOF on gamma Dataset'
               write(LER,*)'       at sequential record number ',JJ
               write(LER,*)'FATAL'
               goto 999
            endif
            call saver2(vtr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1           irecg, TRACEHEADER)
            call saver2(vtr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1           itrcg, TRACEHEADER)
            call vsmul (vtr(ITHWP1), 1, scl, v_trace, 1, nsampv)
c
c ----- check for valid data -----
c
            call dotpr (v_trace, 1, v_trace, 1, vdot, nsampv)
 
            if (abs(vdot) .lt. 1.e-06) then
               write(LERR,*)' '
               write(LERR,*)'RNMO: gamma trace contains zeros'
               write(LERR,*)'       Check the velin step thoroughly'
               write(LERR,*)'FATAL '
               write(LER,*)' '
               write(LER,*)'RNMO: gamma trace contains zeros'
               write(LER,*)'       Check the velin step thoroughly'
               write(LER,*)'FATAL '
               go to 999
            endif
 
         endif

         DO  KK = 1, ntrc

            nbytes = 0
            call rtape( luin, lhed, nbytes)
            if(nbytes .eq. 0) then
               write(LERR,*)'End of file on input:'
               write(LERR,*)'  rec= ',JJ,'  trace= ',KK
               go to 999
            endif

            call saver2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1           StaCor, TRACEHEADER)
            call saver2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1           recnum, TRACEHEADER)
            call saver2(lhed,ifmt_LinInd,l_LinInd, ln_LinInd,
     1           linind, TRACEHEADER)
            call saver2(lhed,ifmt_DphInd,l_DphInd, ln_DphInd,
     1           dphind, TRACEHEADER)
            call saver2(lhed,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1           dstsgn, TRACEHEADER)

            offset = dstsgn

c process only live traces

            IF ( StaCor .ne. 30000) then

                call vmov (lhed(ITHWP1), 1, tri, 1, nsamp)

                call ganmo (tri, v_trace, offset, nsamp, sii, xtr,
     1                      work, remove)

                call vmov (xtr, 1, lhed(ITHWP1), 1, nsamp)
               
            ELSE

c clear all traces marked as dead

                call vclr (lhed(ITHWP1), 1, nsamp)

            ENDIF

c  write output data

            call wrtape (luout, lhed, obytes)

         ENDDO

         if ( verbos ) then
            write(LERR,*)'processed rec ',recnum, '  LI/DI = ',
     1      linind, dphind,' using gamma trace ',irecg,itrcg
         endif
 
      ENDDO

c Normal Termination: close data files
      
      call lbclos ( luin )
      call lbclos ( luout )

      write(LERR,*)'end of RNMO, processed',nrec,' record(s)',
     :     ' with ',ntrc, ' traces'
      write(LERR,*)' '
      write(LERR,*)'Normal Termination'
      write(LER,*)' '
      write(LER,*)'RNMO: Normal Termination'

      stop

  999 continue

      call lbclos ( luin )
      call lbclos ( luout )

      write(LERR,*)'end of RNMO, processed',JJ,' record(s)',
     :     ' with ',ntrc, ' traces'
      write(LERR,*)' '
      write(LERR,*)'Abnormal Termination'
      write(LER,*)' '
      write(LER,*)'RNMO: Abnormal Termination'
      stop
      end
 
C SUBROUTINES help, gcmdln, verbos

      subroutine help

#include <f77/iounit.h>

      write(LER,*)' '
      write(LER,*)'===================================================='
      write(LER,*)' '
      write(LER,*)' Command Line Arguments for rnmo: interpolate / dec
     :imate data'
      write(LER,*)'  '
      write(LER,*)' For a more detailed description of these parameters'
      write(LER,*)' see the online man page using uman, xman or xuspman'
      write(LER,*)' '
      write(LER,*)'Input...................................... (def)'
      write(LER,*)' '
      write(LER,*)'-N[]    -- input data set                  (stdin)'
      write(LER,*)'-O[]    -- output data set                (stdout)'
      write(LER,*)'-v[]    -- gamma data set                   (none)'
      write(LER,*)'-tscl[] -- input sample interval scaler      (1.0)'
      write(LER,*)'-gscl[] -- gamma value scale factor          (1.0)'
      write(LER,*) ' '
      write(LER,*)
     :' -R  include on command line to remove moveout'
      write(LER,*)
     :' -V  include on command line if verbose printout is desired'
      write(LER,*) ' '
      write(LER,*)
     :'usage:   rnmo -N[] -O[] -v[] [ -tscl[] -gscl[] ] -R -V'
      write(LER,*)' '
      write(LER,*)'===================================================='
      
      return
      end

c subroutine to parse command line
 
      subroutine gcmdln ( ntap, otap, vtap, siscl, giscl, remove, 
     1                    verbos)

c-----
c     get command arguments
c
c     ntap  - C*256     input file name
c     otap  - C*256     output file name
c     sii   - R*4       input sample interval override
c     sio   - R*4       output sample interval
c     nso   - I*4       output sample interval header override
c     micro -  L        convert input s.i. to micro secs
c     verbos -  L       verbose output or not
c     cube - L          use cubic spline interpolation
c     sinc - L          use sinc interpolation
c     nsinc -I*4        number of points in sinc interpolator
c     four - L          use Fourier interpolation
c     cubef - L         use cubic spline interpolation with post interpolation filter
c     linear - L        use linear interpolation
c
c-----

#include <f77/iounit.h>

c variables passed from calling routine

      character   ntap*(*), otap*(*), vtap*(*)
      real        siscl, giscl
      logical     remove, verbos

c local variables

      integer argis
 

            call argstr( '-N', ntap, ' ', ' ' )

            call argstr( '-O', otap, ' ', ' ' )

            call argstr( '-v', vtap, ' ', ' ' )
 
            call argr4 ( '-tscl',siscl, 0.0, 0.0)
            call argr4 ( '-gscl',giscl, 0.0, 0.0)

            remove = (argis('-R') .gt. 0)
            verbos = (argis('-V') .gt. 0)

 
      return
      end
