C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
c does simple trace header word renumbering and
c writes the results to an output file
 
c It is assumed that the development location has afp - Amoco Fortran
c Preprocessor
c
c
c**********************************************************************c
c
c     declare variables
c
c-----
c    get machine dependent parameters
c    these includes are picked up and expanded into the code by afp
c    and are found in ~usp/include/f77
 
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
c-----
 
c-----
c    SZLNHD is a value obtained from lhdrsz.h
c    The 3 vectors below are equivalenced and are
c    to access the trace header entries (whatever
c    they may be)
c-----
      integer     itr  ( SZLNHD )

      integer     nsamp, nsi, ntrc, nrec, iform
      integer     luin , luout, lbytes, nbytes, lbyout
 
c------
c  static memory allocation
c     real        bigar1(SZSPRD*SZSMPM)
c     real        bigar2(SZSPRD*SZSMPM)
c------
c  dynamic memory allocation for big arrays, eg whole records
c     integer     itrhdr
c     real        bigar1, bigar2
c     pointer     (wkadri, itrhdr(100000))
c     pointer     (wkadr1, bigar1(1))
c     pointer     (wkadr2, bigar2(1))
c------
 
c------
c    this is necessary for buliding printout files
#include <f77/pid.h>
c------
c-----
c    SZSMPM is a value obtained from lhdrsz.h
c-----
      integer     sw(100),iw(100)
      integer     iwd(100)
      character   ntap * 256, otap * 256, name*4
      character   hdrwd(100) * 6
      integer     ifmt_hdrwd(100),l_hdrwd(100),ln_hdrwd(100)
      logical     trc (100)
      logical     rec (100)
      logical     verbos, query, seq
      integer     argis
 
c-----
c    we access the header values which can be short or long integers
c    or real values.  The actual trace values start at position
c    ITRWRD1  (position 65 in the old SIS format).  This value is
c    set in lhdrsz.h but eventually could come in thru the line header
c    making the trace header format variable
c-----
      data lbytes / 0 /, nbytes / 0 /, name/'RNUM'/
 
c-----
c     read program parameters from command line card image file
c-----
      query = ( argis ( '-?' ) .gt. 0 .or. argis ( '-h' ) .gt. 0)
      if ( query )then
            call help()
            stop
      endif
 
c-----
c     open printout files
c     this consists of a 2-character identifier, the process id number,
c     and the child process id number:
c     XY.nnnnn.mmmmm
c     this should be unique even for multiple occurences of the same
c     process in a pipeline
c-----
#include <f77/open.h>
 
      call gcmdln(ntap,otap,nw,hdrwd,sw,iw,rec,trc,seq,verbos)
 
c-----
c     get logical unit numbers for input and output of seismic data
 
c     input values are strings ntap & otap (i.e. names of files), and the
c     read 'r' or write 'w' designations of these files, and the default
c     logical unit numbers if ntap & otap are blank strings, i.e. ntap = ' '
c     in which case:
c     0 = default stdin
c     1 = default stdout
c     Note: default values other that 0 & 1 may be used
 
c     output values are the logical unit numbers accessing these disk files. if
c     these values are less than 0 it means there was a fatal error in trying to
c     open these files
c     ( getln will assign the last parameter as the unit number if the dataset
c      name is ' ', ie. set up stdin and stdout if no filename are specified )
c-----
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)
 
c-----
c     read line header of input dataset (rtape reads data into vector "itr")
c     lbytes is the number of bytes actually read
c-----
      call rtape  ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'RNUM: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif
 
c------
c     save certain trace header parameters
 
c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that 
c     refers to the trace header (LINEHEADER = 0; TRACEHEADER = 1)

      do  i = 1, nw
          call savelu(hdrwd(i),ifmt_hdrwd(i),l_hdrwd(i),ln_hdrwd(i),
     1                TRACEHEADER)
      enddo

c-----------
c format values are:

c     integer    = 1
c     float      = 2
c     character  = 3
c     2-byte int = 4

c the mnemonic definitions are found in the man pages for program scan
c-----------

 
c     To get and/or put LINE header values please use saver/savew
c     since that way code will always be portable to whatever machine
c     we maintain usp on
c     saver/w refer to header words using mnemonics rather than position
c     LINHED is a value in the include file <f77/sisdef.h> that refers to the
c     lineheader
c
c     see saver/w manual pages
c     (LINHED = 0  - just like LINEHEADER)
c------
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif
 
c------
c     hlhprt prints out the historical line header of length lbytes AND
 
c     hlhprt takes "name", in this case 4 characters long and stuffs this
c     into the modified historical line header and returns the NEW length
c     of the line header in lbytes
c------
      call hlhprt (itr, lbytes, name, 4, LERR)
 
 
c----------------------
c  inject command line into
c  historical LH:
c  inputs are current line header in vector "itr" and length lbytes (bytes)
c  outputs are line header modified by insertion of the command line into
c  the historical LH and the modified length of the new LH (lbyout)
 
      call savhlh(itr,lbytes,lbyout)
c----------------------
 
      call wrtape ( luout, itr, lbyout  )
 
c-----
c     verbose output of all pertinent information before
c     processing begins
c-----
      call verbal(nsamp, nsi, ntrc, nrec, iform,
     1            nw,sw,iw,hdrwd,ifmt_hdrwd,l_hdrwd,ln_hdrwd,
     2            rec,trc,ntap,otap)
 
c--------------------------------------------------
c-----
c     BEGIN PROCESSING
c     read trace, do renumbering, write to output file
c-----
 
c-----
c     process desired trace records
c-----
      do  i = 1, nw
          if (iw(i) .ne. 0)
     1    iwd (i) = sw (i) - iw (i)
      enddo

      DO  JJ = 1, nrec
 
            do  i = 1, nw
                if ( rec(i) ) then
                   if (iw(i) .ne. 0)
     1             iwd(i) = iwd(i) + iw(i)
                elseif ( trc(i) ) then
                   if (iw(i) .ne. 0)
     1             iwd(i) = sw(i) - iw(i)
                endif
            enddo

            do  kk = 1, ntrc
 
                  nbytes = 0
                  call rtape( luin, itr, nbytes)
c------
c     if end of data encountered (nbytes=0) then bail out
c     Note:  if you're processing records you might really want
c     to branch to the processing part rather than bailing out
c------
                  if(nbytes .eq. 0) then
                     write(LERR,*)'End of file on input:'
                     write(LERR,*)'  rec= ',jj,'  trace= ',kk
                     go to 999
                  endif

c------
c     use previously derived pointers to trace header values

                  do  i = 1, nw
                      if ( trc(i) ) then
                         if (iw(i) .ne. 0)
     1                   iwd (i) = iwd (i) + iw (i)
                      endif
                  enddo

                  do  i = 1, nw
                      if (iw(i) .ne. 0)
     1                call savew2(itr,ifmt_hdrwd(i),l_hdrwd(i),
     2                            ln_hdrwd(i), iwd(i), TRACEHEADER)
                  enddo

                  call wrtape ( luout, itr, nbytes)
 
 
            enddo
      ENDDO
 
  999 continue
 
c-----
c     close data files
c     flush data left
c     in output buffer
c     NOTE: if the output buffer is not closed you can sometimes end up
c     with missing data
c-----
      call lbclos ( luin )
      call lbclos ( luout )
 
      write(LERR,*)'end of rnum, processed',nrec,' record(s)',
     :     ' with ',ntrc, ' traces'
      write(LER,*)'end of rnum, processed',nrec,' record(s)',
     :     ' with ',ntrc, ' traces'
      stop      
      end
 
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
        write(LER,*) ' '
        write(LER,*)
     :'rnum does dark and terrible things to seismic data:'
        write(LER,*)
     :'see manual pages for details ( online by typing uman prg )'
        write(LER,*)' '
        write(LER,*)
     :'execute rnum by typing rnum and the of program parameters'
        write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
        write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
        write(LER,*)' '
        write(LER,*)
     :' -N [ntap]     (no default)         : input data file name'
        write(LER,*)
     :' -O [otap]     (no default)         : output data file name'
        write(LER,*) ' '
        write(LER,*)
     :' -hw [hdrwd1] (RecNum)     : header word 1'
        write(LER,*)
     :' -sw [istwd1] (do nothing) : starting value of header word 1'
        write(LER,*)
     :' -iw [incwd1] (do nothing) : increment value of header word 1'
        write(LER,*)
     :' -R  header word 1 changes for every record, or header word 1'
        write(LER,*)
     :' -T  for every trace within a record'
        write(LER,*)
     :' -hw [hdrwd2] (TrcNum)     : header word 2'
        write(LER,*)
     :' -sw [istwd2] (do nothing) : starting value of header word 2'
        write(LER,*)
     :' -iw [incwd2] (do nothing) : increment value of header word 2'
        write(LER,*)
     :' -R  header word 2 changes for every record, or header word 2'
        write(LER,*)
     :' -T  for every trace within a record'
        write(LER,*)
     :'                          ...'
        write(LER,*)
     :' -hw [hdrwdN] (ignore)     : header word N'
        write(LER,*)
     :' -sw [istwdN] (do nothing) : starting value of header word N'
        write(LER,*)
     :' -iw [incwdN] (do nothing) : increment value of header word N'
        write(LER,*)
     :' -R  header word N changes for every record, or header word N'
        write(LER,*)
     :' -T  for every trace within a record'
        write(LER,*) ' '
        write(LER,*)
     :' -U  simple renumber to sequential rec & trc numbering RecNum &'
        write(LER,*)
     :'     TrcNum starting from 1 and incrementing by 1'
        write(LER,*)
     :' -V  include on command line if verbose printout is desired'
        write(LER,*)
     :'usage:   rnum -N[ntap] -O[otap] -hw[] -sw[] -iw[] [-R -T]'
        write(LER,*)
     :'              [ -sw[] -iw[] [-T -R] ... -sw[] -iw[] [-T -R] ]'
        write(LER,*)
     :'              [ -U -V ]'
        write(LER,*) ' '
        write(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
      subroutine gcmdln(ntap,otap,nw,hdrwd,sw,iw,rec,trc,seq,verbos)

c-----
c     get command arguments
c
c     ntap  - C*100    input file name
c     otap  - C*100    output file name
c     verbos  L        verbose output or not
c-----
#include <f77/iounit.h>
      character   ntap*(*), otap*(*)
      character   hdrwd(100) * 6, tag * 6
      character*3 ctag, sargvv
      logical     verbos, trc(*), rec(*), seq
      integer     sw(*),iw(*)
      integer     argis, iargcc, iarg, targ
 
c-------
c     import values from the command line using keys, e.g. -N
c     to which are immediately attached the users values.
 
c     For example program rnum might be invoked in the following way:
 
c     rnum  -Nxyz -Oabc
 
c     in which case xyz is a string (the name of the input data set)
c     which will be imported into rnum and associated with the variable
c     "ntap"
 
c     see manual pages on the argument handler routines
c     for the meanings of these functions.  Briefly though
c     we can import from the command line strings, integers, reals,
c     double precision reals, and check the existence of command line
c     keys.  The last 2 fields are the value to be assigned the variable
c     (1) if ONLY the key is present (no value attached to it), or
c     (2) if NO key & no value are present
c-------
            seq  =   (argis('-U') .gt. 0)
            targ = iargcc ()

            do  i = 1, 100
                trc (i) = .false.
                rec (i) = .false.
            enddo

            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )


c----
c   simple sequential renumbering of RecNum & TrcNum
c----
            if (seq) then

               hdrwd (1) = 'RecNum'
               sw (1)    = 1
               iw (1)    = 1
               rec (1)   = .true.
               hdrwd (2) = 'TrcNum'
               sw (2)    = 1
               iw (2)    = 1
               trc (2)   = .true.

               nw = 2

c----
c   arbitrary renumbering of selected header words
c----
            else

               nw = 0
               do  i = 1, 100
                   call argstr( '-hw', tag, ' ', ' ' )
                   if (tag(1:1) .ne. ' ') then
                       nw = nw + 1
                       hdrwd (i) = tag
                   else
                       go to 1
                   endif
               enddo
1              continue

c----
c   scan the cmd line from left to right. For each hdr word we must
c   have:  -sw[] -iw[] and either -R or -T
c----
               logic = 0
               iarg = 1
               do  i = 1, nw
                   ctag = sargvv(i)
                   call argi4 ( '-sw', sw (i) ,   0  ,  0    )
                   call argi4 ( '-iw', iw (i) ,   0  ,  0    )
                   rec (i)   =   (argis('-R') .gt. 0)
               enddo

               jw = 1
               logic = 0
               ia = 1
               do while (jw .le. nw)

                   ctag = sargvv(ia)
                   if (ctag(1:3) .eq. '-hw') then
                      i = ia
                      do ii = i+1, i+3
                         ia = ia + 1
                         ctag = sargvv(ia)
                         if (ctag(1:2) .eq. '-T' .OR. 
     1                       ctag(1:2) .eq. '-R'     ) then
                             if (ctag(1:2) .eq. '-T') then
                                trc (jw) = .true.
                                rec (jw) = .false.
                             elseif (ctag(1:2) .eq. '-R') then
                                trc (jw) = .false.
                                rec (jw) = .true.
                             endif
                             jw = jw + 1
                             logic = logic + 1
                         endif
                      enddo

                   else
                      ia = ia + 1
                   endif
               enddo

               if (logic .ne. nw) then
                write(LERR,*)'FATAL ERROR in rnum cmd line:'
                write(LERR,*)'For each -sw[] -iw[] pair must have -R or'
                write(LERR,*)'-T to flag change with records or traces'
                write(LER ,*)'FATAL ERROR in rnum cmd line:'
                write(LER ,*)'For each -sw[] -iw[] pair must have -R or'
                write(LER ,*)'-T to flag change with records or traces'
                call ccexit (666)
               endif

            endif

            verbos =   (argis('-V') .gt. 0)
 
c-------
c     Note:  argis() = 1 if the key is present
c            argis() = 0 if it isn't
 
      return
      end
 
C***********************************************************************
      subroutine verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  nw,sw,iw,hdrwd,ifmt_hdrwd,l_hdrwd,ln_hdrwd,
     2                  rec,trc,ntap,otap)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4     number of samples in trace
c     vel   - R*4     design velocity
c     nsi   - I*4     sample interval in ms
c     ntrc  - I*4     traces per record
c     nrec  - I*4     number of records per line
c     iform - I*4     format of data
c     ntap  - C*100   input file name
c     otap  - C*100   output file name
c-----
#include <f77/iounit.h>
 
      integer     nsamp, nsi, ntrc, nrec
      character   ntap*(*), otap*(*)
      character   hdrwd(100) * 6
      integer     nw,sw(*),iw(*)
      integer     ifmt_hdrwd(*),l_hdrwd(*),ln_hdrwd(*)
      logical     rec(*),trc(*)
 
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace =  ', nsamp
            write(LERR,*) ' sample interval    =  ', nsi
            write(LERR,*) ' traces per record  =  ', ntrc
            write(LERR,*) ' records per line   =  ', nrec
            write(LERR,*) ' format of data     =  ', iform
            write(LERR,*) ' input data set name =  ', ntap
            write(LERR,*) ' output data set name=  ', otap
            write(LERR,*)' '
            do  i = 1, nw
            if (hdrwd(i) .ne. ' ') then
            write(LERR,*) ' header word ',i,'   =  ', hdrwd(i)
            write(LERR,*) ' word format   =  ',ifmt_hdrwd(i)
            write(LERR,*) ' word position =  ',l_hdrwd(i)
            write(LERR,*) ' word length   =  ',ln_hdrwd(i)
            if (iw(i) .ne. 0) then
            write(LERR,*) ' start value         =  ',sw(i)
            write(LERR,*) ' increment value     =  ',iw(i)
            if (rec(i))
     1      write(LERR,*) ' hdr word changes on record boundaries'
            if (trc(i))
     1      write(LERR,*) ' hdr word changes on trace boundaries'
            endif
            endif
            write(LERR,*)' '
            enddo
            write(LERR,*)' '

      return
      end
 
