C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine Calculate_Average ( Record, Space, nsamp, ntrc, ist, 
     :     iwin_sample, Average_Val, Max_Val, A_Dev, Number_Windows )

c variables passed from calling routine

      integer nsamp, ntrc, ist, iwin_sample
      integer Number_Windows
      
      real Record ( nsamp, ntrc )
      real Space ( nsamp, ntrc )
      real Average_Val( nsamp, ntrc )
      real Max_Val ( nsamp, ntrc )
      real A_Dev ( nsamp, ntrc )

c declare local variables

      integer m
      
c     initialize variables
      
      do i = 1, nsamp
         do j = 1, ntrc
            Space(i,j) = 0.0
            Max_Val(i,j) = 0.0
            Average_Val(i,j) = 0.0
            A_Dev(i,j)=0.0
         enddo
      enddo
      
      
c     process data
      
      DO j = 1, ntrc
               
c     process live traces only
         
         do k = 1, Number_Windows-1

            iwin_start = iwin_sample * (k-1) + ist
            
            do m = iwin_start, iwin_start + iwin_sample - 1
               
               Average_Val(k,j) = Average_Val(k,j) +
     :              abs(Record(m,j))

c Average Deviation

               A_Dev(k,j) = A_Dev(k,j) + ( Record(m,j) )

c get the max (maa) value in the window
               
               if (m .gt. iwin_start) then
                  
                  Max_Val(k,j) = 
     :                 max(Max_Val(k,j),
     :                 abs(Record(m,j)))
               endif

            enddo

            Average_Val(k,j) = Average_Val(k,j)/(iwin_sample)
            A_Dev(k,j) = A_Dev(k,j)/(iwin_sample)

         enddo
         
c     Pick up the end of the data
         
         if ((Number_Windows-1)*iwin_samples 
     :        .le. nsamp) then
            
            do m = nsamp - iwin_sample, nsamp

               Average_Val(Number_Windows,j) = 
     :              Average_Val(Number_Windows,j) + 
     :              abs(Record(m,j))

c Average Deviation

               A_Dev(Number_Windows,j) = 
     :              A_Dev(Number_Windows,j) + 
     :              (Record(m,j))
               
               if (m .gt. ns-iwin_sample) then
                  Max_Val(Number_Windows,j)= 
     :                 max(Max_Val(Number_Windows,j),
     :                 abs(Record(m,j)))
               endif

            enddo
            
            Average_Val(Number_Windows,j) = 
     :           Average_Val(Number_Windows,j)/(iwin_sample)

            A_Dev(Number_Windows,j) = 
     :           A_Dev(Number_Windows,j)/(iwin_sample)

         endif
         
      ENDDO
      
      return
      end
