C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine Compare ( Record, Headers, Space, nsamp,
     :     ntrc, ist, 
     :     iwin_sample, JJ, nsi, Average_Val,
     :     Max_Val, A_Dev,
     :     Max_A_Dev, Stan_Dev, Static_Cor, 
     :     Area, Repair, Kurt, 
     :     kurt_lim, Number_Windows, inum, pct, 
     :     Comparison, Zero,
     :     ifmt_StaCor, l_StaCor, ln_StaCor )
          
#include <save_defs.h> 
#include <f77/lhdrsz.h>
#include <f77/iounit.h>

c variables passed from calling routine

      integer nsamp, ntrc, ist, iwin_sample, JJ, nsi
      integer Number_Windows, inum
      integer ifmt_StaCor,l_StaCor,ln_StaCor

      integer Headers ( ITRWRD*ntrc )
      integer Static_Cor( SZLNHD )
      integer Comparison ( Number_Windows, ntrc )
      
      real Record ( nsamp, ntrc )
      real Space ( nsamp, ntrc )
      real Average_Val ( nsamp, ntrc )
      real Max_Val ( nsamp, ntrc )
      real A_Dev ( nsamp, ntrc ) 
      real Max_A_Dev ( nsamp, ntrc )
      real Stan_Dev ( nsamp, ntrc )
      real Area ( nsamp, ntrc )
      real Kurt ( nsamp, ntrc )
 
      real kurt_lim, pct

      logical Repair, Zero

c declare local variables

      integer i, j, StaCor
      integer areal, arear, madl, madr, avgl, avgr
      integer maxl, maxr, sdl, sdr
      integer Num_Iterations

c initialize variables

      Num_Iterations = inum / 2
      StaCor=30000
      
c set up array comparison(,) and flag it codes to indicate status of
c statistical comparison:
c    
c     Comparison(k,j)=-1  :  Trace j is Dead
c     Comparison(k,j)= 0  :  Window k of Trace j is normal 
c     Comparison(k,j)= 1  :  Window k of Trace j exceeds Kurtosis limit and is bad
c     Comparison(k,j)= 2  :  Window k of Trace j fails statistical comparison
c     Comparison(k,j)= 3  :  Window k of Trace j fails statistical comparison and exceed kurtosis limit
c
c
c     Load Space Array

      do j=1,ntrc
         do i=1,nsamp
            Space(i,j) = Record(i,j)
         enddo
      enddo
      
c     Zero Comparison Array

      do j = 1, ntrc

         do i = 1, Number_Windows

            Comparison(i,j)=0

            if (Max_A_Dev(i,j) .lt. 1.E-20 .and.
     :           Max_A_Dev(i,j) .gt. -1.E-20) then

               Max_A_Dev(i,j)=  1.E-20

            endif

            if(Area(i,j) .lt. 1.E-20 .and.
     :           Area(i,j) .gt. -1.E-20) then

               Area(i,j)=  1.E-20  

            endif
            
         enddo
      enddo

c     Check for Dead Traces and Flag

      do j = 1, ntrc

         if(Static_Cor(j) .eq. 30000) then

            do k = 1, Number_Windows
               Comparison(k,j)=-1
            enddo
         endif
      enddo

c     Check Kurtosis limit and Flag....if kurtosis is greater
c     than kurtosis limit and trace is live then add one to 
c     the comparison array entry for that trace

      do j = 1, ntrc
         do k = 1, Number_Windows
            if (Kurt(k,j) .gt. kurt_lim .and. 
     :           Comparison(k,j) .ge. 0) 
     :           Comparison(k,j) = Comparison(k,j) + 1
         enddo
      enddo

c============================================================================
c     CASE I at the begining of the data
c============================================================================

      do 500 j = 1, Num_Iterations

         do 120 k = 1, Number_Windows

            maxl=0
               
            do 130 i = 1,  Num_Iterations
               if( Max_Val(k,j) .gt. Max_Val(k,j+i)) maxl=1
 130        enddo
            
            if (maxl .eq. 1) then
               avgl=0
                  
               do 140 i =  1,  Num_Iterations
                  if( Average_Val(k,j) .gt. Average_Val(k,j+i))
     :                 avgl=1
 140           enddo 
              
               if (avgl .eq. 1 ) then                  
                  sdl=0
                  
                  do 150 i = 1,  Num_Iterations
                     if( Average_Val(k,j)+Stan_Dev(k,j) .gt. 
     :                    Average_Val(k,j+i)+Stan_Dev(k,j+i)) sdl=1
 150              enddo
                  
                  if (sdl .eq. 1 ) then                     
                     madl=0
                        
                     do 160 i = 1,  Num_Iterations             
                        if((Max_A_Dev(k,j+i)/Max_A_Dev(k,j)) .lt.  
     :                       pct ) madl=1
 160                 enddo
                     
                     if (madl .eq. 1) then                         
                        areal=0
                           
                        do 170 i = 1,  Num_Iterations                      
                           if(Area(k,j+i)/Area(k,j) .lt. pct ) 
     :                          areal=1
 170                    enddo
                        
                        if (areal .eq. 1 ) then
                              
c this is strange logic...seems that both tests do the 
c same thing....pgag

                           if(Comparison(k,j) .eq. 1) then 
                              Comparison(k,j)=3
                           elseif(Comparison(k,j) .eq. 1) then
                              Comparison(k,j)=2
                           endif

                        endif
                     endif     
                  endif
               endif
            endif            
 120     enddo  
 500  enddo         

c============================================================================
c     CASE II in the data
c============================================================================

      do 10 j = 1 + Num_Iterations, ntrc - Num_Iterations

         do 20 k=1,Number_Windows   

            maxl=0
            maxr=0

            do 30 i = 1,  Num_Iterations
               if( Max_Val(k,j) .gt. Max_Val(k,j-i)) maxl=1
               if( Max_Val(k,j) .gt. Max_Val(k,j+i)) maxr=1
 30         enddo            

            if (maxl .eq. 1 .and. maxr .eq. 1) then
              
               avgl=0
               avgr=0 
              
               do 40 i =  1,  Num_Iterations
                  if( Average_Val(k,j) .gt. Average_Val(k,j-i))
     :                 avgl=1
                  if( Average_Val(k,j) .gt. Average_Val(k,j+i)) 
     :                 avgr=1       
 40            enddo
               
               if (avgl .eq. 1 .and. avgr .eq. 1) then  
                
                  sdl=0
                  sdr=0  
                
                  do 50 i = 1,  Num_Iterations
                     if( Average_Val(k,j)+Stan_Dev(k,j) .gt. 
     :                    Average_Val(k,j-i)+Stan_Dev(k,j-i)) sdl=1
                     if( Average_Val(k,j)+Stan_Dev(k,j) .gt. 
     :                    Average_Val(k,j+i)+Stan_Dev(k,j+i)) sdr=1
 50               enddo
                  
                  if (sdl .eq. 1 .and. sdr .eq. 1) then
                     
                     madl=0
                     madr=0
                     
                     do 60 i = 1,  Num_Iterations  
                        
                        if((Max_A_Dev(k,j-i)/Max_A_Dev(k,j)) .lt.
     :                       pct ) madl=1
                        if((Max_A_Dev(k,j+i)/Max_A_Dev(k,j)) .lt.
     :                       pct ) madr=1
 60                  enddo

                     if (madl .eq. 1 .and. madr .eq. 1) then 
                        
                        areal=0
                        arear=0
                     
                        do 70 i = 1,  Num_Iterations                     
                           if(Area(k,j-i)/Area(k,j) .lt.
     :                          pct ) areal=1
                           if(Area(k,j+i)/Area(k,j) .lt. 
     :                          pct ) arear=1
 70                     enddo
                        
                        if (areal .eq. 1 .and. arear .eq. 1) then
                           
                           if(Comparison(k,j) .eq. 1) then 
                              Comparison(k,j)=3
                           elseif(Comparison(k,j) .ne. 1) then
                              Comparison(k,j)=2
                           endif

                        endif
                     endif     
                  endif
               endif
            endif 
 20      enddo         
 10   enddo
      
c============================================================================
c     CASE III  at the end of the record
c============================================================================

      do 600 j = ntrc - Num_Iterations + 1, ntrc
          
         do 220 k=1,Number_Windows 

            maxl=0
               
            do 230 i = 1,  Num_Iterations
c               if( Max_Val(k,j) .gt. Max_Val(k,j+i)) maxl=1
               if( Max_Val(k,j) .gt. Max_Val(k,j-i)) maxl=1
 230        enddo 
           
            if (maxl .eq. 1) then
               avgl=0
               
               do 240 i =  1,  Num_Iterations
c                  if( Average_Val(k,j) .gt. Average_Val(k,j+i) )
                  if( Average_Val(k,j) .gt. Average_Val(k,j-i) )
     :                 avgl=1
 240           enddo
               
               if (avgl .eq. 1 ) then                  
                  sdl=0
                  
                  do 250 i = 1,  Num_Iterations
                     if( Average_Val(k,j)+Stan_Dev(k,j) .gt. 
     :                    Average_Val(k,j-i)+Stan_Dev(k,j-i)) sdl=1
c     :                    Average_Val(k,j+i)+Stan_Dev(k,j+i)) sdl=1
 250              enddo
                  
                  if (sdl .eq. 1 ) then                     
                     madl=0
                     
                     do 260 i = 1,  Num_Iterations                   
c                        if(Max_A_Dev(k,j+i)/Max_A_Dev(k,j) .lt.  
                        if(Max_A_Dev(k,j-i)/Max_A_Dev(k,j) .lt.  
     :                       pct ) madl=1
 260                 enddo
                     
                     if (madl .eq. 1) then                         
                        areal=0
                           
                        do 270 i = 1,  Num_Iterations
c                           if((Area(k,j+i)/Area(k,j)) .lt.  
                           if((Area(k,j-i)/Area(k,j)) .lt.  
     :                          pct ) areal=1
 270                    enddo
                        
                        if (areal .eq. 1 ) then
                              
                           if(Comparison(k,j) .eq. 1) then 
                              Comparison(k,j)=3
                           elseif(Comparison(k,j) .eq. 1) then

c again why are the conditions the same for both parts of
c this if logic????....pgag

                              Comparison(k,j)=2
                           endif
                           
                        endif
                     endif     
                  endif
               endif
            endif
 220     enddo  
 600  enddo

c============================================================================
c process data
c============================================================================

      hdr_index = 0
      
      DO 99 j = 1, ntrc

c     get header value
         
         hdr_index = (j-1) * ITRWRD + 1 
         call saver2 ( Headers(hdr_index), ifmt_StaCor, l_StaCor, 
     :        ln_StaCor, StaCor, TRACEHEADER)
         
c     process live traces only
        
         if (Comparison(1,j) .eq. -1) then
            write(LERR,*)'Record/Trace ',JJ,j,' is already Dead'
            go to 99
         endif
        
         do 550 k=1,Number_Windows
          
            if (Comparison(k,j) .gt. 0) then
               iflagl=j
               iflagr=j
            endif
            
            if (j .gt. int(inum/2) .and. j .le. 
     :           ntrc-(int(inum/2)) ) then
             
               do i = inum,1,-1
                  if (Comparison(k,j-i) .eq. 0) iflagl=j-i
                  if (Comparison(k,j+i) .eq. 0) iflagr=j+i
               enddo  
            endif
            
            if (j .le. int(inum/2)) then
               
               do i =1,inum
                  if (Comparison(k,j+i) .eq. 0) then
                     iflagl=j+i
                     go to 654
                  endif
               enddo
 654           do i = iflagl,inum
                  if (Comparison(k,j+i) .eq. 0) then
                     iflagr=j+i
                     go to 88
                  endif
               enddo
 88         endif
            
            if (j .gt. ntrc-int(inum/2)) then
             
               do i =1,inum
                  if (Comparison(k,j-i) .eq. 0) then
                     iflagr=j-i
                    
                     go to 65
                  endif
               enddo
               
 65            do ii = i+1,inum
              
                  if (Comparison(k,j-ii) .eq. 0) then
                     iflagl=j-ii
                     go to 89
                  endif
               enddo
 89         endif
           
            if (iflagl .eq. j .or. iflagr .eq. j) then
               write(LERR,*)'Record/Trace ',JJ,j,
     :              ' Too Many Adjacent Dead or Bad Traces'
               go to 550
            endif

c     if we made it this far then iflagl and iflagr are the nearest
c     adjacent trace numbers with good data.

           if (Comparison(k,j) .gt. 0) then
            if (Repair) then
            
               do iwin_start= iwin_sample * 
     :              (k-1)+ist,iwin_sample*(k) + ist                                          
                  if ( iwin_start .le. nsamp ) then                        
                     Space(iwin_start,j) = 
     :                    (Space(iwin_start,iflagr) +
     :                    Space(iwin_start,iflagl))/2.
                  endif
               enddo
               write(LERR,*)'Record/Trace Repaired',JJ,j,
     :              iwin_sample*(k-1)*nsi,iwin_sample*(k)*nsi 
            endif

            if(Zero) then
               do iwin_start= iwin_sample * 
     :              (k-1)+ist,iwin_sample*(k) + ist 
                  Space(iwin_start,j) = 0.
               enddo
               write(LERR,*)'Record/Trace Zeroed',JJ,j,
     :              iwin_sample*(k-1)*nsi,iwin_sample*(k)*nsi,
     :              Comparison(k,j)
            endif
               
            if (.not. Repair .and. .not. Zero) then
               StaCor = 30000
              
               call savew2 ( Headers(hdr_index), ifmt_StaCor, l_StaCor, 
     :              ln_StaCor, StaCor, TRACEHEADER)
               
               write(LERR,*)'Record/Trace Killed ',JJ,j,
     :              iwin_sample*(k-1)*nsi,iwin_sample*(k)*nsi
            endif
            
         endif
 550     enddo
         
 99   ENDDO
      
c     Put the corrected record back into the correct array and pass back
c     into main routine to be written out.

      do j=1,ntrc
         do i=1,nsamp
            Record(i,j) = Space(i,j)
         enddo
      enddo

      return
      end
