C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************c
c rwindow reads stacked data records on input.
c outputs records padded with adjacent traces on output.            
c**********************************************************************c
c
c     declare variables
c
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

 
      parameter (maxs=0 000 002)
      dimension s(maxs)
      pointer   (pntrs,s)

      integer     hbegin
      integer     sheader(SZLNHD)
#include <f77/pid.h>
#include <save_defs.h>
c     parameter (i2fact=8/szsmpd,lenhed=lntrhd/i2fact,hbegin=1-lenhed)
c
      character*256  ntap,otap
      character*7    name
      logical     verbos, query
      logical     restor        
      logical     ytransform
      logical     single_trace_rec
      integer     argis

      common /thdr/ ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     1              ifmt_RecNum,l_RecNum,ln_RecNum,
     2              ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,
     3              ifmt_RecInd,l_RecInd,ln_RecInd,
     4              ifmt_DphInd,l_DphInd,ln_DphInd,
     5              ifmt_DstSgn,l_DstSgn,ln_DstSgn,
     6              ifmt_DstUsg,l_DstUsg,ln_DstUsg,
     7              ifmt_StaCor,l_StaCor,ln_StaCor,
     8              ifmt_SoPtNm,l_SoPtNm,ln_SoPtNm,
     9              ifmt_LRcCDP,l_LRcCDP,ln_LRcCDP

 
      data        name/'RWINDOW'/
c_______________________________________________________________
c     read program parameters from command line card image file
c_______________________________________________________________
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query )then
            call help()
            call exit(0)
      endif
c_______________________________________________________________
c     open printout files
c_______________________________________________________________
#include <f77/open.h>
c_______________________________________________________________
c     get i/o data set names
c_______________________________________________________________
      call argstr('-N',ntap, ' ', ' ')
      call argstr('-O',otap, ' ', ' ')
      call argr4('-dx',dx,0.,0.)         
      call argi4('-ntr',ntr,200,200)     
      call argi4('-npad',npad,20,20)   
      call argi4('-nline',nline,0,0)   
      verbos=(argis('-V') .gt. 0)
      restor=(argis('-R') .gt. 0)
      ytransform=(argis('-Y') .gt. 0)
      if(dx .eq. 0. .and. .not. restor) then
         write(lerr,*) 'error in routine rwindow'
         write(lerr,*) 'dx must be nonzero for breakup/pad mode! '
         write(lerr,*) 'specify trace spacing after -dx'
         call exit(666)
      endif
c_______________________________________________________________
c     get logical unit numbers for input and output
c_______________________________________________________________
      call getln(luin ,ntap,'r',0)
      call getln(luout,otap,'w',1)
c_______________________________________________________________
c     read line header of input
c     save certain parameters
c_______________________________________________________________
      lbytes=0
      call rtape(luin,sheader,lbytes)
      if(lbytes .eq. 0) then
         write(lerr,*)'RWINDOW: no header read from unit ',luin
         call exit(0)
      endif
C_______________________________________________________________________
c     pull relevent values from line header.
C_______________________________________________________________________
      call saver(sheader,'NumSmp',nsamp,LINEHEADER)
      call saver(sheader,'SmpInt',nsi,LINEHEADER)

      lenhed=ITRWRD
      hbegin=1-lenhed
c
      call hlhprt(sheader,lbytes,name,7,lerr)
      if(restor) then
         if(ytransform) then
            call saver(sheader,'Ny_Pad',npad,LINEHEADER)
            call saver(sheader,'NyLine',nline,LINEHEADER)
            call saver(sheader,'Ny_Rec',nrec_inline,LINEHEADER)
            call saver(sheader,'Ny_Trc',ntrpline,LINEHEADER)
            call saver(sheader,'Ny_Win',ntrcumpads,LINEHEADER)
         else
            call saver(sheader,'Nx_Pad',npad,LINEHEADER)
            call saver(sheader,'NxLine',nline,LINEHEADER)
            call saver(sheader,'Nx_Rec',nrec_inline,LINEHEADER)
            call saver(sheader,'Nx_Trc',ntrpline,LINEHEADER)
            call saver(sheader,'Nx_Win',ntrcumpads,LINEHEADER)
         endif
         ntr=ntrcumpads-2*npad  
         ntrbuf=ntrcumpads  
         call savew(sheader,'NumRec',nline,LINEHEADER)
         call savew(sheader,'NumTrc',ntrpline,LINEHEADER)
      else
         call saver(sheader,'NumRec',nrecin,LINEHEADER)
         call saver(sheader,'NumTrc',ntrin,LINEHEADER)
         if(npad .gt. 0) then
            npad=2*(npad/2)+1
         endif
         ntrcumpads=ntr+2*npad
         ntrbuf=ntrcumpads
         ntrtotal=nrecin*ntrin   
         if(ntrin .eq. 1) then
c___________________________________________________________________
c           single trace records (typically, 2D stacked data)
c___________________________________________________________________
            ntrpline=nrecin
            if(nline .eq. 0) nline=1   
            single_trace_rec=.true.
         else
c___________________________________________________________________
c           multi trace records (typically, 3D stacked data)
c___________________________________________________________________
            ntrpline=ntrin
            if(nline .eq. 0) nline=nrecin
            single_trace_rec=.false.
         endif
         nrec_inline=(ntrpline-1)/ntr+1
         nrecout=nrec_inline*nline
         if(ytransform) then
            call savew(sheader,'Ny_Pad',npad,LINEHEADER)
            call savew(sheader,'NyLine',nline,LINEHEADER)
            call savew(sheader,'Ny_Rec',nrec_inline,LINEHEADER)
            call savew(sheader,'Ny_Trc',ntrpline,LINEHEADER)
            call savew(sheader,'Ny_Win',ntrcumpads,LINEHEADER)
         else
            call savew(sheader,'Nx_Pad',npad,LINEHEADER)
            call savew(sheader,'NxLine',nline,LINEHEADER)
            call savew(sheader,'Nx_Rec',nrec_inline,LINEHEADER)
            call savew(sheader,'Nx_Trc',ntrpline,LINEHEADER)
            call savew(sheader,'Nx_Win',ntrcumpads,LINEHEADER)
         endif 
c
         call savew(sheader,'NumRec',nrecout,LINEHEADER)
         call savew(sheader,'NumTrc',ntrcumpads,LINEHEADER)
      endif
      call savhlh(sheader,lbytes,lbyout)
      call wrtape(luout,sheader,lbyout)
c
      write(lerr,*) 'restore to original number of records/traces? ',
     1               restor 
      write(lerr,'(a20,i10)') 'ntr',ntr,'npad',npad,
     1                 'nrecin',nrecin,'ntrin',ntrin,
     2                 'ntrpline',ntrpline,'nline',nline,
     3                 'nrec_inline',nrec_inline,
     4                 'ntrcumpads',ntrcumpads,
     5                 'nrecout',nrecout,'ntrbuf',ntrbuf
c_____________________________________________________________   
c     calculate number of bytes in output trace
c     calculate trace header position of key variables.
c_____________________________________________________________   

c     lenu2=lntrhd+nsamp*i2fact
      lenu2=lenhed+nsamp
      nbytes_out=(nsamp+lenhed)*szsmpd

c     call savelu('DstSgn',ifmt,l_DstSgn,length,TRACEHEADER)
c     call savelu('StaCor',ifmt,l_StaCor,length,TRACEHEADER)
c     call savelu('RecNum',ifmt,l_recnum,length,TRACEHEADER)
c     call savelu('LRcCDP',ifmt,l_LRcCDP,length,TRACEHEADER)
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('SoPtNm',ifmt_SoPtNm,l_SoPtNm,ln_SoPtNm,TRACEHEADER)
      call savelu('LRcCDP',ifmt_LRcCDP,l_LRcCDP,ln_LRcCDP,TRACEHEADER)

c______________________________________________________________________
c     calculate memory requirements
c______________________________________________________________________
      write(lerr,'(///,80a1)') ('_',i=1,80)
      write(lerr,'(a)')'storage map of major arrays'
      write(lerr,'(80a1)') ('_',i=1,80)
C
      l_free=1
c____________________________________________________________________
      write(lerr,'(a20,3a10)')'variable name','begin','end','length'
      call mapmem('u',l_u,l_free,3*ntrbuf*(nsamp+lenhed),lerr)
      call mapmem('uout',l_uout,l_free,ntrbuf*(nsamp+lenhed),lerr)
      call mapmem('wgt1',l_wgt1,l_free,npad,lerr)
      call mapmem('wgt2',l_wgt2,l_free,npad,lerr)
C_______________________________________________________________________
C     allocate dynamic memory.
C_______________________________________________________________________
      lens=l_free-1
      write(lerr,'(a20,10x,i10)') 'total vector length',lens
      call galloc(pntrs,lens*szsmpd,ierrcd,0)
      if(ierrcd .ne. 0 ) then
         write(lerr,*)'galloc memory allocation error from main'
         write(lerr,*)'ierrcd = ',ierrcd
         write(lerr,*)
         write(lerr,*)'probable cause: too much memory requested!'
         write(lerr,*)'go check your seismic headers and command'//
     1                ' line arguments!'
         write(lerr,*)
         write(lerr,*)'program RWINDOW aborted'
         write(ler,*)'galloc memory allocation error from main'
         write(ler,*)'ierrcd = ',ierrcd
         write(ler,*)
         write(ler,*)'probable cause: too much memory requested!'
         write(ler,*)'go check your seismic headers and command'//
     1                ' line arguments!'
         write(ler,*)
         write(ler,*)'program RWINDOW aborted'
         call exit(101)
      endif
c
      if(restor) then
c_____________________________________________________________   
c        restore the records by blending and editting off the pads.
c_____________________________________________________________   
         call restore(s(l_u),s(l_u),s(l_uout),s(l_uout),s(l_wgt1),
     1               s(l_wgt2),
     2               hbegin,lenhed,nsamp,nbytes_out,
     3               luin,luout,lerr,npad,ntr,nrec_inline,
     4               lenu2,ntrpline,nline)
      else
c_____________________________________________________________   
c        generate padded records.                                  
c_____________________________________________________________   
         call breakup(s(l_u),s(l_u),lenu2,nsamp,
     1                hbegin,lenhed,nbytes_out,luin,luout,lerr,
     2                npad,ntr,ntrcumpads,nrec_inline,ntrpline,
     3                nline,dx)
      endif

c_____________________________________________________________   
c     close data files
c_____________________________________________________________   
      call lbclos ( luin )
      call lbclos ( luout )

      write(ler,*)'normal completetion. routine RWINDOW'           
      write(lerr,*)'normal completetion. routine RWINDOW'           
      close(lerr)
      call exit(0)
      end
 
      subroutine help
#include <f77/iounit.h>

         write(ler,*)
     1'***************************************************************'
       write(ler,*)' '
        write(ler,*)
     1'execute rwindow by typing rwindow and '
     2                  //'list of program parameters.'
        write(ler,*)
     1'note that each parameter is proceeded by -a where "a" is '
        write(ler,*)
     1'a character(s) corresponding to some parameter.'
        write(ler,*)
     1'users enter the following parameters, or use the default values'
       write(ler,*)' '
        write(ler,*)
     1' -N [ntap]  (stdin)   : input stacked data set file name'
        write(ler,*)
     1' -O [otap]  (stdout)  : output padded records'
        write(ler,*)
     1' ntr [ntr] (200)      : number of nonpadded traces in analysis'
     2                      //' window'
        write(ler,*)
     1' -npad [npad] (20)    : number of traces to be padded to the'
     2                      //' ends of each output record'
        write(ler,*)
     1' -dx [dx] (no default): trace separation to be used in '
     2                        //' generating trace header distances'
        write(ler,*)
     1' -R                    : if present, restore to unpadded'
     2                        //' records'
        write(ler,*)
     1' -Y                  : if present, transform from (tau,q,p) to'
     2                      //' (tau,y,p)'
        write(ler,*)
     1' -V                    : if present, verbose printout'
       write(ler,*)' '
       write(ler,*)'usage:'
       write(ler,*)
       write(ler,*)'rwindow -N[ntap] -O[otap] '
       write(ler,*)'        -nline[] -ntr[] -npad[] -dx[] [-R,-Y,-V]'
       write(ler,*)' '
       write(ler,*)

      return
      end
 

