C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE TIMFR(LX,X,TDEL,FDEL,FMIN,FMAX,LAP,AM,PH)              TIM01000
C     A CONFIDENTIAL AMOCO SUBROUTINE                                   TIM02000
C                            FORTRAN BY KEN PEACOCK        3-21-66      TIM03000
C     THIS SUBROUTINE COMPUTES A HARMONIC ANALYSIS UPON THE X ARRAY,    TIM04000
C     THE LATTER IS ASUMED TO EXIST IN A TIME INTERVAL -T TO T.  ALL    TIM05000
C     VALUES OF THE X ARRAY SHOULD BE 1/2 THE LIMIT FROM THE RIGHT      TIM06000
C     + 1/2 THE LIMIT FROM THE LEFT.  A COMPLETE HARMONIC ANALYSIS      TIM07000
C     REQUIRES FDEL .LE. 1./(LX*TDEL) AND FMAX .GE. 1./(2.*TDEL).       TIM08000
C     INPUTS ARE...                                                     TIM09000
C        LX, LENGTH OF THE X ARRAY, LX MUST BE AN ODD NUMBER.           TIM10000
C        X, THE INPUT ARRAY.                                            TIM11000
C        TDEL, THE TIME SAMPLE INTERVAL, IN SECONDS.                    TIM12000
C        FDEL, THE FREQUENCY SAMPLE INTERVAL, IN HERTZ.  IF FDEL        TIM13000
C             = 0., FDEL IS SET TO 1./(LX*TDEL).  FDEL SHOULD BE        TIM14000
C             A NUMBER SUCH THAT 1./(FDEL*TDEL) IS AN ODD               TIM15000
C             INTEGER.                                                  TIM16000
C        FMIN, THE STARTING FREQUENCY.                                  TIM17000
C        FMAX, THE FREQUENCY LIMIT.  IF FMAX = 0., FMAX IS SET TO       TIM18000
C             1./(2.*TDEL).                                             TIM19000
C     OUTPUTS ARE...                                                    TIM20000
C        LAP, LENGTH OF THE AM AND PH ARRAYS, LAP = (FMAX-FMIN)/        TIM21000
C             FDEL+1.                                                   TIM22000
C        AM, THE AMPLITUDE ARRAY.                                       TIM23000
C        PH, THE PHASE ARRAY, EACH PH(I) IS IN THE RANGE 0 TO 360       TIM24000
C             - DEGREES.                                                TIM25000
C     PROGRAMMED FOR THE IBM 1800 COMPUTER.                             TIM26000
C     VERSION AS OF 7-6-70.                                             TIM27000
C                                                                       TIM28000
      DIMENSION X(1),AM(1),PH(1)                                        TIM29000
      IF(FDEL)2,1,2                                                     TIM30000
    1 FDEL1 = 1./(LX*TDEL)                                              TIM31000
      GO TO 3                                                           TIM32000
    2 FDEL1 = FDEL                                                      TIM33000
    3 IF(FMAX) 5,4,5                                                    TIM34000
    4 FMAX1 = 1./(2.*TDEL)                                              TIM35000
      GO TO 6                                                           TIM36000
    5 FMAX1 = FMAX                                                      TIM37000
    6 ISTOP = LX/2                                                      TIM38000
      IFACT = LX+1                                                      TIM39000
      DO 7 I=1,ISTOP                                                    TIM40000
      J = IFACT-I                                                       TIM41000
      TEMP = .5*(X(J)+X(I))                                             TIM42000
      X(J) = .5*(X(J)-X(I))                                             TIM43000
    7 X(I) = TEMP                                                       TIM44000
      LAP = (FMAX1-FMIN)/FDEL1+1.01                                     TIM45000
      FACT = 2.*3.141592654*TDEL                                        TIM46000
      FAC = FACT*FMIN                                                   TIM47000
      DO 9 J=1,LAP                                                      TIM48000
      W = FACT*(J-1)*FDEL1+FAC                                          TIM49000
      COSNW = 1.                                                        TIM50000
      SINNW = 0.                                                        TIM51000
      COSW =  COS(W)                                                    TIM52000
      SINW =  SIN(W)                                                    TIM53000
      SUM1 = X(ISTOP+1)/2.                                              TIM54000
      SUM2 = 0.                                                         TIM55000
      ISTAR = ISTOP+2                                                   TIM56000
      DO 8 I=ISTAR,LX                                                   TIM57000
      T = COSW*COSNW-SINW*SINNW                                         TIM58000
      SINNW = COSW*SINNW+SINW*COSNW                                     TIM59000
      COSNW = T                                                         TIM60000
      K = IFACT-I                                                       TIM61000
      SUM1 = SUM1+X(K)*COSNW                                            TIM62000
    8 SUM2 = SUM2+X(I)*SINNW                                            TIM63000
      AM(J) = 2.*SUM1*TDEL                                              TIM64000
    9 PH(J) = -2.*SUM2*TDEL                                             TIM65000
      FACT = 360./(2.*3.141592654)                                      TIM66000
      DO 17 I=1,LAP                                                     TIM67000
      TEMP = AM(I)                                                      TIM68000
      AM(I) =  SQRT(AM(I)*AM(I)+PH(I)*PH(I))                            TIM69000
      IF(TEMP)13,10,13                                                  TIM70000
   10 IF(PH(I))11,12,12                                                 TIM71000
   11 ATAN1 = 4.712388980                                               TIM72000
      GO TO 17                                                          TIM73000
   12 ATAN1 = 1.570796327                                               TIM74000
      GO TO 17                                                          TIM75000
   13 ATAN1 = ATAN(PH(I)/TEMP)                                          TIM76000
      IF(TEMP)16,14,14                                                  TIM77000
   14 IF(PH(I))15,17,17                                                 TIM78000
   15 ATAN1 = ATAN1+6.283185307                                         TIM79000
      GO TO 17                                                          TIM80000
   16 ATAN1 = ATAN1+3.141592654                                         TIM81000
   17 PH(I) = ATAN1*FACT                                                TIM82000
      DO 18 I=1,ISTOP                                                   TIM83000
      J = IFACT-I                                                       TIM84000
      TEMP = X(I)-X(J)                                                  TIM85000
      X(J) = X(I)+X(J)                                                  TIM86000
   18 X(I) = TEMP                                                       TIM87000
      RETURN                                                            TIM88000
      END                                                               TIM89000
