C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C++
C Component name : EIGVAL
C Description : COMPUTES EIGENVALUES CORRESPONDING TO DPSS K0 to K1
C Maintainer : A.T. WALDEN
C Version no.: 1
C Date : 3 DEC 1987
C Component class : SUBROUTINE 
C Source location : 
C Object location : 
C Documentation location : 
C Category : 
C
C 
C Additional information:
C 
C--
      SUBROUTINE EIGVAL(N, NMAX, K0, K1, W, Z, RLAM, IFAULT)
C
C  GIVEN DPSS'S VERY ACCURATELY FOUND USING TRIDPSS, THIS SUBROUTINE
C  SOLVES EQN. (2.9) OF THOMSON TO FIND THE CORRESPONDING EIGENVALUES.
C ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
C  N      Integer     input        length of sequence to generate 
C
C  NMAX   Integer     input        first dimension of FV and Z in the 
C                                  calling (sub)program, i.e., maximum 
C                                  possible  N
C
C  K0     Integer     input        K0 smallest index number of dpss to 
C                                  calculate (normally zero)
C
C  K1     Integer     input        K1 largest index number of dpss to 
C                                  calculate (normally <[2NW])
C
C  W      Real        input        bandwidth, W < 1/2
C
C  Z  Real(NMAX,K1-K0+1) output    columns contain eigenvectors corresponding
C                                  to indices K0 to K1
C
C  RLAM Real(K1-K0+1) output       approximate eigenvalues corresponding
C                                  to dpss eigenvectors in Z
C
C  IFAULT Integer      output      IFAULT=0 indicates successful completion
C                                  =1 if NMAX < N or N < 2
C                                  =2 if W > 1/2 or W < 0
C
C ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
      IMPLICIT NONE
C
      INTEGER K, K0, K1, I, LMAX, L, N, NMAX, IFAULT
C
      DOUBLE PRECISION VMAX, ZERO, DSUM, R2W, DIFF, CON, PI, TWO,
     * HALF, ONE, FOUR, W
      DOUBLE PRECISION Z(NMAX,K1-K0+1), RLAM(K1-K0+1)
C
      DATA ZERO, HALF, ONE, TWO, FOUR/0.0D0, 0.5D0, 1.0D0, 2.0D0, 4.0D0/
C
      IFAULT=1
      IF(NMAX .LT. N .OR. N .LT. 2) RETURN
      IFAULT=2
      IF(W .GT. HALF. OR. W .LT. ZERO) RETURN
C
      PI=FOUR*ATAN(ONE)
      R2W=TWO*W
      CON=R2W*PI
C
      K=K1-K0+1
      DO 5 I=1,K
          LMAX=0
          VMAX=ZERO
C
C  FOR I'TH EIGENVECTOR, FIND THE LARGEST VALUE (FOR BEST ACCURACY)
C
          DO 10 L=1,N
            IF(ABS(Z(L,I)) .GT. VMAX) THEN
                 LMAX=L
                 VMAX=ABS(Z(L,I))
            END IF
 10       CONTINUE
C
          DSUM=ZERO
          DO 15 L=1,N
               IF(L .EQ. LMAX) THEN
                        DSUM=DSUM+R2W*Z(L,I)
               ELSE
                        DIFF=FLOAT(LMAX-L)
                        DSUM=DSUM+SIN(CON*DIFF)*Z(L,I)/(PI*DIFF)
               END IF
 15       CONTINUE
          RLAM(I)=DSUM/Z(LMAX,I)
  5   CONTINUE
      IFAULT=0
      RETURN
      END          
