C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C++
C Component name : GL_RSTR
C Description : Transform from frequency domain into time series 
C Maintainer : S. DEREGOWSKI
C Version no.: 1
C Date : 1978
C Component class : SUBROUTINE
C Source location : GEOLIB:[GEOLIB.GL_LIB]
C Object location : GEOLIB:[GEOLIB]GL_LIB
C Documentation location : GRBS$DISK:[GEOLIB.TEXT.FFT]FFTPAK.TXT
C Category : FFT
C
C 
C Additional information:
C
C INPUT     N   -   transform window length in samples
C           KG  -   INTEGER output from GL_STWI
C           IR  -   ARRAY containing sin/cosine tables, output from GL_STWI
C           W2  -   ARRAY containing sin/cosine tables, output from GL_STWI
C           C1  -   ARRAY - Real part of tranformed array
C	    C2  -   ARRAY - Imaginary part of transformed array
C 
C OUTPUT    C1  -   ARRAY - first half of series.
C           C2  -   ARRAY - second half of series.
C          
C WORK      D   -   ARRAY of size N/2
C--
C      SUBROUTINE GL_RSTR(N,KG,IR,W2,C1,C2,D)
       SUBROUTINE RSTR1(N,KG,IR,W2,C1,C2,D)
       DIMENSION  IR(*),W2(*),C1(*),C2(*),D(*)
       XN=N
       S=SIN(3.1415926536/XN)
       C=SQRT((1.-S)*(1.+S))
       N5=N/4
       N1=N+1
       N2=N5+N5
       N3=N+2
       N4=N2+1
       N6=N5+2
       I=1
       L=1
       J=2
       L1=2
       GOTO3
 1     L=L1
       J=L+L
       I=J-1
       L1=L+1
       M=I
       CN=W2(N6-L)
       SN=W2(L)
 2     NM=N3-M
       A1=C1(M)
       B1=C1(NM)
       A2=C2(M)
       B2=C2(NM)
       C1(M)=A1+B1
       C2(M)=A2-B2
       X=A1-B1
       Y=A2+B2
       C1(NM)=X*CN-Y*SN
       C2(NM)=X*SN+Y*CN
       IF(I.LT.M)GOTO4
 3     M=J
       X=W2(N6-L1)
       Y=W2(L1)
       CN=X*C+Y*S
       SN=Y*C-X*S
       GOTO2
 4     IF(L.LT.N5)GOTO1
       X=C1(1)
       Y=C1(N1)
       C1(1)=X+Y
       C2(1)=X-Y
       DO 5 I=2,N2
       J=N3-I
       A1=C1(I)
       A2=C2(I)
       B1=C1(J)
       B2=C2(J)
       C1(I)=A1-B2
       C2(I)=A2+B1
       C1(J)=A1+B2
 5     C2(J)=B1-A2
       C1(N4)=2.0*C1(N4)
       C2(N4)=-2.0*C2(N4)
       CALL IDFT(N,KG,IR,W2,C1,C2)
C      CALL GL_IDFT(N,KG,IR,W2,C1,C2)
       DO 6 I=1,N2
 6     D(I)=C2(I)
       DO 7 I=1,N2
       J1=I+I
       J=J1-1
       IN=I+N2
       C2(J)=C1(IN)
 7     C2(J1)=C2(IN)
       DO 8 I=1,N2
       J=N-I-I+2
       IN=N2-I+1
       C1(J)=D(IN)
 8     C1(J-1)=C1(IN)
       RETURN
       END
