C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C++
C Component name : SPECON_CROSS
C Description : COMPUTES AND AVERAGES EIGENSPECTRA OVER DPSS ORDERS
C Maintainer : A.T. WALDEN
C Version no.: 1
C Date : 11 JULY 1988
C Component class : SUBROUTINE 
C Source location : 
C Object location : 
C Documentation location : 
C Category : 
C
C 
C Additional information: 
C 
C--
C ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
C  PROGRAM TAKES THE MODULUS SQUARED OF THE EIGENCOEFFICIENTS (Y)
C  AND AVERAGES OVER DPSS ORDERS TO GIVE SPECTRAL ESTIMATE.
C
C ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
C  (i/o) denotes input or output parameter
C
C  N        Integer (i)     length of dpss sequence
C
C  NREQ     Integer (i)     number of terms for FFT (e.g., 2**p)
C                           or Singleton-compatible length
C
C  NREQMAX  Integer (i)     max permitted size of NREQ (e.g., 4096)
C                           (defines dim of UR,D and Y in calling prog)
C
C  K0       Integer (i)     minimum order for dpss (e.g., 0)
C
C  K1       Integer (i)     maximum order for dpss (e.g., 5)
C
C  CMU      Complex (i)     complex mean (zero freq)
C
C  Y((NREQMAX/2)+1,K1-K0+1) complex (i) eigencoeffs at Fourier freq
C                                    defined by NREQ, by column for
C                                    different orders of dpss. If
C                                    mean removal required, Y must
C                                    already be mean corrected on
C                                    input (see THOMLOOP_CROSS).
C
C  UR((NREQMAX/2)+1,K1-K0+1) real (i) dpswf in columns, at Fourier freq
C                                     defined by NREQ
C
C  D((NREQMAX/2)+1,K1-K0+1)  real (i) weights at Fourier freq defined by
C                                     NREQ, by column for different
C                                     orders of dpss
C
C  S((NREQ/2)+1)      real (o)  spectrum from averaging modulus sqd
C                               eigencoeffs over dpss orders
C
C  IFAULT     Integer  (o)     if IFAULT =0 then success
C                              1 if K0<0 or K1> N-1
C                              2 if N>NREQ or NREQMAX<NREQ
C
C  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
      SUBROUTINE SPECON_CROSS(N, NREQ, NREQMAX, K0, K1, CMU, Y,
     * UR, D, S, IFAULT) 
C
      IMPLICIT NONE
C
      INTEGER N, NREQ, NREQMAX, IFAULT, K, K0, K1, N2, J, JJ
C
      DOUBLE PRECISION RSUM, UR((NREQMAX/2)+1,K1-K0+1), D1J,
     * D((NREQMAX/2)+1,K1-K0+1), S((NREQ/2)+1), ZERO
C
      DOUBLE COMPLEX CMU, Y((NREQMAX/2)+1,K1-K0+1)
C
      LOGICAL QMEAN
C
      DATA ZERO/0.0D0/
C
      IFAULT=1
      IF(K0 .LT. 0 .OR. K1 .GT. N-1) RETURN
      IFAULT=2
      IF(N .GT. NREQ .OR. NREQMAX .LT. NREQ) RETURN
      K=K1-K0+1
      N2=(NREQ+1)/2
C
      DO 40 JJ=1,N2
              RSUM=ZERO
              DO 45 J=1,K
                D1J=D(JJ,J)
 45             RSUM=RSUM+D1J*ABS(Y(JJ,J))**2
 40     S(JJ)=RSUM
        IF(MOD(NREQ,2) .EQ. 0) THEN
              RSUM=ZERO
              DO 50 J=1,K
                D1J=D(N2+1,J)
 50             RSUM=RSUM+D1J*ABS(Y(N2+1,J))**2
              S(N2+1)=RSUM
        END IF
      IFAULT=0
      RETURN
      END
