C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE SPLN2(N,X,Y,C,V)
C
C   PURPOSE
C	TO EVALUATE THE FUNCTIONAL VALUES USING THE 
C	COEFFICIENTS COMPUTED BY SPLN1
C   AUTHOR
C	P.HOOD CREATED VERS 1.0   04 MAR 80
C   USEAGE
C   	CALL SPLN2(N,X,Y,C,V)
C   PARAMETERS
C	N - NUMBER OF DATA POINTS ( MUST BE GREATER THAN ONE )
C	X - ONE DIMENSIONAL ARRAY OF N INDEPENDENT VARIABLE POINTS
C	Y - ONE DIMENSIONAL ARRAY OF N DEPENDENT VARIABLE POINTS
C	C - TEMPORARY STORAGE ARRAY OF (3N-3) CELLS WHICH HOLD THE
C	    SPLINE COEFFICIENTS
C	V - ARRAY OF FIVE ELEMENTS WHERE
C		V(1) = POINT Z AT WHICH TO INTERPOLATE
C		V(2) = RETURNED VALUE OF INTERPOLATED Y(Z)
C		V(3) UNUSED
C		V(4) UNUSED
C		       ( 1.0 FOR Z < X(1)
C		V(5) = ( 3.0 FOR Z > X(N)
C		       ( 2.0 FOR X(1) < Z < X(N)
C
      DIMENSION X(N),Y(N),C(3*N-3),V(5)
      V(3) = 0.0
      V(4) = 0.0
C   CHECK FOR Z IN BOUNDS
      Z = V(1)
      IF (Z.GE.X(1)) GOTO 20
      V(5) = 1.0
      RETURN
   20 IF (Z.LE.X(N)) GOTO 30
      V(5) = 3.0
      RETURN
   30 V(5) = 2.0
C
C   DETERMINE THE INTERVAL IN WHICH Z FALLS
C
      JB = 1
      JE = N
   40 IF ((JE-JB).LE.1) GOTO 60
      L = (JB+JE)/2
      IF (Z.GT.X(L)) GOTO 50
      JE = L
      GOTO 40
   50 JB = L
      GOTO 40
   60 CONTINUE
C
C   Z LIES BETWEEN X(JB) AND X(JE) 
C
C   OVER THIS INTERVAL THE VALUE OF THE POLYNOMIAL IS COMPUTED FROM
C   THE RELATION :
C	Y(Z) = Y(JB) + A(JB)*ZZ + B(JB)*ZZ**2 + E(JB)*ZZ**3
C   THE COEFFICIENTS A(JB), B(JB), AND C(JB) ARE COMPUTED BY SPLN1 AND
C   STORED IN C(3*JB-2), C(3*JB-1), AND C(3*JB) RESPECTIVELY
C   ZZ IS THE NORMALISED ABSCISSA AND IS DEFINED BY :
C	ZZ = (Z - X(JB))/(X(JE) - X(JB))
C
      Q = X(JE) - X(JB)
      YI = Y(JB)
      ZZ = (Z - X(JB))/Q
      ZZ2 = ZZ*ZZ
      ZZ3 = ZZ2*ZZ
      V(2) = YI + C(3*JB-2)*ZZ + C(3*JB-1)*ZZ2 + C(3*JB)*ZZ3
      RETURN
      END
