C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C ***  SUBROUTINE SSNRDET(N,CS,S,PN,SNR,G,
C    1                    IERR,JERR,ISING,IDEB,BM,BM1,BM2,CMAX)
C
C ***  SUBROUTINE TO DETERMINE SIGNAL/NOISE RATIOS FROM A SPECTRAL
C ***  MATRIX AT A GIVEN FREQUENCY.
C
C *** PROGRAM TO DETERMINE THE SOLUTION (SNR VALUES) OF
C ***
C ***         C(J)*G(J) = SNR(J)/(1 + SNR(J)) , J=1,4
C ***
C ***     WHERE C(J) = (1 + Z - SNR(J))/(Z - SNR(J))
C ***     AND   Z = SUM(SNR(J))
C
C ***  REFERENCE: R.E. WHITE - GEOPHYSICAL PROSPECTING,VOL 21,NO. 4,1973
C
C ***  SUBROUTINE AUTHOR T.C.REDHAW (BP-LONDON)
C ***  UPDATE OF SNRDET BY R.E.WHITE.
C ***  REVISED  T.C. REDSHAW      29/4/85
C      1. CHANGED NAME TO SSNRDET
C      2. ADDED 2 EXTRA PARAMETERS TO CALL MAINCH AND CHANGED NAME
C         OF MAINCH TO SMAINCH.
C ***  REVISED  T.C. REDSHAW     13/5/85
C      1. ADDED EXTRA PARAMETERS TO CALLING SEQUENCE SO THAT DEBIASING
C         OCCURS WITHIN THIS SUBROUTINE AND NOT IN THE CALLING ROUTINE.
C         THIS MEANS SSNRDET NEED ONLY BE CALLED ONCE INSTEAD OF TWICE
C         PREVIOUSLY AND SAVES ON WASTED CALCULATION.     
C
C
C ***  ITERATION METHOD WITH A CHECK THAT POSITIVE SOLUTION EXISTS.
C ***  IF NO POSITIVE SOLUTION THEN THE COHERENCY VALUES ARE MODIFIED UNTIL
C ***  ALL OF THE SNR ARE POSITIVE.
C
C ***  INPUT PARAMETERS
C ***  N - NUMBER OF TRACES.
C ***  CS - SPECTRAL MATRIX.
C ***  JERR REQUIRED BY SUBROUTINE SMAINCH
C ***  ISING - REQUIRED BY SUBROUTINE SMAINCH
C ***  IDEB - FLAG FOR DEBIASING OF COHERENCE ESTIMATES. (0=DEBIAS)
C ***  BM,BM1,BM2 - ALL USED IN OBTAINING DEBIASED ESTIMATES OF THE 
C ***               COHERENCES.
C ***  CMAX - CONTAINS INFO ON WHITE NOISE ADDED TO CS (2/8/85)
C
C ***  OUTPUT PARAMETERS.
C
C ***  G - MULTIPLE COHERENCE(SQUARED)
C ***  SNR - SIGNAL TO NOISE POWER RATIO
C ***  S - SIGNAL POWER
C ***  PN - NOISE POWER
C ***  IERR - ERROR FLAG. IERR = 1-INPUT COHERENCY VALUES CHANGED SO A SOLUTION
C                                  COULD BE FOUND.
C                              = 2-MORE THAN 6 INPUT TRACES. HARDWIRED BUFFERS
C                                  TOO SMALL.
C                              = 3-NO SOLUTION FOUND DESPITE MAXCHG CHANGES
C                                  TO THE INPUT COHERENCIES. SOLUTION OBTAINED
C                                  BY ASSUMING Z = 1.                                
C
C ***  NOTE THE CROSS SPECTRAL MATRIX CS IS ASSUMED TO HAVE REAL PARTS OF
C ***  THE CROSS SPECTRA ABOVE THE MAIN DIAGONAL, IMAGINARY BELOW.
C
        SUBROUTINE SSNRDET(N,CS,S,PN,SNR,G,CI,SPACE,XP,SP,
     1                     IERR,JERR,ISING,IDEB,BM,BM1,BM2,CMAX)
C
#include <f77/iounit.h>

c	REAL*4 SNR(12),PN(12),S(12),G(12),CMAX(12)
c	REAL*4 CS(12,12),CI(12,12),SPACE(12,12),XP(12,12),SP(12,12)

        real   CS(N,N), S(N), PN(N), SNR(N), G(N), CMAX(N)
        real   SPACE(N,N), CI(N,N), XP(N,N), SP(N,N)

        double precision AD,BD,CD,DD
        pointer (wkAD, AD(1))
        pointer (wkBD, BD(1))
        pointer (wkCD, CD(1))
        pointer (wkDD, DD(1))
        integer ier, ierrt, abort, jsz
        data    ier/0/, ierrt/0/, abort/0/
C
        call sizefloat(jsz)
        call galloc (wkAD, 2*jsz*N*N, ier, abort)
        ierrt = ierrt + ier
        call galloc (wkBD, 2*jsz*N*N, ier, abort)
        ierrt = ierrt + ier
        call galloc (wkCD, 2*jsz*N*N, ier, abort)
        ierrt = ierrt + ier
        call galloc (wkDD, 2*jsz*N*N, ier, abort)
        ierrt = ierrt + ier

      if (ierrt .ne. 0) then
         write(LERR,*)'FATAL ERROR from saneusp:'
         write(LERR,*)'Unable to allocate memory in routine ssnrdet'
         write(LER ,*)'FATAL ERROR from saneusp:'
         write(LER ,*)'Unable to allocate memory in routine ssnrdet'
         call ccexit (666)
      endif
C
	IOUT = 6
	IERR = 0
	ICHNG = 0
c	IF (ABS(N) .GT. 12) THEN
c	 IERR = 2
c	 GOTO 9990
c	ENDIF
C  
C *** CHECK TO SEE IF MULTIPLE COHERENCY ARE ALEADY DETERMINED (N<0)
C
        IF (N .LT. 0) THEN
	         N = -N
        	 GOTO 15
        ENDIF
        NL1 = N-1
        DO 5 I=1,NL1
	 SPACE(I,I) = CS(I,I)
	 SP(I,I) = 0.0
	 K = I+1
	 DO 6 J=K,N
 	  SPACE(I,J) = CS(I,J)
	  SP(I,J) = CS(J,I)
	  SP(J,I) = - SP(I,J)
	  SPACE(J,I) = SPACE(I,J)
    6    CONTINUE
    5   CONTINUE
	SPACE(N,N) = CS(N,N)
	SP(N,N) = 0.0
C
C
C
  	CALL SMAINCH(SPACE,SP,CI,XP,N,JERR,ISING,
     1               AD,BD,CD,DD)
	DO 8 I=1,N
   	 IF (CI(I,I) .EQ. 0.0) THEN
          G(I) = 0.999
	  GOTO 8
	 ENDIF
         G(I) = 1.0-1.0/(CS(I,I)*CI(I,I))
         IF (G(I) .GT. 1.0) THEN
	  G(I) = 0.999
	  WRITE(IOUT,1000)CS(I,I),CI(I,I)
 1000     FORMAT(5X,'**WARNING CORRELATION GREATER THAN ONE',
     1    ' FROM THESE SPECTRAL MATRIX AND INVERSE DIAGONALS'
     2    ,/,5X,E12.4,5X,E12.4)
         ENDIF
    8   CONTINUE
C
C ***  OBTAIN DEBIASED ESTIMATES IF REQUIRED
C
        IF (IDEB .NE. 0)GOTO 15
	INZER=0
        DO 40 K=1,N
         SPACE(1,K) = (G(K)-BM)/BM1
         IF (SPACE(1,K) .LT. 0.01) SPACE(1,K) = 0.01*G(K)/BM2
	 IF(SPACE(1,K).LT.0.01)THEN
		G(K)=0.0
		INZER=INZER+1
		GO TO 40
	 ENDIF
         G(K) = SPACE(1,K)
   40   CONTINUE
	IF(INZER.GE.N-1)THEN
		DO I=1,N
			G(I)=0.
			SNR(I)=0.
		ENDDO
	ENDIF
	IF(INZER.EQ.N-2)THEN
		AVG=0.
		DO I=1,N
			AVG=AVG+G(I)
			SNR(I)=0.
		ENDDO
		DO I=1,N
			IF(G(I).NE.0.)THEN
				G(I)=AVG/2.
				SNR(I)=G(I)/(1.0-G(I))
			ENDIF
		ENDDO
	ENDIF
        IF (INZER .GE. N-2) GOTO 99
C
   15   Z = 0.0
C
C ***  OBTAIN STARTING APPROXIMATION FOR ITERATION.
C
C ***  M = MAXIMUM NUMBER OF ITERATIONS.
C ***  MAXCHG = MAXIMUM NUMBER OF TIMES THE INPUT CORRELATION VALUES
C ***           CAN BE CHANGED.
C 
  	M = 30
        MAXCHG = 5
C
C ***  STORE COHERENCIES IN SPACE(1,J) IN CASE OF NO SOLUTION FOUND
C ***  EVEN AFTER MAXCHG ALTERATIONS OF THE MAXIMUM COHERENCIES.
C        
        DO 10 J=1,N
          IF (G(J) .GT. 0.999) G(J) = 0.999 
          SNR(J) = G(J)/(1. - G(J))
          SPACE(1,J) = G(J)
  	  Z = Z + SNR(J)
          PN(J) = 0.0
   10   CONTINUE
	I = 1
	DO 20 I=2,M
	ICON = 0
	DO 25 K=1,N
         IF (ABS(SNR(K)-PN(K)) .GT. 0.0001)ICON = 1 
	 PN(K) = SNR(K)
   25   CONTINUE
	IF (ICON .EQ. 0) GOTO 99
         DO 30 J=1,N
          F = (1. + Z - SNR(J))/(Z - SNR(J))
	  AMT1 = F*G(J)
	  IF (ABS(AMT1-1.0) .LT. 0.00001) THEN
           SNR(J) = 9999.0
           GOTO 26
 	  ENDIF	
          SNR(J) = AMT1/(1. - AMT1)
      	  IF (SNR(J) .LT. 0.0) THEN
           IERR = 1
           GMAX = 0.0
       	   IGMND = 0
           DO 50 K=1,N
	    IF (G(K) .GT. GMAX) THEN
	     GMAX = G(K)
             IGMND = K
            END IF
   50       CONTINUE
           G(IGMND) = G(IGMND)*0.95
	   ICHNG = ICHNG + 1
           IF (ICHNG .LT. MAXCHG) GOTO 16
           IERR = 3
C
C ***    NO SOLUTION DETERMINED DESPITE CHANGING THE CORRELATION MAXCHG
C ***    TIMES. IN THIS CASE SET Z=1 AND USE THE VALUES OBTAINED.
C
         DO 90 L=1,N
          SNR(L) = SPACE(1,L)/(1.0-SPACE(1,L))
   90    CONTINUE
         GOTO 99
   16             CONTINUE 
           GOTO 15
   	  ENDIF
   26     Z = Z + SNR(J)-PN(J)	
   30    CONTINUE
   20   CONTINUE
C
C ***  CONVERGENCE OBTAINED OR ENOUGH ITERATIONS PERFORMED.
C	TAKE OUT HIGH FREQ STABILISING
C
   99                  CONTINUE
	SNLL=1.0E-06
C
C	RESET SMALL VALUES OF S/N, S
C
        DO 80 I=1,N
        	PN(I) = (CS(I,I)-CMAX(I)*0.01)/(1.0+SNR(I))
		IF (SNR(I) .GT. 9000.) THEN
			S(I) = CS(I,I)-CMAX(I)*0.01
		ELSE IF (SNR(I).LT.SNLL)THEN
			S(I)=PN(I)*SNLL
			SNR(I)=SNLL
		ELSE
			S(I) = SNR(I)*PN(I)
		END IF
   80   CONTINUE
C 
 9990   continue
        call gfree (wkAD)
        call gfree (wkBD)
        call gfree (wkCD)
        call gfree (wkDD)
        RETURN       
        END    
