C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE STDPOLD(N, V, STD, II)
C
C  ALGORITHM AS000.0 APPL. STATIST. (1987)
C
C  SCALES THE DISCRETE PROLATE SPHEROIDAL SEQUENCE AND SETS THE 
C  POLARITY TO AGREE WITH SLEPIAN'S CONVENTION.
C
C  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
C  N      Integer             input        length of dpss sequence
C  V      Real(N)             input        eigenvector (dpss) to standardize
C                            output        unit energy dpss conforming to
C                                          Slepian's form
C  STD    Real                input        scaling factor to divide by, to
C                                          make unit energy (if not already)
C  K      Integer             input        the order of the dpss 0=<K=<N-1
C
C  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
      INTEGER N, I, L, II
      DOUBLE PRECISION V(N), RN, STD, DSUM, DWSUM, ZERO, ONE, 
     * TWO, ZFLOAT
C
      DATA ZERO, ONE, TWO/0.0D0, 1.0D0, 2.0D0/
C
      ZFLOAT(I)=DBLE(I)
C
      RN=ZFLOAT(N)
      DSUM=ZERO
      DWSUM=ZERO
      DO 5 L=1,N
             V(L)=V(L)/STD
             DSUM=DSUM+V(L)
  5          DWSUM=DWSUM+V(L)*(RN-ONE-TWO*ZFLOAT(L-1))
      IF(((MOD(II,2).EQ.0).AND.(DSUM.LT.ZERO)).OR.
     *     ((MOD(II,2).EQ.1).AND.(DWSUM.LT.ZERO))) THEN
      DO 10 L=1,N
 10          V(L)=-V(L)
      END IF
      RETURN
      END
